using Server.Mobiles;
using Server.Items;
using Server.Regions;
using Server.Commands;

namespace Server.Scripts.Commands
{
	public class BandSelf2
	{
		public static void Initialize()
		{
			CommandSystem.Register( "enhancedbandself", AccessLevel.Player, new CommandEventHandler( BandSelf_OnCommand ) );
			CommandSystem.Register( "ebs", AccessLevel.Player, new CommandEventHandler( BandSelf_OnCommand ) );
		}
		//Command will search the userers backpack for TypeOf(Bandage), and if true, applies to self.
		//If false, will return a msg announcing to the player they are out of bandage.
		//Should also give a warning if bandage count is under ??
		public static void BandSelf_OnCommand(CommandEventArgs e )
		{
			Mobile pm = e.Mobile;
			Region region = Region.Find( pm.Location, pm.Map );
			
			if ( region != null && region.IsPartOf( typeof( RaidRegion ) ) )
			{
				pm.SendMessage ( "Zde nelze tento prikaz pouzit!" );
				return;
			}			
			
			Item band = pm.Backpack.FindItemByType(typeof( EnhancedBandage ));				

			if ( band != null )
			{
				if ( EnhancedBandageContext.GetContext( pm ) == null && BandageContext.GetContext( pm ) == null )
				{
               EnhancedBandage.BandSelfCommandCall( pm, band );
               
    				if ( band.Amount <= 5 )
    					pm.SendMessage( 32, "Warning, your enhanced bandage count is currently {0}!!", band.Amount );				
            }
            else
				  pm.SendLocalizedMessage( 500119 ); //You must wait to perform another action.
			}
			else
			{
				pm.SendMessage( 1152, "You have no enhanced bandages left to use!" );
			}
		}
	}
}