using System;
using Server;
using Server.Items;

namespace Server.Mobiles
{
	public class AncestralLich : RaidBoss
	{
		public override Point3D SpawnLoc{ get{ return new Point3D( 5143, 1879, 0 ); } }
		
		[Constructable]
		public AncestralLich() : base( AIType.AI_Melee, FightMode.Strongest )
		{
			Body = 79;
			BaseSoundID = 412;
			Name = "Morax";
			Title = " the Ancestral Lich";

			SetStr( 350 );
			SetDex( 100 );
			SetInt( 300 );

			SetHits( 10000 );
			SetStam( 302, 400 );

			SetDamage( 21, 33 );

			SetDamageType( ResistanceType.Physical, 75 );
			SetDamageType( ResistanceType.Cold, 25 );

			SetResistance( ResistanceType.Physical, 70 );
			SetResistance( ResistanceType.Fire, 75 );
			SetResistance( ResistanceType.Cold, 65 );
			SetResistance( ResistanceType.Poison, 75 );
			SetResistance( ResistanceType.Energy, 75 );

			SetSkill( SkillName.Anatomy, 100.0 );
			SetSkill( SkillName.EvalInt, 120.0 );
			SetSkill( SkillName.Magery, 120.0 );
			SetSkill( SkillName.Meditation, 130.0 );
			SetSkill( SkillName.MagicResist, 100.0 );
			SetSkill( SkillName.Tactics, 120.0 );
			SetSkill( SkillName.Wrestling, 120.0 );

			Fame = 30000;
			Karma = 30000;

			VirtualArmor = 100;
		}
		
		public override bool AlwaysMurderer{ get{ return true; } }

		public override void GenerateLoot()
		{
			AddLoot( LootPack.UltraRich, 5 );
		}
		
		// 		public override void OnGaveMeleeAttack( Mobile defender )
		// 		{
		// 			base.OnGaveMeleeAttack( defender );
		// 
		// 			defender.Damage( Utility.Random( 20, 10 ), this );
		// 			defender.Stam -= Utility.Random( 20, 10 );
		// 			defender.Mana -= Utility.Random( 20, 10 );
		// 		}
		// 
		// 		public override void OnGotMeleeAttack( Mobile attacker )
		// 		{
		// 			base.OnGotMeleeAttack( attacker );
		// 			attacker.Damage( Utility.Random( 20, 10 ), this );
		// 			attacker.Stam -= Utility.Random( 20, 10 );
		// 			attacker.Mana -= Utility.Random( 20, 10 );
		// 		}
		
		public override void OnAfterDelete()
		{
			// 			if ( m_Timer != null )
			// 				m_Timer.Stop();
			// 
			// 			m_Timer = null;
			Timer.DelayCall( TimeSpan.FromSeconds(10.0), new TimerStateCallback(RaidBoss.RespawnBoss), new object[]{ (RaidBoss) new AncestralLich() } );

			base.OnAfterDelete();
		}

		public AncestralLich( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();

			switch ( version )
			{
				case 0:
					{
						Blessed = true;
						break;
					}
			}
		}
	}
}
