using System;
using System.Collections;
using System.Collections.Generic;
using Server;
using Server.Items;
using Server.ContextMenus;
using Server.Regions;

namespace Server.Mobiles
{
	public abstract class RaidBoss : BaseCreature
	{
		private Mobile m_Targeted;
		
		public Mobile Targeted{ get{ return m_Targeted; } set{ m_Targeted = value; } }
		
		public virtual Point3D SpawnLoc{ get{ return new Point3D( 0, 0, 0 ); } }
		public virtual Map SpawnMap{ get{ return Map.Trammel; } }
		
		public RaidBoss( AIType aiType ) : this( aiType, FightMode.Closest )
		{
		}

		public RaidBoss( AIType aiType, FightMode mode ) : base( aiType, mode, 18, 1, 0.1, 0.2 )

		{
			Blessed = true;
			RangeHome = 2;
			SetSkill( SkillName.DetectHidden, 150.0 );
		}
		
		public override bool BleedImmune{ get{ return true; } }
		public override Mobile ConstantFocus{ get{ return m_Targeted; } }
		public override bool BardImmune { get { return true; } }
		public override bool Unprovokable { get { return true; } }
		public override bool Uncalmable { get { return true; } }
		public override Poison PoisonImmune { get { return Poison.Lethal; } }
		public override bool ReacquireOnMovement { get { return true; } }
		public override bool AutoDispel { get { return true; } }
		public override bool IsNotScaredOfDeath { get { return true; } } //neutika pri malem poctu hp
		
		public override void AlterMeleeDamageFrom( Mobile from, ref int damage )
		{
			if ( from.AccessLevel == AccessLevel.Player )
			{
				if ( RaidRegion.PlayerRole( from ) == RaidRegion.RoleType.Tank )
					damage /= 2; //polovicni dmg pro tanky
				else if ( RaidRegion.PlayerRole( from ) == RaidRegion.RoleType.Healer || RaidRegion.PlayerRole( from ) == RaidRegion.RoleType.Caster )
					damage -= (int) ( damage * 0.8 ); //20% dmg pro castery
			}
		}
		
		public override void AlterSpellDamageFrom(Mobile from, ref int damage)
		{
			if ( from.AccessLevel == AccessLevel.Player && RaidRegion.PlayerRole( from ) != RaidRegion.RoleType.Caster )
				damage -= (int) ( damage * 0.8 );
		}

		// 		public override void OnAfterDelete()
		// 		{
		// 			if ( m_Timer != null )
		// 				m_Timer.Stop();
		// 
		// 			m_Timer = null;
		// 
		// 			base.OnAfterDelete();
		// 		}

      private DateTime m_NextUse;
      
      public override void OnThink()
		{
			if ( DateTime.Now > m_NextUse )
			{
             Say( "Com: {0}, Targ: {1}", ( Combatant == null ) ? "null" : Combatant.Name, ( m_Targeted == null ) ? "null" : m_Targeted.Name );
             m_NextUse = DateTime.Now + TimeSpan.FromSeconds( 5.0 );
         }
          
         if ( this.Blessed || ( m_Targeted != null && ( !CanBeHarmful( m_Targeted ) || !m_Targeted.Alive || Map != m_Targeted.Map || !CanSee( m_Targeted ) ) ) )
			{
				m_Targeted = null;
				Combatant = null;
				FocusMob = null;
				base.OnThink();
				return;
			}
			
			if ( m_Targeted == null && Combatant == null )
			{
				//Najit tanka
				Region region = Region.Find( this.Location, this.Map );
				
				if ( region != null )
				{
					List<Mobile> players = RaidRegion.PlayersIn( region, true );
					
					if ( players.Count < 1 ) //zadni zivi hraci v regionu
					{
						RaidRegion.ResetRaid( region, true );
						return;
					}
					
					foreach ( Mobile m in players )
					{
						if ( m != null && RaidRegion.PlayerRole( m ) == RaidRegion.RoleType.Tank && this.CanSee( m ) )
						{
							m_Targeted = m;
							Combatant = m_Targeted;
							FocusMob = m_Targeted;
							Say( "NAST - Com: {0}, Targ: {1}", ( Combatant == null ) ? "null" : Combatant.Name, ( m_Targeted == null ) ? "null" : m_Targeted.Name );
						}
					}
				}
				
				base.OnThink();
				return;
			}
			else if ( m_Targeted == null && Combatant != null )
			{
				if ( Combatant is BaseCreature )
				{
					BaseCreature bc = (BaseCreature)Combatant;

					if ( bc.Controlled && bc.ControlMaster != null )
						m_Targeted = bc.ControlMaster;
					else if ( bc.Summoned && bc.SummonMaster != null )
						m_Targeted = bc.SummonMaster;
					else
						m_Targeted = Combatant;
				}
				else
					m_Targeted = Combatant;
				
				base.OnThink();
				return;
			}

			Combatant = m_Targeted;
			FocusMob = m_Targeted;

			if ( AIObject != null )
				AIObject.Action = ActionType.Combat;

			base.OnThink();
		}

		public override void AddCustomContextEntries( Mobile from, List<ContextMenuEntry> list )
		{
			if ( from.Alive && this.Blessed )
				list.Add( new StartEncounterEntry( this, from ) );

			base.AddCustomContextEntries( from, list );
		}
		
		private class StartEncounterEntry : ContextMenuEntry
		{
			private RaidBoss m_Boss;
			private Mobile m_From;

			public StartEncounterEntry( RaidBoss boss, Mobile from ) : base( 6170, 12 )
			{
				m_Boss = boss;
				m_From = from;
			}

			public override void OnClick()
			{
				m_Boss.Blessed = false;
				m_Boss.Combatant = m_From;
				m_Boss.Targeted = m_From;
			}
		}
		
		public static void RespawnBoss( object state )
		{
			object[] args = (object[])state;
			RaidBoss boss = (RaidBoss) args[0];

			if ( boss != null )
			{
				boss.MoveToWorld( boss.SpawnLoc, boss.SpawnMap );
				boss.Home = boss.SpawnLoc;
				boss.FixedParticles( 0x375A, 9, 20, 5049, EffectLayer.Head );
				boss.PlaySound( 0x1FD );
			}
		}
		
		//     public class ThreatStore : IComparable
		//     {
		//         public Mobile m_Mobile;
		//         public int m_Damage;
		//         public bool m_HasRight;
		// 
		//         public ThreatStore(Mobile m, int damage)
		//         {
		//             m_Mobile = m;
		//             m_Damage = damage;
		//         }
		// 
		//         public int CompareTo(object obj)
		//         {
		//             ThreatStore ds = (ThreatStore)obj;
		// 
		//             return ds.m_Damage - m_Damage;
		//         }
		//     }
		
		public RaidBoss( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
			
			// 			writer.Write( m_IsChampion );
			// 			writer.Write( m_Range );
			// 			writer.Write( m_DropMin );
			// 			writer.Write( m_DropMax );
			// 			writer.Write( (int) m_DropType );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
			
			// 			switch( version )
			// 			{
			// 				case 1:
			// 					{
			// 						m_IsChampion = reader.ReadBool();
			// 						m_Range = reader.ReadInt();
			// 						m_DropMin = reader.ReadInt();
			// 						m_DropMax = reader.ReadInt();
			// 						m_DropType = (ChampDrop)reader.ReadInt();
			// 						goto case 0;
			// 					}
			// 				case 0:
			// 					{
			// 						if ( version < 1 )
			// 						{
			// 							m_IsChampion = false;
			// 							m_Range = 12;
			// 							m_DropMin = 75;
			// 							m_DropMax = 300;
			// 							m_DropType = ChampDrop.Gold;
			// 						}
			// 						break;
			// 					}
			// 			}
		}
	}
}
