using System;
using Server;
using Server.Network;
using Server.Mobiles;
using Server.Gumps;
using Server.Regions;
using System.Collections;
using System.Collections.Generic;

namespace Server.Items
{
	public class RaidGate : ConfirmationMoongate
	{
		[Constructable]
		public RaidGate()
		{
			Hue = 1581;
			Dispellable = false;

			Name = "raid entrance gate";
		}
		
		public override void BeginConfirmation( Mobile from )
		{
			if ( from.AccessLevel > AccessLevel.Player )
				UseGate( from );
			else
			{
				from.CloseGump( typeof( RaidGateGump ) );
				from.SendGump( new RaidGateGump( this ) );
			}
		}
		
		public override void OnGateUsed( Mobile m )
		{
			m.MagicDamageAbsorb = 0;
			m.MeleeDamageAbsorb = 0;
		}
		
		public RaidGate( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int)0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
		
		private class RaidGateGump : Gump
		{
			private RaidGate m_gate;
			
			public RaidGateGump( RaidGate gate ) : base(20, 30)
			{
				m_gate = gate;
				
				if ( m_gate == null )
					return;
				
				if ( m_gate.Name == null )
					m_gate.Name = "raid entrance gate";
				
				this.Closable=true;
				this.Disposable=true;
				this.Dragable=true;
				this.Resizable=false;
				this.AddPage(0);
				this.AddBackground(0, 0, 258, 208, 3500);
				this.AddHtml( 18, 10, 218, 25, @"<center>" + m_gate.Name + @"</center>", (bool)false, (bool)false);
				this.AddLabel(22, 41, 0, @"Vyber svoji roli:");
				this.AddRadio(20, 65, 210, 211, false, (int)Buttons.Tank);
				this.AddRadio(20, 90, 210, 211, false, (int)Buttons.Healer);
				this.AddRadio(20, 115, 210, 211, false, (int)Buttons.Melee);
				this.AddRadio(20, 140, 210, 211, false, (int)Buttons.Caster);
				this.AddLabel(45, 66, 0, @"Tank");
				this.AddLabel(45, 91, 0, @"Healer");
				this.AddLabel(45, 116, 0, @"Damage (Physical)");
				this.AddLabel(45, 141, 0, @"Damage (Magic)");
				this.AddButton(175, 170, 247, 248, (int)Buttons.Okay, GumpButtonType.Reply, 0);
				this.AddButton(19, 170, 242, 241, (int)Buttons.Cancel, GumpButtonType.Reply, 0);
			}
			
			public enum Buttons
			{
				Cancel,
				Okay,
				Tank,
				Healer,
				Melee,
				Caster
			}
			
			private static void ClearTalisman( Mobile m )
			{
				Item tal = m.FindItemOnLayer( Layer.Talisman ) as Item;
				
				if ( tal == null )
					return;
				
				if ( tal is RoleTalisman )
					tal.Delete();
				else
					m.AddToBackpack( tal );
			}
			
			public override void OnResponse( NetState state, RelayInfo info )
			{
				switch( info.ButtonID )
				{
					case (int)Buttons.Okay:
						{
							Mobile from = state.Mobile;

							if ( from == null || m_gate == null || info.Switches.Length != 1 )
								return;
							else if ( !from.InRange( m_gate.GetWorldLocation(), 1 ) )
							{
								from.SendLocalizedMessage ( 500295 ); // You are too far away to do that.
								return;
							}
							
							if ( from.HasTrade || from.Holding != null || !from.Alive )
							{
								from.SendMessage ( "Nelze projit jako duch" );
								return;
							}
							
							if ( from.IsBodyMod || Spells.Spellweaving.ArcaneForm.UnderTransformation( from ) || Spells.Ninjitsu.AnimalForm.UnderTransformation( from )
							    || Spells.Necromancy.TransformationSpell.UnderTransformation( from ) || !from.CanBeginAction( typeof( Spells.Seventh.PolymorphSpell ) ) )
							{
								from.SendMessage ( "Nesmis byt pod vlivem transformacnich kouzel" );
								return;
							}
							
							Region region = Region.Find( m_gate.Target, m_gate.TargetMap );
							
							if ( region != null && !region.IsPartOf( typeof( RaidRegion ) ) )
							{
								from.SendMessage ( "Chybne nastavena gate. Kontaktuj GM!" );
								return;
							}
							
							if ( RaidRegion.EncounterActive( region ) )
							{
								from.SendMessage ( "Prave probiha souboj s bossem proto nelze projit!" );
								return;
							}
							
							List<Mobile> players = region.GetPlayers();
							
							int count = 0;
							int tanks = 0;
							int healers = 0;
							
							foreach ( Mobile m in players )
							{
								if ( m is PlayerMobile && m.AccessLevel < AccessLevel.Counselor )
								{
									RaidRegion.RoleType role = RaidRegion.PlayerRole( m );
									count++;
									
									if ( role == RaidRegion.RoleType.Tank )
										tanks++;
									else if ( role == RaidRegion.RoleType.Healer )
										healers++;
								}
							}
							
							if ( count > 10 )
							{
								from.SendMessage ( "V tomto raidu je jiz maximalni pocet hracu!" );
								return;
							}
							
							
							RoleTalisman tal;
							ClearTalisman( from );
							
							if (info.IsSwitched( (int)Buttons.Tank) )
							{
								if ( tanks > 1 )
								{
									from.SendMessage ( "V tomto raidu je jiz maximalni pocet hracu v roli TANK!" );
									return;
								}
								
								tal = new RoleTalisman();
								tal.Movable = false;
								tal.BlessedFor = from;
								tal.Role = RoleTalisman.RoleType.Tank;
								from.EquipItem( tal );
							}
							else if (info.IsSwitched( (int)Buttons.Healer) )
							{
								if ( healers > 2 )
								{
									from.SendMessage ( "V tomto raidu je jiz maximalni pocet hracu v roli HEALER!" );
									return;
								}
								
								tal = new RoleTalisman();
								tal.Movable = false;
								tal.BlessedFor = from;
								tal.Role = RoleTalisman.RoleType.Healer;
								from.EquipItem( tal );

							}
							else if (info.IsSwitched( (int)Buttons.Melee) )
							{
								tal = new RoleTalisman();
								tal.Movable = false;
								tal.BlessedFor = from;
								tal.Role = RoleTalisman.RoleType.Melee;
								from.EquipItem( tal );
							}
							else if (info.IsSwitched( (int)Buttons.Caster) )
							{
								tal = new RoleTalisman();
								tal.Movable = false;
								tal.BlessedFor = from;
								tal.Role = RoleTalisman.RoleType.Caster;
								from.EquipItem( tal );
							}
							
							m_gate.EndConfirmation( from );
							break;
						}
				}
			}
		}
	}
}
