using System;
using System.Xml;
using Server;
using Server.Items;
using Server.Mobiles;
using Server.Gumps;
using Server.Spells;
using Server.Spells.First;
using Server.Spells.Second;
using Server.Spells.Third;
using Server.Spells.Fourth;
using Server.Spells.Fifth;
using Server.Spells.Sixth;
using Server.Spells.Seventh;
using Server.Spells.Eighth;
using Server.Spells.Chivalry;
using System.Collections;
using System.Collections.Generic;


namespace Server.Regions
{
	public class RaidRegion : DungeonRegion
	{
		public enum RoleType
		{
			None,
			Tank,
			Healer,
			Melee,
			Caster
		}
		
		private Point3D m_EntranceLocation;
		private Map m_EntranceMap;

		public Point3D EntranceLocation{ get{ return m_EntranceLocation; } set{ m_EntranceLocation = value; } }
		public Map EntranceMap{ get{ return m_EntranceMap; } set{ m_EntranceMap = value; } }

		public RaidRegion( XmlElement xml, Map map, Region parent ) : base( xml, map, parent )
		{
			XmlElement entrEl = xml["entrance"];

			Map entrMap = map;
			ReadMap( entrEl, "map", ref entrMap, false );

			if ( ReadPoint3D( entrEl, entrMap, ref m_EntranceLocation, false ) )
				m_EntranceMap = entrMap;
		}
		
		public override bool OnBeginSpellCast( Mobile m, ISpell s )
		{
			if ( m.AccessLevel > AccessLevel.Player || !m.Player )
				return base.OnBeginSpellCast( m, s );
			
			if ( s is GateTravelSpell || s is RecallSpell || s is MarkSpell || s is SacredJourneySpell || s is InvisibilitySpell ||
			    s is AirElementalSpell || s is EarthElementalSpell || s is FireElementalSpell || s is SummonDaemonSpell || s is WaterElementalSpell ||
			    s is Server.Spells.Necromancy.NecromancerSpell || s is EnergyVortexSpell || s is WallOfStoneSpell || s is IncognitoSpell ||
			    s is ResurrectionSpell || s is BladeSpiritsSpell || s is SummonCreatureSpell || s is MagicTrapSpell || s is PolymorphSpell || s is MagicLockSpell )
			{
				m.SendLocalizedMessage( 501802 ); // Thy spell doth not appear to work...
				return false;
			}
			else if ( PlayerRole( m ) != RoleType.Healer &&
			         ( s is HealSpell || s is ArchCureSpell || s is ArchProtectionSpell || s is GreaterHealSpell || s is AgilitySpell || s is CunningSpell
			          || s is CureSpell || s is StrengthSpell || s is BlessSpell || s is CunningSpell || s is DispelSpell ) )
			{
				m.SendMessage ( "Toto kouzlo smi pouzivat jen healer" );
				return false;
			}
			else if ( PlayerRole( m ) != RoleType.Caster &&
			         ( s is EarthquakeSpell/* || s is DispelFieldSpell*/ || s is MindBlastSpell || s is ParalyzeSpell || s is PoisonFieldSpell || s is ClumsySpell
			          || s is FeeblemindSpell || s is MagicArrowSpell || s is WeakenSpell || s is FireFieldSpell || s is LightningSpell || s is ManaDrainSpell
			          || s is HarmSpell || s is EnergyFieldSpell || s is FlameStrikeSpell || s is ChainLightningSpell || s is ManaVampireSpell || s is MassDispelSpell
			          || s is MeteorSwarmSpell || s is EnergyBoltSpell || s is ExplosionSpell || s is MassCurseSpell || s is ParalyzeFieldSpell
			          || s is FireballSpell || s is PoisonSpell || s is TeleportSpell/* || s is WallOfStoneSpell*/ || s is MassCurseSpell || s is ParalyzeFieldSpell ) )
			{
				m.SendMessage ( "Toto kouzlo smi pouzivat jen caster" );
				return false;
			}
			
			
			return base.OnBeginSpellCast( m, s );
		}

		public override bool AllowHousing( Mobile from, Point3D p )
		{
			return false;
		}

		public override void OnEnter( Mobile m )
		{
			if ( m is PlayerMobile && ((PlayerMobile)m).Young )
				m.SendGump( new YoungDungeonWarning() );
		}
		
		public override bool OnMoveInto( Mobile m, Direction d, Point3D newLocation, Point3D oldLocation )
		{
			if ( !base.OnMoveInto( m, d, newLocation, oldLocation ) )
				return false;

			if ( m.AccessLevel >= AccessLevel.Counselor || Contains( oldLocation ) )
				return true;

			return true; //ROLE TALISMAN CHECK
		}
		
		public override void OnLocationChanged( Mobile m, Point3D oldLocation )
		{
			if ( m.AccessLevel <= AccessLevel.Player && PlayerRole( m ) == RoleType.None )
			{
            m.Location = this.GoLocation;
            m.Map = this.EntranceMap;
            m.SendMessage( "V raid regionu nelze odlognout." );
            return;
         }
			
         base.OnLocationChanged( m, oldLocation );
		}
		
		public override void OnExit( Mobile m )
		{
			Item tal = m.FindItemOnLayer( Layer.Talisman ) as Item;

			if ( tal is RoleTalisman )
				tal.Delete();
		}

		public override bool CanUseStuckMenu( Mobile m )
		{
			return false;
		}
		
		public override bool OnResurrect( Mobile m )
		{
			if ( m.AccessLevel == AccessLevel.Player )
			{
				m.SendMessage("Zde nelze ozivovat");
				return false;
			}

			return true;
		}
		
		public override bool OnDoubleClick(Mobile m, object o)
		{
			if ( m.AccessLevel > AccessLevel.Player )
				return base.OnDoubleClick(m, o);
			
			if ( o is BaseMagicalFood || ( PlayerRole( m ) != RoleType.Healer && ( o is Bandage || o is EnhancedBandage ) )
			    || o is SuperPotion || o is TotalManaRefreshPotion )
			{
				m.SendMessage( "Tento predmet zde nemuzes pouzit" );
				return false;
			}
			
			if ( o is BasePotion )
			{
				if ( !m.BeginAction( typeof( BasePotion ) ) )
				{
					m.SendMessage( "Jeste nemuzes lektvar pouzit" );
					return false;
				}
				else
					Timer.DelayCall( TimeSpan.FromMinutes( 2.0 ), new TimerStateCallback( ReleasePotionLock ), m );
			}

			return base.OnDoubleClick(m, o);
		}
		
		public override bool AllowBeneficial(Mobile from, Mobile target)
		{
			if ( from.AccessLevel == AccessLevel.Player && ( PlayerRole( from ) != RoleType.Healer && target is PlayerMobile ) )
			{
				from.SendMessage("You cannot perform benificial acts on your target.");
				return false;
			}

			return base.AllowBeneficial(from, target);
		}
		
		public override bool OnSkillUse( Mobile from, int Skill )
		{
			if ( from.AccessLevel == AccessLevel.Player )
			{
				//jen healer muze pouzit Healing
				if ( PlayerRole( from ) != RoleType.Healer && Skill == ( (int)SkillName.Healing ) )
				{
					from.SendMessage("Pouze healer muze pouzit healing.");
					return false;
				}
				
				return base.OnSkillUse( from, Skill );
			}
			
			return base.OnSkillUse( from, Skill );
		}
		
		public override bool OnDamage( Mobile from, ref int Damage )
		{
			//Tank o 30% mensi dmg
			if ( from.AccessLevel == AccessLevel.Player && PlayerRole( from ) == RoleType.Tank )
				Damage -= (int) ( Damage * 0.3 );
			
			return base.OnDamage( from, ref Damage );
		}
		
		
		
		public override bool OnDeath( Mobile m )
		{
			List<Mobile> players = PlayersIn( (Region) this, true );
			
			//Smrt hrace
			if ( m.AccessLevel == AccessLevel.Player && m.Player )
			{
				if ( players.Count < 2 ) //Vsichni hraci mrtvi
				{
					ResetRaid( (Region) this, true );
				}
				
				return base.OnDeath( m );
			}
			else if ( m is RaidBoss )
				ResetRaid( (Region) this, false );
			
			return base.OnDeath( m );
		}
		
		//============== CUSTOM FUNKCE
		public static void ResetRaid( Region region, bool boss )
		{
			List<Mobile> mobs = region.GetMobiles();
			
			foreach ( Mobile m in mobs )
			{
				if ( m is BaseCreature && !((BaseCreature)m).Controlled )
				{
					if ( m is RaidBoss && !boss )
						continue;
					else
						m.Delete();
				}
			}
			
			//Dodelat respawn bosse
		}
		
		public static bool EncounterActive( Region region )
		{
			List<Mobile> mobs = region.GetMobiles();
			
			foreach ( Mobile m in mobs )
			{
				if ( m is RaidBoss && !m.Blessed )
					return true;
			}
			
			return false;
		}
		
		public static List<Mobile> PlayersIn( Region region, bool LivingOnly )
		{
			List<Mobile> players = region.GetPlayers();
			List<Mobile> list = new List<Mobile>();

			foreach ( Mobile m in players )
			{
				if ( m is PlayerMobile && m.AccessLevel < AccessLevel.Counselor )
				{
					if ( !m.Alive && LivingOnly )
						continue;
					else
						list.Add( m );
				}
			}

			return list;
		}
		
		private static void ReleasePotionLock( object state )
		{
			((Mobile)state).EndAction( typeof( BasePotion ) );
		}
		
		public static RoleType PlayerRole( Mobile m )
		{
			RoleTalisman tal = m.FindItemOnLayer( Layer.Talisman ) as RoleTalisman;
			
			if ( tal == null )
				return RoleType.None;
			
			return ( RoleType ) tal.Role;
		}
	}
}
