using System;
using Server;
using Server.Targeting;
using Server.Mobiles;
using Server.Network;
using Server.Spells.Spellweaving;

namespace Server.Items
{
	public class RoleTalisman : BaseTalisman
	{
		public enum RoleType
		{
			None,
			Tank,
			Healer,
			Melee,
			Caster
		}
		
		private RoleType m_Role;
		
		[CommandProperty(AccessLevel.GameMaster)]
		public RoleType Role
		{
			get { return m_Role; }
			set
			{
				m_Role = value;
				
				if ( m_Role == RoleType.None )
				{
					Name = "Role check Talisman";
					ItemID = 12120;
					Hue = 971;
					Attributes.LowerManaCost = 0;
					Attributes.RegenMana = 0;
					Attributes.WeaponDamage = 0;
					Attributes.BonusStam = 0;
					Attributes.RegenStam = 0;
					Attributes.SpellDamage = 0;
					Attributes.BonusMana = 0;
					Attributes.DefendChance = 0;
					Attributes.BonusHits = 0;
					Attributes.RegenHits = 0;
					SkillBonuses.SetValues( 0, SkillName.Alchemy, 0.0 );
				}
				else if ( m_Role == RoleType.Tank )
				{
					Name = "Your role: TANK";
					ItemID = 12120;
					Hue = 33;
					Attributes.LowerManaCost = 0;
					Attributes.RegenMana = 0;
					Attributes.WeaponDamage = 0;
					Attributes.BonusStam = 0;
					Attributes.RegenStam = 0;
					Attributes.SpellDamage = 0;
					Attributes.BonusMana = 0;
					Attributes.DefendChance = 15;
					Attributes.BonusHits = 20;
					Attributes.RegenHits = 3;
					SkillBonuses.SetValues( 0, SkillName.Parry, 10.0 );
				}
				else if ( m_Role == RoleType.Healer )
				{
					Name = "Your role: HEALER";
					ItemID = 12123;
					Hue = 4;
					Attributes.LowerManaCost = 15;
					Attributes.RegenMana = 3;
					Attributes.WeaponDamage = 0;
					Attributes.BonusStam = 0;
					Attributes.RegenStam = 0;
					Attributes.SpellDamage = 0;
					Attributes.BonusMana = 20;
					Attributes.DefendChance = 0;
					Attributes.BonusHits = 0;
					Attributes.RegenHits = 0;
					SkillBonuses.SetValues( 0, SkillName.Healing, 10.0 );
				}
				else if ( m_Role == RoleType.Melee )
				{
					Name = "Your role: DAMAGE (Physical)";
					ItemID = 12121;
					Hue = 1041;
					Attributes.LowerManaCost = 0;
					Attributes.RegenMana = 0;
					Attributes.WeaponDamage = 15;
					Attributes.BonusStam = 20;
					Attributes.RegenStam = 3;
					Attributes.SpellDamage = 0;
					Attributes.BonusMana = 0;
					Attributes.DefendChance = 0;
					Attributes.BonusHits = 0;
					Attributes.RegenHits = 0;
					SkillBonuses.SetValues( 0, SkillName.Tactics, 10.0 );
				}
				else if ( m_Role == RoleType.Caster )
				{
					Name = "Your role: DAMAGE (Magic)";
					ItemID = 12122;
					Hue = 309;
					Attributes.LowerManaCost = 0;
					Attributes.RegenMana = 3;
					Attributes.WeaponDamage = 0;
					Attributes.BonusStam = 0;
					Attributes.RegenStam = 0;
					Attributes.SpellDamage = 15;
					Attributes.BonusMana = 20;
					Attributes.DefendChance = 0;
					Attributes.BonusHits = 0;
					Attributes.RegenHits = 0;
					SkillBonuses.SetValues( 0, SkillName.Magery, 10.0 );
				}
			}
		}
		
		public override bool ForceShowName{ get{ return true; } }
		
		[Constructable]
		public RoleTalisman() : base( 12120 )
		{
			Hue = 971;
			Name = "Role check Talisman";
		}
		
		private DateTime m_NextUse;
		
		public DateTime NextUse
		{
			get { return m_NextUse; }
			set { m_NextUse = value; }
		}
		
		public override void OnDoubleClick( Mobile from )
		{
			if( Parent != from )
				from.SendMessage( "Musis mit talisman nasazen aby sel pouzit!" );
			else if( from.HasTrade )
				from.SendMessage( "Nemuzes talisman pouzit pokud s nekym obchodujes!" );
			else
			{
				if ( DateTime.Now > m_NextUse )
				{
					if ( m_Role == RoleType.Healer )
					{
                  if ( from.CanBeginAction( typeof(GiftOfRenewalSpell) ) && new Spells.Spellweaving.GiftOfRenewalSpell( from, null ).Cast() )
						{
							from.SendMessage( "Na koho chces pouzit Gift of Renewal (40 sec)?" );
							m_NextUse = DateTime.Now + TimeSpan.FromSeconds( 60.0 );
						}
						else
						   from.SendLocalizedMessage( 501789 ); // You must wait before trying again.
					}
					else if ( m_Role == RoleType.Tank )
					{
						from.Target = new TalismanTarget( this );
						from.SendMessage( "Zamer monstrum chces obratit proti sobe?" );
					}
					else if ( m_Role == RoleType.Melee )
					{
						from.SendMessage( "Tva rychlost utoku vzrostla" );
						Attributes.WeaponSpeed = 50;
						m_NextUse = DateTime.Now + TimeSpan.FromSeconds( 120.0 );
						new ExpireTimer( from, this ).Start();
					}
					else if ( m_Role == RoleType.Caster )
					{
						from.SendMessage( "Tva rychlost kouzleni vzrostla" );
						Attributes.CastSpeed = 16;
						m_NextUse = DateTime.Now + TimeSpan.FromSeconds( 120.0 );
						new ExpireTimer( from, this ).Start();
					}
				}
				else
					from.SendMessage( "Jeste nemuzes talisman pouzit!" );
			}
		}
		
		private class TalismanTarget : Target
		{
			private RoleTalisman m_Talisman;
			
			public TalismanTarget( RoleTalisman talisman ) : base( 10, false, TargetFlags.None )
			{
				m_Talisman = talisman;
			}

			protected override void OnTarget( Mobile m, object t )
			{
				if ( m == null || t == null )
					return;
				
				BaseCreature bc = (BaseCreature) t;
				
				if ( bc != null && !bc.Controlled && bc.Combatant != m && DateTime.Now > m_Talisman.NextUse )
				{
					m_Talisman.NextUse = DateTime.Now + TimeSpan.FromSeconds( 15.0 );
					bc.Combatant = m;
					bc.FocusMob = m;
// 					bc.ConstantFocus = m;
					
					if ( bc is RaidBoss )
						((RaidBoss)bc).Targeted = m;
					
					bc.LocalOverheadMessage( MessageType.Emote, 34, true, String.Format("* {0} utoci na tebe *", bc.Name ) );

					bc.NonlocalOverheadMessage( MessageType.Emote, 34, true,
					                           String.Format( "* {0} utoci na {1} *", bc.Name, m.Name ) );
				}
				else
					m.SendMessage( "Toto neni monstrum, ktere na neutoci na tebe!" );
			}
		}
		
		private class ExpireTimer : Timer
		{
			private Mobile m_Mobile;
			private RoleTalisman m_Talisman;
			
			public ExpireTimer( Mobile m, RoleTalisman tal ) : base( TimeSpan.FromSeconds( 20.0 ) )
			{
				m_Mobile = m;
				m_Talisman = tal;
			}

			protected override void OnTick()
			{
				m_Talisman.Attributes.CastSpeed = 0;
				m_Talisman.Attributes.WeaponSpeed = 0;
				
			}
		}
		
		public RoleTalisman( Serial serial ) :  base( serial )
		{
		}
		
		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 ); // version
			
			writer.Write( (int) m_Role );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
			
			m_Role = (RoleType)reader.ReadInt();
			Attributes.CastSpeed = 0;
			Attributes.WeaponSpeed = 0;
		}
	}
}
