using System;
using Server;
using Server.Items;

namespace Server.Mobiles
{
	public class TestBoss : RaidBoss
	{
		public override Point3D SpawnLoc{ get{ return new Point3D( 5143, 1879, 0 ); } }
		
		[Constructable]
		public TestBoss() : base( AIType.AI_Melee, FightMode.Strongest )
		{
			Body = 1;
			BaseSoundID = 427;
			Name = "Lojza";
			Title = " the Test boss";

			SetStr( 100 );
			SetDex( 100 );
			SetInt( 100 );

			SetHits( 20000 );
			SetStam( 302, 400 );

			SetDamage( 2, 5 );

			SetDamageType( ResistanceType.Physical, 100 );

			SetResistance( ResistanceType.Physical, 50 );
			SetResistance( ResistanceType.Fire, 50 );
			SetResistance( ResistanceType.Cold, 50 );
			SetResistance( ResistanceType.Poison, 50 );
			SetResistance( ResistanceType.Energy, 50 );

			SetSkill( SkillName.Anatomy, 100.0 );
			SetSkill( SkillName.EvalInt, 100.0 );
			SetSkill( SkillName.Magery, 100.0 );
			SetSkill( SkillName.Meditation, 100.0 );
			SetSkill( SkillName.MagicResist, 100.0 );
			SetSkill( SkillName.Tactics, 100.0 );
			SetSkill( SkillName.Wrestling, 100.0 );

			Fame = 30000;
			Karma = 30000;

			VirtualArmor = 100;
			CantWalk = true;
		}
		
		public override bool AlwaysMurderer{ get{ return true; } }

		public override void GenerateLoot()
		{
			AddLoot( LootPack.UltraRich, 5 );
		}
		
		// 		public override void OnGaveMeleeAttack( Mobile defender )
		// 		{
		// 			base.OnGaveMeleeAttack( defender );
		// 
		// 			defender.Damage( Utility.Random( 20, 10 ), this );
		// 			defender.Stam -= Utility.Random( 20, 10 );
		// 			defender.Mana -= Utility.Random( 20, 10 );
		// 		}
		// 
		// 		public override void OnGotMeleeAttack( Mobile attacker )
		// 		{
		// 			base.OnGotMeleeAttack( attacker );
		// 			attacker.Damage( Utility.Random( 20, 10 ), this );
		// 			attacker.Stam -= Utility.Random( 20, 10 );
		// 			attacker.Mana -= Utility.Random( 20, 10 );
		// 		}
		
		public override void OnAfterDelete()
		{
			// 			if ( m_Timer != null )
			// 				m_Timer.Stop();
			// 
			// 			m_Timer = null;
			Timer.DelayCall( TimeSpan.FromSeconds(10.0), new TimerStateCallback(RaidBoss.RespawnBoss), new object[]{ (RaidBoss) new TestBoss() } );

			base.OnAfterDelete();
		}

		public TestBoss( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();

			switch ( version )
			{
				case 0:
					{
						Blessed = true;
						break;
					}
			}
		}
	}
}
