﻿/*
 * 
 * Reputation System
 * Beta Version 2.3
 * Designed for SVN 663 + ML
 * 
 * Authored by Dougan Ironfist
 * Last Updated on 3/5/2011
 * 
 * The purpose of these scripts is to allow shard administrators to create reputation groups that allow players to complete
 * quests, kill specific creatures and purchase items from reputation vendors based on their current reputation level.
 * This system is very similiar to how reputation systems work in other games.
 * 
 */

using System;
using System.Collections.Generic;
using Server;
using Server.Engines.XmlSpawner2;
using Server.Items;
using Server.Mobiles;
using Server.Reputation;
using Server.Reputation.Gumps;

/// THIS IS A CORE SCRIPT AND SHOULD NOT BE ALTERED ///

namespace Server.Reputation
{
    public class ReputationAttachment : XmlAttachment
    {
        private List<ReputationEntry> m_ReputationEntries = new List<ReputationEntry>();

        [CommandProperty(AccessLevel.GameMaster)]
        public List<ReputationEntry> ReputationEntries { get { return m_ReputationEntries; } set { m_ReputationEntries = value; } }

        // a serial constructor is REQUIRED
        public ReputationAttachment(ASerial serial)
            : base(serial)
        {
        }

        [Attachable]
        public ReputationAttachment()
        {
        }

        public ReputationEntry FindReputationEntryName(string name)
        {
            return ReputationEntries.Find(delegate(ReputationEntry entry) { return entry.GroupName == name; });
        }

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);

            writer.Write((int)0);

            writer.Write((int)ReputationEntries.Count);

            foreach (ReputationEntry entry in ReputationEntries)
            {
                writer.Write((string)entry.GroupName);
                writer.Write((int)entry.ReputationPoints);
            }
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);

            int version = reader.ReadInt();

            int entryCount = reader.ReadInt();

            for (int i = 0; i < entryCount; i++)
                ReputationEntries.Add(new ReputationEntry(reader.ReadString(), reader.ReadInt()));
        }
    }
}