/*
 * 
 * Reputation System
 * Beta Version 2.3
 * Designed for SVN 663 + ML
 * 
 * Authored by Dougan Ironfist
 * Last Updated on 3/4/2011
 * 
 * The purpose of these scripts is to allow shard administrators to create reputation groups that allow players to complete
 * quests, kill specific creatures and purchase items from reputation vendors based on their current reputation level.
 * This system is very similiar to how reputation systems work in other games.
 * 
 */

using System;
using Server;
using Server.Mobiles;
using Server.Misc;
using Server.Reputation.Items;

/// THIS IS A CORE SCRIPT AND SHOULD NOT BE ALTERED ///

namespace Server.Reputation
{
    public abstract class BaseReputationGroup
    {
        #region Event Handler
        public delegate void KilledByEventHandler(BaseCreature creature, PlayerMobile player);
        public static event KilledByEventHandler KilledByEvent;

        public static void OnKilledByEvent(BaseCreature creature, PlayerMobile player)
        {
            if (KilledByEvent != null)
                KilledByEvent(creature, player);
        }
        #endregion

        public abstract string GroupName { get; }
        public abstract string VendorType { get; }
        public abstract string QuestGiverType { get; }
        public abstract ReputationLevel StartingReputation { get; }

        public abstract void PlaceMobiles();

        internal void PlaceRepGroupMobile(string type, int x, int y, Map map, int count, int homeRange)
        {
//             int z = UOAMVendorGenerator.GetSpawnerZ(x, y, map);
// 
//             if (!IsSpawnerPresent(type, x, y, z, map))
//             {
//                 PremiumSpawner sp = new PremiumSpawner(type);
//                 sp.Count = count;
//                 sp.MinDelay = TimeSpan.FromMinutes(2.5);
//                 sp.MaxDelay = TimeSpan.FromMinutes(10.0);
//                 sp.Team = 0;
//                 sp.HomeRange = homeRange;
// 
//                 sp.MoveToWorld(new Point3D(x, y, z), map);
//                 sp.Respawn();
//                 sp.BringToHome();
//             }
        }

        protected bool IsSpawnerPresent(string type, int x, int y, int z, Map map)
        {
//             IPooledEnumerable eable = map.GetItemsInRange(new Point3D(x, y, z), 0);
// 
//             foreach (Item item in eable)
//             {
//                 if (item is PremiumSpawner && item.Z == z)
//                     if (((PremiumSpawner)item).CreaturesName.Contains(type))
//                         return true;
//             }

            return false;
        }
    }
}