﻿/*
 * 
 * Reputation System
 * Beta Version 2.3
 * Designed for SVN 663 + ML
 * 
 * Authored by Dougan Ironfist
 * Last Updated on 3/5/2011
 * 
 * The purpose of these scripts is to allow shard administrators to create reputation groups that allow players to complete
 * quests, kill specific creatures and purchase items from reputation vendors based on their current reputation level.
 * This system is very similiar to how reputation systems work in other games.
 * 
 */

using System;
using Server;
using Server.Engines.XmlSpawner2;
using Server.Mobiles;
using Server.Gumps;
using Server.Reputation.Items;

/// THIS IS A CORE SCRIPT AND SHOULD NOT BE ALTERED ///

namespace Server.Reputation.Gumps
{
    public class ReputationLogbookGump : Gump
    {
        private PlayerMobile player;

        private int width = 400;
        private int height = 450;

        public ReputationLogbookGump(PlayerMobile p)
            : base(20, 20)
        {
            player = p;

            ReputationAttachment attachment = (ReputationAttachment)XmlAttach.FindAttachment(player, typeof(ReputationAttachment));

            if (attachment != null)
            {
                int pageNumber = 1;

                StartNewPage(pageNumber);

                int y = 60;

                for (int i = 0; i < attachment.ReputationEntries.Count; i++)
                {
                    ReputationEntry entry = attachment.ReputationEntries[i];

                    int nextY = y + 25 + (entry.Reputation < ReputationLevel.Member ? 15 : 0);

                    if (nextY > 395 && i < attachment.ReputationEntries.Count - 1)
                    {
                        if (pageNumber > 1)
                            AddButton(30, 395, 4014, 4015, 0, GumpButtonType.Page, pageNumber - 1);

                        AddButton(340, 395, 4005, 4006, 0, GumpButtonType.Page, pageNumber + 1);

                        pageNumber += 1;

                        StartNewPage(pageNumber);

                        int yDiff = nextY - y;

                        y = 60;
                        nextY = y + yDiff;
                    }

                    AddLabelCropped(30, y, 260, 16, 0x481, entry.GroupName);
                    AddLabelCropped(300, (entry.Reputation < ReputationLevel.Member ? y + 8 : y), 80, 16, ReputationSystem.GetHue(entry.Reputation), entry.Reputation.ToString());

                    if (entry.Reputation < ReputationLevel.Member)
                    {
                        AddLabel(30, y + 15, 0x270, "Progress:");

                        int currentLevel = ReputationSystem.PointsNeededForLevel(entry.Reputation);
                        int difference = ReputationSystem.PointsNeededForNextLevel(entry.Reputation);
                        int progress = entry.ReputationPoints - currentLevel;

                        AddLabel(100, y + 15, 0x270, String.Format("{0}/{1}", progress, difference));
                    }

                    if (i < attachment.ReputationEntries.Count - 1 && WillFit(nextY, attachment.ReputationEntries[i + 1]))
                        AddImageTiled(25, nextY - 3, 350, 2, 10001);

                    y = nextY;
                }

                if (pageNumber > 1)
                    AddButton(30, 395, 4014, 4015, 0, GumpButtonType.Page, pageNumber - 1);
            }
        }

        private bool WillFit(int startY, ReputationEntry entry)
        {
            int nextY = startY + 25 + (entry.Reputation < ReputationLevel.Member ? 15 : 0);

            if (nextY > 395)
                return false;
            else
                return true;
        }

        private void StartNewPage(int pageNumber)
        {
            AddPage(pageNumber);

            AddBackground(0, 0, width, height, 9390);

            AddTextEntry(-10, -10, 1, 1, 17, 0, "");    // First TextEntry adds an underscore.  Fix this by displaying an empty string offscreen
            AddLabel(139, 35, 0xBC, "Reputation Status");
        }
    }
}