﻿/*
 * 
 * Reputation System
 * Beta Version 2.3
 * Designed for SVN 663 + ML
 * 
 * Authored by Dougan Ironfist
 * Last Updated on 3/5/2011
 * 
 * The purpose of these scripts is to allow shard administrators to create reputation groups that allow players to complete
 * quests, kill specific creatures and purchase items from reputation vendors based on their current reputation level.
 * This system is very similiar to how reputation systems work in other games.
 * 
 */

using System;
using System.Collections.Generic;
using Server;
using Server.Engines.XmlSpawner2;
using Server.Items;
using Server.Mobiles;
using Server.Reputation;
using Server.Reputation.Gumps;

/// THIS IS A CORE SCRIPT AND SHOULD NOT BE ALTERED ///

namespace Server.Reputation.Items
{
    public class ReputationLogbook : Item
    {
        [Constructable]
        public ReputationLogbook()
            : base(0xFF0)
        {
            Name = "Reputation Logbook";
            Hue = 0x489;
            Weight = 0;
        }

        public ReputationLogbook(Serial serial)
            : base(serial)
        {
        }

        public override bool DisplayLootType { get { return false; } }
        public override bool DisplayWeight { get { return false; } }

        public override void OnDoubleClick(Mobile from)
        {
            if (from is PlayerMobile)
                from.SendGump(new ReputationLogbookGump((PlayerMobile)from));
        }

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);

            writer.Write((int)1); // version
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);

            int version = reader.ReadInt();

            switch (version)
            {
                case 1:
                    break;
                case 0:
                    // Convert old means of storage to an attachment.  Book is only needed to view reputation levels.
                    List<ReputationEntry> entries = new List<ReputationEntry>();

                    int count = reader.ReadInt();

                    for (int i = 0; i < count; i++)
                        entries.Add(new ReputationEntry(reader.ReadString(), reader.ReadInt()));

                    if (RootParent is PlayerMobile)
                    {
                        foreach (ReputationEntry entry in entries)
                        {
                            ReputationEntry attEntry = ReputationSystem.FindEntry((PlayerMobile)RootParent, entry.GroupName, ReputationLevel.Neutral);

                            if (attEntry != null)
                                attEntry.ReputationPoints = entry.ReputationPoints;
                        }
                    }

                    LootType = Server.LootType.Regular;
                    Weight = 0;
                    Hue = 0x489;

                    break;
            }
        }
    }
}