/*
 * 
 * Reputation System
 * Beta Version 2.3
 * Designed for SVN 663 + ML
 * 
 * Authored by Dougan Ironfist
 * Last Updated on 3/5/2011
 * 
 * The purpose of these scripts is to allow shard administrators to create reputation groups that allow players to complete
 * quests, kill specific creatures and purchase items from reputation vendors based on their current reputation level.
 * This system is very similiar to how reputation systems work in other games.
 * 
 */

using System;
using System.Collections.Generic;
using Server;
using Server.Items;
using Server.Mobiles;
using Server.Reputation;
using Server.Reputation.Gumps;

/// THIS IS A CORE SCRIPT AND SHOULD NOT BE ALTERED ///

namespace Server.Reputation.Items
{
    public class TitleScroll : Item
    {
        private string m_Title;
        public string Title { get { return m_Title; } }

        public override bool DisplayLootType { get { return false; } }
        public override bool DisplayWeight { get { return false; } }

        [Constructable]
        public TitleScroll(string title)
            : base(0x2258)
        {
            LootType = Server.LootType.Blessed;
            Name = "Scroll Bestowing the Title of";
            m_Title = title;
        }

        public TitleScroll(Serial serial)
            : base(serial)
        {
        }

        public override void AddNameProperty(ObjectPropertyList list)
        {
            list.Add(Name);
            list.Add(1049644, m_Title);
        }

//         public virtual bool CanPlayerUseScroll(PlayerMobile player)
//         {
//             if (player.CollectionTitles.Contains(m_Title))
//                 return false;
//             else
//                 return true;
//         }
// 
//         public override void OnDoubleClick(Mobile from)
//         {
//             if (from is PlayerMobile)
//             {
//                 ((PlayerMobile)from).AddCollectionTitle(m_Title);
//                 from.SendSound(0x3D);
//                 from.SendMessage(0xC8, String.Format("Your have been awarded the title of '{0}'.", m_Title));
//                 Delete();
//             }
//         }

        public override void OnDoubleClick(Mobile from)
        {
            if (from is PlayerMobile)
            {
//                 ((PlayerMobile)from).AddCollectionTitle(m_Title);
//             Server.Reputation.MinocBlacksmithAssociation repGroup = new Server.Reputation.MinocBlacksmithAssociation();

            // Now we try to find an entry in the player's logbook for your reputation group
            ReputationEntry entry = ReputationSystem.FindEntry(((PlayerMobile)from), "Minoc Blacksmithing Association", ReputationLevel.Neutral);
                
                entry.AwardReputation( ((PlayerMobile)from), entry, 50);
                from.SendSound(0x3D);
//                 from.SendMessage(0xC8, String.Format("Your have been awarded the title of '{0}'.", m_Title));
//                 Delete();
            }
        }

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);

            writer.Write((int)0); // version

            writer.Write((string)m_Title);
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);

            int version = reader.ReadInt();

            m_Title = reader.ReadString();
        }
    }
}