﻿/*
 * 
 * Reputation System
 * Beta Version 2.3
 * Designed for SVN 663 + ML
 * 
 * Authored by Dougan Ironfist
 * Last Updated on 3/5/2011
 * 
 * The purpose of these scripts is to allow shard administrators to create reputation groups that allow players to complete
 * quests, kill specific creatures and purchase items from reputation vendors based on their current reputation level.
 * This system is very similiar to how reputation systems work in other games.
 * 
 */

using System;
using Server;
using Server.Engines.XmlSpawner2;
using Server.Mobiles;
using Server.Reputation.Items;

/// THIS IS A CORE SCRIPT AND SHOULD NOT BE ALTERED ///

namespace Server.Reputation
{
    public class ReputationEntry
    {
        public string GroupName;
        public int ReputationPoints;

        public ReputationLevel Reputation
        {
            get
            {
                if (ReputationPoints < ReputationSystem.PointsNeededForLevel(ReputationLevel.Disliked))
                    return ReputationLevel.Hated;
                else if (ReputationPoints < ReputationSystem.PointsNeededForLevel(ReputationLevel.Neutral))
                    return ReputationLevel.Disliked;
                else if (ReputationPoints < ReputationSystem.PointsNeededForLevel(ReputationLevel.Friendly))
                    return ReputationLevel.Neutral;
                else if (ReputationPoints < ReputationSystem.PointsNeededForLevel(ReputationLevel.WellKnown))
                    return ReputationLevel.Friendly;
                else if (ReputationPoints < ReputationSystem.PointsNeededForLevel(ReputationLevel.Trusted))
                    return ReputationLevel.WellKnown;
                else if (ReputationPoints < ReputationSystem.PointsNeededForLevel(ReputationLevel.Member))
                    return ReputationLevel.Trusted;
                else
                    return ReputationLevel.Member;
            }
        }

        public ReputationEntry(string groupName)
            : this(groupName, 0)
        {
        }

        public ReputationEntry(string groupName, int points)
        {
            GroupName = groupName;
            ReputationPoints = points;
        }

        public void AwardReputation(PlayerMobile player, ReputationEntry entry, int amount)
        {
            ReputationLevel oldLevel = entry.Reputation;

            entry.ReputationPoints += amount;

            player.SendMessage(0x3E, "Your reputation with {0} has increased by {1} points.", entry.GroupName, amount);

            if (entry.Reputation > oldLevel)
                ReachedNewLevel(player, entry);
        }

        private void ReachedNewLevel(PlayerMobile player, ReputationEntry entry)
        {
            string levelName = entry.Reputation.ToString();

            if (entry.Reputation == ReputationLevel.WellKnown)
                levelName = "Well Known";

            player.SendMessage(0xC8, "Your reputation with {0} has increased to {1}.", entry.GroupName, levelName);
        }
    }
}
