﻿/*
 * 
 * Reputation System
 * Beta Version 2.3
 * Designed for SVN 663 + ML
 * 
 * Authored by Dougan Ironfist
 * Last Updated on 3/5/2011
 * 
 * The purpose of these scripts is to allow shard administrators to create reputation groups that allow players to complete
 * quests, kill specific creatures and purchase items from reputation vendors based on their current reputation level.
 * This system is very similiar to how reputation systems work in other games.
 * 
 */

using System;
using System.Collections;
using Server;
using Server.Mobiles;
using Server.Reputation.Items;
using Server.Engines.XmlSpawner2;

/// THIS IS A CORE SCRIPT AND SHOULD NOT BE ALTERED ///

namespace Server.Reputation
{
    public enum ReputationLevel
    {
        Hated,
        Disliked,
        Neutral,
        Friendly,
        WellKnown,
        Trusted,
        Member
    }

    public class ReputationSystem
    {
        public static void Initialize()
        {
            EventSink.Login += new LoginEventHandler(EventSink_Login);
        }

        public static void EventSink_Login(LoginEventArgs e)
        {
            if (e.Mobile is PlayerMobile)
            {
                ReputationAttachment attachment = FindAttachment(e.Mobile);
            }
        }

        public static ReputationAttachment FindAttachment(Mobile m)
        {
            ReputationAttachment attachment = (ReputationAttachment)XmlAttach.FindAttachment(m, typeof(ReputationAttachment));

            if (attachment == null)
            {
                attachment = new ReputationAttachment();
                XmlAttach.AttachTo(m, attachment);
            }

            return attachment;
        }

        public static ReputationEntry FindEntry(PlayerMobile player, string repGroupName, ReputationLevel defaultReputation)
        {
            ReputationAttachment attachment = FindAttachment(player);

            if (attachment != null)
            {
                ReputationEntry entry = attachment.FindReputationEntryName(repGroupName);

                if (entry == null)
                {
                    entry = new ReputationEntry(repGroupName, ReputationSystem.PointsNeededForLevel(defaultReputation));
                    attachment.ReputationEntries.Add(entry);
                    attachment.ReputationEntries.Sort(ComapreByName);
                }

                return entry;
            }

            return null;
        }

        public static int ComapreByName(ReputationEntry x, ReputationEntry y)
        {
            if (x.GroupName == null)
            {
                if (y.GroupName == null)
                    return 0;
                else
                    return -1;
            }
            else
            {
                if (y.GroupName == null)
                    return 1;
                else
                    return x.GroupName.CompareTo(y.GroupName);
            }
        }

        public static int PointsNeededForLevel(ReputationLevel repLevel)
        {
            int Points = 0;

            switch (repLevel)
            {
                case ReputationLevel.Hated:
                    Points = -45000;
                    break;
                case ReputationLevel.Disliked:
                    Points = -9000;
                    break;
                case ReputationLevel.Neutral:
                    Points = 0;
                    break;
                case ReputationLevel.Friendly:
                    Points = 3000;
                    break;
                case ReputationLevel.WellKnown:
                    Points = 9000;
                    break;
                case ReputationLevel.Trusted:
                    Points = 21000;
                    break;
                case ReputationLevel.Member:
                    Points = 45000;
                    break;
            }

            return Points;
        }

        public static int PointsNeededForNextLevel(ReputationLevel repLevel)
        {
            int Points = 0;

            switch (repLevel)
            {
                case ReputationLevel.Hated:
                    Points = 36000;
                    break;
                case ReputationLevel.Disliked:
                    Points = 9000;
                    break;
                case ReputationLevel.Neutral:
                    Points = 3000;
                    break;
                case ReputationLevel.Friendly:
                    Points = 6000;
                    break;
                case ReputationLevel.WellKnown:
                    Points = 12000;
                    break;
                case ReputationLevel.Trusted:
                    Points = 24000;
                    break;
            }

            return Points;
        }

        public static int GetHue(ReputationLevel repLevel)
        {
            int Hue = 0;

            switch (repLevel)
            {
                case ReputationLevel.Hated:
                    Hue = 0xED;
                    break;
                case ReputationLevel.Disliked:
                    Hue = 0x2B;
                    break;
                case ReputationLevel.Neutral:
                    Hue = 0x38A;
                    break;
                case ReputationLevel.Friendly:
                    Hue = 0x3C;
                    break;
                case ReputationLevel.WellKnown:
                    Hue = 0x56;
                    break;
                case ReputationLevel.Trusted:
                    Hue = 0x15;
                    break;
                case ReputationLevel.Member:
                    Hue = 0x37;
                    break;
            }

            return Hue;
        }
    }
}