/*
 * 
 * Reputation System
 * Beta Version 2.3
 * Designed for SVN 663 + ML
 * 
 * Authored by Dougan Ironfist
 * Last Updated on 3/5/2011
 * 
 * The purpose of these scripts is to allow shard administrators to create reputation groups that allow players to complete
 * quests, kill specific creatures and purchase items from reputation vendors based on their current reputation level.
 * This system is very similiar to how reputation systems work in other games.
 * 
 */

using System;
using System.Collections.Generic;
using Server;
using Server.ContextMenus;
using Server.Items;
using Server.Mobiles;
using Server.Targeting;
using Server.Reputation;
using Server.Reputation.Items;

/// THIS IS A CORE SCRIPT AND SHOULD NOT BE ALTERED ///

namespace Server.Reputation.Vendor
{
    public class ReputationBackpack : Backpack
    {
        public ReputationBackpack()
        {
            Layer = Layer.Backpack;
            Weight = 1.0;
        }

        public override int DefaultMaxWeight { get { return 0; } }

        public override bool IsAccessibleTo(Mobile m)
        {
            return true;
        }

        public override bool CheckItemUse(Mobile from, Item item)
        {
            if (!base.CheckItemUse(from, item))
                return false;

            if (item is ReputationBox)
                return true;

            from.SendLocalizedMessage(500447); // That is not accessible.
            return false;
        }

        public override bool CheckTarget(Mobile from, Target targ, object targeted)
        {
            if (!base.CheckTarget(from, targ, targeted))
                return false;

            if (from.AccessLevel >= AccessLevel.GameMaster)
                return true;

            return targ.GetType().IsDefined(typeof(ReputationVendorTargetAttribute), false);
        }

        public override void GetChildContextMenuEntries(Mobile from, List<ContextMenuEntry> list, Item item)
        {
            base.GetChildContextMenuEntries(from, list, item);

            BaseReputationVendor brv = RootParent as BaseReputationVendor;

            if (brv == null)
                return;

            ReputationItem ri = brv.GetVendorItem(item);

            if (ri != null)
                list.Add(new BuyEntry(item));
        }

        private class BuyEntry : ContextMenuEntry
        {
            private Item m_Item;

            public BuyEntry(Item item)
                : base(6103)
            {
                m_Item = item;
            }

            public override bool NonLocalUse { get { return true; } }

            public override void OnClick()
            {
                if (m_Item.Deleted)
                    return;

                BaseReputationVendor.TryToBuy(m_Item, Owner.From);
            }
        }

        public override void GetChildNameProperties(ObjectPropertyList list, Item item)
        {
            base.GetChildNameProperties(list, item);

            BaseReputationVendor brv = RootParent as BaseReputationVendor;

            if (brv == null)
                return;

            ReputationItem ri = brv.GetVendorItem(item);

            if (ri == null)
                return;

            if (!ri.IsForSale)
                list.Add(1043307); // Price: Not for sale.
            else
                list.Add(1043304, ri.FormattedPrice); // Price: ~1_COST~
        }

        public override void OnSingleClickContained(Mobile from, Item item)
        {
            if (RootParent is BaseReputationVendor)
            {
                BaseReputationVendor brv = (BaseReputationVendor)RootParent;

                if (brv == null)
                    return;

                ReputationItem ri = brv.GetVendorItem(item);

                if (ri != null)
                {
                    if (!ri.IsForSale)
                        item.LabelTo(from, 1043307); // Price: Not for sale.
                    else
                        item.LabelTo(from, 1043304, ri.FormattedPrice); // Price: ~1_COST~
                }
            }

            base.OnSingleClickContained(from, item);
        }

        /*public override bool IsChildVisibleTo(Mobile m, Item child)
        {
            if (m.AccessLevel >= AccessLevel.Administrator)
                return true;

            BaseReputationVendor brv = (BaseReputationVendor)RootParent;

            if (brv == null)
                return false;

            ReputationItem ri = brv.GetVendorItem(child);

            if (ri == null)
                return false;

            if (m is PlayerMobile)
            {
                ReputationEntry entry = ReputationSystem.FindEntry((PlayerMobile)m, brv.RepGroup.GroupName, brv.RepGroup.StartingReputation);

                if (entry == null)
                    return false;
                else
                    return (entry.Reputation >= ri.RequiredReputation);
            }

            return false;
        }*/

        public ReputationBackpack(Serial serial)
            : base(serial)
        {
        }

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);

            writer.Write((int)0); // version
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);

            int version = reader.ReadInt();

            foreach (Item item in Items)
                item.Delete();

            BaseReputationVendor brv = RootParent as BaseReputationVendor;

            AddReputationLogbook(brv);
            brv.RestockReputationItems();
        }

        private void AddReputationLogbook(BaseReputationVendor brv)
        {
            try
            {
                ReputationLogbook logBook = new ReputationLogbook();

                AddItem(logBook);
                logBook.Location = new Point3D(142, 127, 0);

                brv.SetVendorItem(logBook, 5, ReputationLevel.Hated);
            }
            catch { }
        }
    }
}