/*
 * 
 * Reputation System
 * Beta Version 2.3
 * Designed for SVN 663 + ML
 * 
 * Authored by Dougan Ironfist
 * Last Updated on 3/5/2011
 * 
 * The purpose of these scripts is to allow shard administrators to create reputation groups that allow players to complete
 * quests, kill specific creatures and purchase items from reputation vendors based on their current reputation level.
 * This system is very similiar to how reputation systems work in other games.
 * 
 */

using System;
using Server;
using Server.Items;
using Server.Mobiles;
using Server.Reputation;
using Server.Reputation.Items;

/// THIS IS A CORE SCRIPT AND SHOULD NOT BE ALTERED ///

namespace Server.Reputation.Vendor
{
    public class ReputationBox : Container
    {
        private ReputationLevel m_RequiredReputation;
        private Point3D m_OnAddLocation;

        public ReputationLevel RequiredReputation
        {
            get
            {
                return m_RequiredReputation;
            }
            set
            {
                m_RequiredReputation = value;

                Hue = ReputationSystem.GetHue(m_RequiredReputation);

                switch (m_RequiredReputation)
                {
                    case ReputationLevel.Hated:
                        m_OnAddLocation = new Point3D(44, 125, 0);
                        break;
                    case ReputationLevel.Disliked:
                        m_OnAddLocation = new Point3D(66, 125, 0);
                        break;
                    case ReputationLevel.Neutral:
                        m_OnAddLocation = new Point3D(44, 65, 0);
                        break;
                    case ReputationLevel.Friendly:
                        m_OnAddLocation = new Point3D(66, 65, 0);
                        break;
                    case ReputationLevel.WellKnown:
                        m_OnAddLocation = new Point3D(88, 65, 0);
                        break;
                    case ReputationLevel.Trusted:
                        m_OnAddLocation = new Point3D(110, 65, 0);
                        break;
                    case ReputationLevel.Member:
                        m_OnAddLocation = new Point3D(132, 65, 0);
                        break;
                }
            }
        }

        [Constructable]
        public ReputationBox(ReputationLevel reputationRequired)
            : base((reputationRequired < ReputationLevel.Neutral ? 0x9A8 : 0xE80))
        {
            RequiredReputation = reputationRequired;
            Name = reputationRequired.ToString() + " Reputation";
        }

        public ReputationBox(Serial serial)
            : base(serial)
        {
        }

        public override void OnAdded(object parent)
        {
            if (parent is ReputationBackpack)
                Location = m_OnAddLocation;
        }

        /*public override bool IsChildVisibleTo(Mobile m, Item child)
        {
            if (m.AccessLevel >= AccessLevel.Administrator)
                return true;

            if (m is PlayerMobile && child is TitleScroll)
                return ((TitleScroll)child).CanPlayerUseScroll((PlayerMobile)m);

            return false;
        }*/

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);

            writer.Write((int)0); // version
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);

            int version = reader.ReadInt();
        }
    }
}