﻿/*
 * 
 * Reputation System
 * Beta Version 2.3
 * Designed for SVN 663 + ML
 * 
 * Authored by Dougan Ironfist
 * Last Updated on 3/5/2011
 * 
 * The purpose of these scripts is to allow shard administrators to create reputation groups that allow players to complete
 * quests, kill specific creatures and purchase items from reputation vendors based on their current reputation level.
 * This system is very similiar to how reputation systems work in other games.
 * 
 */

using System;
using System.Globalization;
using Server;
using Server.Mobiles;
using Server.Reputation;
using Server.Reputation.Items;

/// THIS IS A CORE SCRIPT AND SHOULD NOT BE ALTERED ///

namespace Server.Reputation.Vendor
{
    public class ReputationItem
    {
        private Item m_Item;
        private int m_Price;
        private ReputationLevel m_RequiredReputation;

        public Item Item { get { return m_Item; } }
        public int Price { get { return m_Price; } }

        public string FormattedPrice
        {
            get
            {
                if (Core.ML)
                    return m_Price.ToString("N0", CultureInfo.GetCultureInfo("en-US"));

                return m_Price.ToString();
            }
        }

        public ReputationLevel RequiredReputation { get { return m_RequiredReputation; } }

        public bool IsForSale { get { return Price >= 0; } }

        public ReputationItem(Item item, int price, ReputationLevel requiredReputation)
        {
            m_Item = item;
            m_Price = price;
            m_RequiredReputation = requiredReputation;
        }

        public bool CanSee(Mobile m, BaseReputationGroup repGroup)
        {
            if (m is PlayerMobile)
            {
                ReputationEntry entry = ReputationSystem.FindEntry((PlayerMobile)m, repGroup.GroupName, repGroup.StartingReputation);

                if (entry == null)
                    return false;
                else
                    return (entry.Reputation >= m_RequiredReputation);
            }

            return false;
        }
    }
}