﻿/*
 * 
 * Reputation System    -   Minoc Blacksmithing Association Example
 * Beta Version 2.3
 * Designed for SVN 663 + ML
 * 
 * Authored by Dougan Ironfist
 * Last Updated on 3/5/2011
 * 
 * The purpose of these scripts is to allow shard administrators to create reputation groups that allow players to complete
 * quests, kill specific creatures and purchase items from reputation vendors based on their current reputation level.
 * This system is very similiar to how reputation systems work in other games.
 * 
 */

using System;
using System.Collections.Generic;
using Server;
using Server.Items;
using Server.Mobiles;
using Server.Reputation;
using Server.Reputation.Items;
using Server.Reputation.Vendor;

/// THIS IS AN EXAMPLE SCRIPT AND MAY BE USED TO CREATE ADDITIONAL REPUTATION GROUPS ///

namespace Server.Reputation.MinocBlacksmithAssociation.Vendor
{
    public class MBA_Vendor : BaseReputationVendor
    {
        // This must contain an instance of your reputation group
        public override BaseReputationGroup RepGroup { get { return new MinocBlacksmithAssociation(); } }

        // This must contain the quest giver's group title.  Leave blank or null for no title.
        public override string GroupTitle { get { return "Vendor of the Minoc Blacksmithing Association"; } }

        [Constructable]
        public MBA_Vendor()
        {
            Direction = Server.Direction.South;
        }

        public MBA_Vendor(Serial serial)
            : base(serial)
        {
        }

        /*
         * This is the routine used to define the items your vendor will sell.  This vendor is modeled closely after the
         * vendors used in player houses, so it will be used almost exactly the same.  The major difference is that if a
         * players looks at the vendor's stock of items, he/she will only see the items that are available for his/her
         * current reputation level.  Another major difference is that when a player buys an item from your vendor, the
         * player will receive a copy of the item and the original item will stay on the vendor.  Think of the vendor's
         * items as a display case item. ^.^
        */
        public override void RestockReputationItems()
        {
            // First create a box for the desired reputation level (You can even make boxes for Hated and Disliked reputations)
            ReputationBox box = AddReputationBox(ReputationLevel.Friendly);

            if (box != null)
            {
                /*
                 * Now add the items you want the vendor to sell into the box.  Note that the Location in the command refers to
                 * the location the item will appear when the box is opened by a player.  This allows you to neatly arrange a display.
                 * Also note that you can only have one box per reputation level and the box cannot contain subcontainers unless
                 * You are selling the entire container of goods.  For example, you could create a bag and fill the bag with armor
                 * pieces.  You can then put the whole bag up for sale.
                */
                AddReputationItem(new SturdyShovel(), 40, new Point3D(16, 51, 0), box);
                AddReputationItem(new SturdyPickaxe(), 75, new Point3D(16, 87, 0), box);
                AddReputationItem(new LeatherGlovesOfMining(1), 500, new Point3D(18, 68, 0), box);
                AddReputationItem(new PowerScroll(SkillName.Blacksmith, 105), 5000, new Point3D(140, 51, 0), box);
                AddReputationItem(new AncientSmithyHammer(10), 10000, new Point3D(46, 58, 0), box);
                AddReputationItem(new RunicHammer(CraftResource.DullCopper, Core.AOS ? 50 : 50), 10000, new Point3D(69, 58, 0), box);
                AddReputationItem(new RunicHammer(CraftResource.ShadowIron, Core.AOS ? 45 : 50), 20000, new Point3D(81, 58, 0), box);
                AddReputationItem(new ColoredAnvil(CraftResources.GetHue(CraftResource.DullCopper)), 2500, new Point3D(79, 78, 0), box);
                AddReputationItem(new ColoredAnvil(CraftResources.GetHue(CraftResource.ShadowIron)), 5000, new Point3D(105, 78, 0), box);
            }

            // Continue this process for each reputation level you want to offer items to your players
            box = AddReputationBox(ReputationLevel.WellKnown);

            if (box != null)
            {
                AddReputationItem(new StuddedGlovesOfMining(3), 2000, new Point3D(18, 68, 0), box);
                AddReputationItem(new GargoylesPickaxe(), 2500, new Point3D(16, 87, 0), box);
                AddReputationItem(new ProspectorsTool(), 2000, new Point3D(42, 68, 0), box);
                AddReputationItem(new PowerScroll(SkillName.Blacksmith, 110), 20000, new Point3D(140, 51, 0), box);
                AddReputationItem(new AncientSmithyHammer(15), 20000, new Point3D(46, 58, 0), box);
                AddReputationItem(new RunicHammer(CraftResource.Copper, Core.AOS ? 40 : 50), 40000, new Point3D(69, 58, 0), box);
                AddReputationItem(new RunicHammer(CraftResource.Bronze, Core.AOS ? 35 : 50), 80000, new Point3D(81, 58, 0), box);
                AddReputationItem(new ColoredAnvil(CraftResources.GetHue(CraftResource.Copper)), 10000, new Point3D(79, 78, 0), box);
                AddReputationItem(new ColoredAnvil(CraftResources.GetHue(CraftResource.Bronze)), 20000, new Point3D(105, 78, 0), box);
            }

            box = AddReputationBox(ReputationLevel.Trusted);

            if (box != null)
            {
                AddReputationItem(new RingmailGlovesOfMining(5), 5000, new Point3D(18, 68, 0), box);
                AddReputationItem(new PowderOfTemperament(), 20000, new Point3D(44, 91, 0), box);
                AddReputationItem(new PowerScroll(SkillName.Blacksmith, 115), 80000, new Point3D(140, 51, 0), box);
                AddReputationItem(new AncientSmithyHammer(30), 50000, new Point3D(46, 58, 0), box);
                AddReputationItem(new RunicHammer(CraftResource.Gold, Core.AOS ? 30 : 50), 160000, new Point3D(69, 58, 0), box);
                AddReputationItem(new RunicHammer(CraftResource.Agapite, Core.AOS ? 25 : 50), 320000, new Point3D(81, 58, 0), box);
                AddReputationItem(new ColoredAnvil(CraftResources.GetHue(CraftResource.Gold)), 40000, new Point3D(79, 78, 0), box);
                AddReputationItem(new ColoredAnvil(CraftResources.GetHue(CraftResource.Agapite)), 80000, new Point3D(105, 78, 0), box);
            }

            box = AddReputationBox(ReputationLevel.Member);

            if (box != null)
            {
                AddReputationItem(new PowerScroll(SkillName.Blacksmith, 120), 320000, new Point3D(140, 51, 0), box);
                AddReputationItem(new AncientSmithyHammer(60), 200000, new Point3D(46, 58, 0), box);
                AddReputationItem(new RunicHammer(CraftResource.Verite, Core.AOS ? 20 : 50), 640000, new Point3D(69, 58, 0), box);
                AddReputationItem(new RunicHammer(CraftResource.Valorite, Core.AOS ? 15 : 50), 1280000, new Point3D(81, 58, 0), box);
                AddReputationItem(new ColoredAnvil(CraftResources.GetHue(CraftResource.Verite)), 160000, new Point3D(79, 78, 0), box);
                AddReputationItem(new ColoredAnvil(CraftResources.GetHue(CraftResource.Valorite)), 320000, new Point3D(105, 78, 0), box);
                AddReputationItem(new TitleScroll("Hero of the Minoc Blacksmithing Association"), 1000, new Point3D(140, 86, 0), box);
            }
        }

        /*
         * The vendor system will try to dupe an item when the player buys it, but not all items can be duped.  If the item(s)
         * you are offering do not have a constructor with 0 parameters, then the dupe will fail.  When this happens, control is
         * passed to this routine so you can manually create the item the player has purchased.
         */
        public override Item ManualDupe(Item item)
        {
            if (item is LeatherGlovesOfMining)
                return new LeatherGlovesOfMining(1);
            else if (item is StuddedGlovesOfMining)
                return new StuddedGlovesOfMining(3);
            else if (item is RingmailGlovesOfMining)
                return new RingmailGlovesOfMining(5);
            else if (item is AncientSmithyHammer)
                return new AncientSmithyHammer(((AncientSmithyHammer)item).Bonus, ((AncientSmithyHammer)item).UsesRemaining);
            else if (item is RunicHammer)
                return new RunicHammer(((RunicHammer)item).Resource, ((RunicHammer)item).UsesRemaining);
            else if (item is TitleScroll)
                return new TitleScroll(((TitleScroll)item).Title);

            return null;
        }

        // Dress your vendor however you like, or leave it out for a naked vendor
        public override void InitOutfit()
        {
            base.InitOutfit();

            int armorHue;
            int cloakShoeHue;

            switch (Utility.Random(9))
            {
                default:
                case 0: armorHue = OreInfo.Iron.Hue; break;
                case 1: armorHue = OreInfo.DullCopper.Hue; break;
                case 2: armorHue = OreInfo.Copper.Hue; break;
                case 3: armorHue = OreInfo.Bronze.Hue; break;
                case 4: armorHue = OreInfo.ShadowIron.Hue; break;
                case 5: armorHue = OreInfo.Gold.Hue; break;
                case 6: armorHue = OreInfo.Agapite.Hue; break;
                case 7: armorHue = OreInfo.Verite.Hue; break;
                case 8: armorHue = OreInfo.Valorite.Hue; break;
            }

            switch (Utility.Random(9))
            {
                default:
                case 0: cloakShoeHue = OreInfo.Iron.Hue; break;
                case 1: cloakShoeHue = OreInfo.DullCopper.Hue; break;
                case 2: cloakShoeHue = OreInfo.Copper.Hue; break;
                case 3: cloakShoeHue = OreInfo.Bronze.Hue; break;
                case 4: cloakShoeHue = OreInfo.ShadowIron.Hue; break;
                case 5: cloakShoeHue = OreInfo.Gold.Hue; break;
                case 6: cloakShoeHue = OreInfo.Agapite.Hue; break;
                case 7: cloakShoeHue = OreInfo.Verite.Hue; break;
                case 8: cloakShoeHue = OreInfo.Valorite.Hue; break;
            }

            switch (Utility.Random(2))
            {
                default:
                case 0:
                    EquipItem(new ChainChest(), armorHue);
                    EquipItem(new ChainLegs(), armorHue);
                    break;
                case 1:
                    EquipItem(new RingmailChest(), armorHue);
                    EquipItem(new RingmailLegs(), armorHue);
                    break;
            }

            EquipItem(new RingmailArms(), armorHue);
            EquipItem(new RingmailGloves(), armorHue);

            EquipItem(new Cloak(), cloakShoeHue);
            EquipItem(new Boots(), cloakShoeHue);

            AddItem(new Server.Items.SmithHammer());
        }

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);

            writer.Write((int)0); // version
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);

            int version = reader.ReadInt();
        }
    }
}