/*
 * 
 * Reputation System    -   Minoc Blacksmithing Association Example
 * Beta Version 2.3
 * Designed for SVN 663 + ML
 * 
 * Authored by Dougan Ironfist
 * Last Updated on 3/5/2011
 * 
 * The purpose of these scripts is to allow shard administrators to create reputation groups that allow players to complete
 * quests, kill specific creatures and purchase items from reputation vendors based on their current reputation level.
 * This system is very similiar to how reputation systems work in other games.
 * 
 */

using System;
using Server;
using Server.Mobiles;
using Server.Reputation.Items;

/// THIS IS AN EXAMPLE SCRIPT AND MAY BE USED TO CREATE ADDITIONAL REPUTATION GROUPS ///

namespace Server.Reputation.MinocBlacksmithAssociation
{
    public class MinocBlacksmithAssociation : BaseReputationGroup
    {
        // This must contain the name of the reputation group
        public override string GroupName { get { return "Minoc Blacksmithing Association"; } }

        // This must contain the name to the reputation vendor class for ease of spawner placement later
        public override string VendorType { get { return "MBA_Vendor"; } }

        // This must contain the name to the reputation quest giver class for ease of spawner placement later
        public override string QuestGiverType { get { return "MBA_QuestGiver"; } }

        // This must contain the starting reputation level for this group
        public override ReputationLevel StartingReputation { get { return ReputationLevel.Neutral; } }

        // The Initialize routine must be present to in order to automatically create spawners for your reputation mobiles
        public static void Initialize()
        {
            // Create an instance of your group and call PlaceMobiles() to place the spawners
            MinocBlacksmithAssociation group = new MinocBlacksmithAssociation();
            group.PlaceMobiles();


            /* If you want your players to gain reputation by killing monsters, then this type of hook must be in place.
             * 
             * Note: In order for this hook to work, you must make a small change to the BaseCreature script.
             * See the details at the bootom of this script for details.
             */
            KilledByEvent += new KilledByEventHandler(MinocBlacksmithAssociation_KilledByEvent);
        }

        // This is the code for the hook we made earlier
        static void MinocBlacksmithAssociation_KilledByEvent(BaseCreature creature, PlayerMobile player)
        {
            if (!(creature is EarthElemental || creature is DullCopperElemental || creature is ShadowIronElemental || creature is CopperElemental ||
                creature is BronzeElemental || creature is GoldenElemental || creature is AgapiteElemental || creature is VeriteElemental ||
                creature is ValoriteElemental))
                return;

            // First create an instance of your reputation group (since this routine is static)
            MinocBlacksmithAssociation repGroup = new MinocBlacksmithAssociation();

            // Now we try to find an entry in the player's logbook for your reputation group
            ReputationEntry entry = ReputationSystem.FindEntry(player, repGroup.GroupName, repGroup.StartingReputation);

            // Now we can check the player's reputation level.  In this example, the player cannot receive any more
            // reputation from killing monsters once he/she reaches Trusted reputation
            if (entry.Reputation < ReputationLevel.Trusted)
            {
                if (creature is EarthElemental || creature is DullCopperElemental || creature is ShadowIronElemental || creature is CopperElemental)
                    entry.AwardReputation(player, entry, 10);
                else if (creature is BronzeElemental || creature is GoldenElemental || creature is AgapiteElemental)
                    entry.AwardReputation(player, entry, 25);
                else if (creature is VeriteElemental || creature is ValoriteElemental)
                    entry.AwardReputation(player, entry, 50);
            }
        }

        // This routine is used to place spawners for your reputation vendors and quest givers
        // This routine must exist in your script even if you do not want to automatically create your spawners
        public override void PlaceMobiles()
        {
//             PlaceRepGroupMobile(VendorType, 2523, 578, Map.Trammel, 1, 0);
//             PlaceRepGroupMobile(QuestGiverType, 2525, 570, Map.Trammel, 1, 0);
// 
//             PlaceRepGroupMobile(VendorType, 2523, 578, Map.Felucca, 1, 0);
//             PlaceRepGroupMobile(QuestGiverType, 2525, 570, Map.Felucca, 1, 0);
        }
    }
    /*
     * In order to hook into the reputation when a creature is killed, you will need to make a small change
     * to the BaseCreature.cs script.  Open the script and find the OnKilledBy routine as shown below.
     * 
     	public virtual void OnKilledBy( Mobile mob )
		{
			if ( m_Paragon && Paragon.CheckArtifactChance( mob, this ) )
				Paragon.GiveArtifactTo( mob );
		}

     * Now we need to add two lines to hook into the reputation system as shown below

		public virtual void OnKilledBy( Mobile mob )
		{
			if ( m_Paragon && Paragon.CheckArtifactChance( mob, this ) )
				Paragon.GiveArtifactTo( mob );

			if (mob is PlayerMobile)
				Server.Reputation.BaseReputationGroup.OnKilledByEvent(this, ((PlayerMobile)mob));
		}
     
     * Once this changed has been made, save the script and moster kills can now be captured by the
     * reputation system.
     * 
     */
}