using System;
using Server.Misc;
using Server.Gumps;
using Server.Mobiles;
using Server.Commands;
using Server.Targeting;

namespace Server.Achiev
{
   public class AchievCommand
   {
     public static void Initialize()
     {
  	      CommandSystem.Register( "Achiev", AccessLevel.Player, new CommandEventHandler( GetAchiev_OnCommand ) );
     }
  
     public static void Register( string command, AccessLevel access, CommandEventHandler handler )
     {
  	      CommandSystem.Register( command, access, handler );
     }
  
  	  [Usage( "Achiev" )] 
     [Description( "Zobrazi uspechy hrace")] 
     public static void GetAchiev_OnCommand( CommandEventArgs e )
     {
         e.Mobile.SendMessage( "Vyber hrace pro zobrazeni dosazenych uspechu" );
         e.Mobile.Target = new InternalTarget();
     }
     
		private class InternalTarget : Target
		{

			public InternalTarget() : base( 20, true, TargetFlags.None )
			{
			}

			protected override void OnTarget( Mobile from, object targeted )
			{
				if ( targeted is PlayerMobile )
				{
			      if( from.HasGump( typeof(AchievGump) ) )
				     from.CloseGump( typeof(AchievGump) );
         
               from.SendGump(new AchievGump( (Mobile) targeted ));      
            }
            else
               from.SendMessage( "Musis vybrat hrace" );               
			}
		}
   }
}