using System;
using System.Collections.Generic;
using System.Xml;
using Server;
using Server.Items;
using Server.Mobiles;
using Server.Gumps;

namespace Server.Achiev
{
   public class AchievGump : Gump
	{
      public AchievGump( Mobile targeted ) : base(50, 100)
		{
			this.Closable=true;
			this.Disposable=true;
			this.Dragable=true;
			this.Resizable=false;
			this.AddPage(0);
			this.AddBackground(0, 20, 650, 450, 9200);
			this.AddBackground(97, 5, 449, 30, 9200);
			this.AddLabel(109, 10, 52, @"ACHIEVEMENT POINTS:");
			this.AddLabel(495, 10, 0, @"2569");
			this.AddButton(615, 23, 4017, 4019, 0, GumpButtonType.Reply, 0);

			this.AddImageTiled(5, 45, 130, 25, 2624);
			this.AddAlphaRegion(5, 45, 130, 25);
			this.AddButton(136, 46, 4029, 4031, 1, GumpButtonType.Reply, 0);
			this.AddHtml( 10, 46, 125, 20, @"<basefont color=white>Dungeony", (bool)false, (bool)false);
			
			string baseFontColor = "<basefont color=white>";
			string NonFontColor = "<basefont color=silver>";
			
			string html = baseFontColor;
         
         foreach ( KeyValuePair<Achievements, string> pair in Achievements.AchievList )
         {
            if ( pair.Value == "DUNGEONY" && pair.Key.List != null )
            {
               html = html + "[" + Utility.GetAttribute( pair.Key.List, "points", "0" ).ToString() + "] ";
               html = html + Utility.GetAttribute( pair.Key.List, "name", "No name" ).ToString() + " - ";
               html = html + Utility.GetAttribute( pair.Key.List, "desc", "No description" ).ToString() + "<br>";
               
              string tascs = ""; 
               
               foreach ( XmlElement ele in pair.Key.List.SelectNodes( "task" ) )
      			{
    					try
    					{
    						tascs = tascs + Utility.GetAttribute( ele, "name", "No name" ).ToString() + ", ";
        				}
    					catch
    					{
    					}
      			}
      			
      			if ( tascs != "" )
      			   html = html + "<basefont color=skyblue>" + tascs + "<br>";
      			   
      			html = html + "<basefont color=yellow>----------------------------------------<br>" + baseFontColor;
            }
         }
         
			this.AddImageTiled(165, 45, 475, 415, 2624);
			this.AddAlphaRegion(165, 45, 475, 415);
			this.AddHtml( 170, 50, 475, 410, html, (bool)false, (bool)true);
		}
	}
}
