using System;
using System.Collections;
using System.Collections.Generic;
using System.IO;
using System.Xml;
using Server;

namespace Server.Achiev
{
	public class Achievements
	{
		private string m_Type;
		private XmlElement m_List;

		public string Type{ get{ return m_Type; } }
		public XmlElement List{ get{ return m_List; } }
		
// 		public bool ContainsName( string name )
// 		{
// 			for ( int i = 0; i < m_List.Length; i++ )
// 				if ( name == m_List[i] )
// 				return true;
// 
// 			return false;
// 		}

		public Achievements( string type, XmlElement xml )
		{
			m_Type = type;			
			m_List = xml;
		}
		
// 		public static Achievements GetCategory( string type )
// 		{
// 			Achievements n = null;
// 			m_Table.TryGetValue( type, out n );
// 			return n;
// 		}

// 		public static Achievements GetAchievements( string type )
// 		{
// 			Achievements n = null;
// 			m_Table.TryGetValue( type, out n );
// 			return n;
// 		}

// 		public static string RandomName( string type )
// 		{
// 			Achievements list = GetAchievements( type );
// 
// 			if ( list != null )
// 				return list.GetRandomName();
// 
// 			return "";
// 		}

		private static Dictionary<Achievements, string> m_Table;
		public static Dictionary<Achievements, string> AchievList{ get{ return m_Table; } }

		static Achievements()
		{
			m_Table = new Dictionary<Achievements, string>();//StringComparer.OrdinalIgnoreCase

			string filePath = Path.Combine( Core.BaseDirectory, "Data/achievements.xml" );

			if ( !File.Exists( filePath ) )
				return;

			try
			{
				Load( filePath );
			}
			catch ( Exception e )
			{
				Console.WriteLine( "Warning: Exception caught loading achievements:" );
				Console.WriteLine( e );
			}
		}

		private static void Load( string filePath )
		{
			XmlDocument doc = new XmlDocument();
			doc.Load( filePath );

			XmlElement root = doc["achievements"];

			foreach ( XmlElement element in root.GetElementsByTagName( "category" ) )
			{
				string type = element.GetAttribute( "type" );

				if ( type == null || type == String.Empty )
					continue;

				try
				{
					foreach ( XmlElement achiv in element.SelectNodes( "achiev" ) )
					{
						try
						{
							Achievements list = new Achievements( type, achiv );
							m_Table.Add( list, type );
						}
						catch ( Exception e )
						{
						   Console.WriteLine( e );
						}
					}
				}
				catch ( Exception e )
				{
				  Console.WriteLine( e );
				}
			}
		}
	}
}
