using System;
using Server;
using Server.Items;

namespace Server.Items
{
	public class AmuletOfTheVampireBat : SilverNecklace
	{
		[Constructable]
		public AmuletOfTheVampireBat()
		{
			Weight = 0.2;
			Name = "Amulet Of The VampireBat";
			Layer = Layer.Neck;
			Hue = 1182;
		}
		
		private void ClearTransform( Mobile m )
		{
         m.BodyMod = 0;
         m.HueMod = -1;
         m.NameMod = null;
         m.DisplayGuildTitle = true;
         
			Attributes.BonusStr = 0;
			Attributes.BonusHits = 0;
			Attributes.RegenHits = 0;
			Resistances.Cold = 0;
			Attributes.AttackChance = 0;
      }
      
		private void Transform( Mobile m )
		{
         m.SendMessage( "Citis ze se tve telo meni." );
         m.BodyMod = 317;
         m.HueMod = -1;
         m.DisplayGuildTitle = false;
         m.Hits = 10;
         m.Mana = 10;
         m.Stam = 10;
         
			Attributes.BonusStr = 20;
			Attributes.BonusHits = 10;
			Attributes.RegenHits = 5;
			Resistances.Cold = 20;
			Attributes.AttackChance = 20;
			
         m.PlaySound( 1325 );
			m.FixedParticles( 0x376A, 1, 14, 0x13B5, EffectLayer.Waist );
      }

		public override void OnDoubleClick( Mobile m )
		{
         if( Parent != m )
			{
				m.SendMessage( "Musis mit nahrdelnik nasazen aby sel pouzit!" );
			}
			else if( m.HasTrade )
			{
				m.SendMessage( "Nemuzes naramek pouzit pokud s nekym obchodujes!" );
			}
			else
			{
				this.BlessedFor = m;
            
            if ( BraceletofMinax.CheckTransform(  m, 317 ) )
				{
					if( m.IsBodyMod && m.BodyMod == 317 ) //z vlka na cloveka
					{
//                   ClearTransform( m );
                  m.RemoveItem(this);
					   m.EquipItem(this);
			         m.PlaySound( 0x511 );
			         m.FixedParticles( 0x376A, 1, 14, 0x13B5, EffectLayer.Waist );
                  m.SendMessage( "Ucinek nahrdelniku skoncil" );
               }
               else //na vlka
               {
					   m.RemoveItem(this);
                  Transform( m );
					   m.EquipItem(this);
               }
				}
			}
		}
		
        public override void OnRemoved(object parent)
        {
            base.OnRemoved( parent );
            
            if (parent is Mobile)
            {
                Mobile m = (Mobile)parent;
                if( m.BodyMod == 317 ) //z demona na cloveka
                  ClearTransform( m );
            }
        }

		public AmuletOfTheVampireBat( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
			
			if( Parent is Mobile && ((Mobile)Parent).BodyMod > 0 )
			{
            ((Mobile)Parent).BodyMod = 0;
            ((Mobile)Parent).HueMod = -1;
            ((Mobile)Parent).NameMod = null;
            ((Mobile)Parent).DisplayGuildTitle = true;
         
			   Attributes.BonusStr = 0;
			   Attributes.BonusHits = 0;
			   Attributes.RegenHits = 0;
			   Resistances.Cold = 0;
			   Attributes.AttackChance = 0;
			}
		}
	}
}
