using System;
using Server.Network;
using Server.Items;

namespace Server.Items
{
    public class Zanbato : LevelNoDachi
    {
        private int m_Bonus = 0;

        public int Bonus { get { return m_Bonus; } set { m_Bonus = Math.Min(value, 10); InvalidateProperties(); } }

        public bool UpgradeTier()
        {
            if (m_Bonus + 1 > 10 || Level < 150 || Points > 0) //max tier
                return false;

            m_Bonus++;

            this.SkillBonuses.Skill_1_Value += 2.0;
            this.SkillBonuses.Skill_2_Value += 2.0;
            this.SkillBonuses.Skill_3_Value += 2.0;
            this.Attributes.WeaponDamage += 7;
            this.Attributes.AttackChance += 3;
            this.Attributes.WeaponSpeed += 2;
            this.Attributes.DefendChance += 2;
            this.Attributes.Luck += 100;
            this.Attributes.ReflectPhysical += 2;
            this.Attributes.BonusStr += 2;
            this.Attributes.BonusHits += 2;

            return true;
        }

        public override int AosStrengthReq { get { return 70; } }
        public override int AosMinDamage { get { return 19; } }
        public override int AosMaxDamage { get { return 23; } }

        public override int ArtifactRarity { get { return 70; } }
        public override int InitMinHits { get { return 125; } }
        public override int InitMaxHits { get { return 125; } }

        [Constructable]
        public Zanbato()
        {
            Weight = 12.0;
            this.Hue = 1097;
            this.Name = "<bodytext=#9966FF><center>Zanbatō [horse-slaying sword]";
            Slayer = SlayerName.Exorcism;
            Slayer2 = SlayerName.Repond;

            SkillBonuses.SetValues(0, SkillName.Tactics, 5.0);
            SkillBonuses.SetValues(1, SkillName.Focus, 5.0);
            SkillBonuses.SetValues(2, SkillName.Bushido, 5.0);

            WeaponAttributes.SelfRepair = 3;
            WeaponAttributes.HitLeechHits = 20;
            WeaponAttributes.HitLeechStam = 20;
            WeaponAttributes.HitHarm = 20;
            WeaponAttributes.HitLightning = 20;

            NewSecondaryAbility = WeaponAbility.AbilityType.ArmorIgnore;
        }

        public override void GetProperties(ObjectPropertyList list)
        {
            base.GetProperties(list);

            if (m_Bonus > 0)
                list.Add("<basefont color=#9966FF>Bleed attack: +" + (m_Bonus * 50).ToString() + "% over 5 sec\nCrushing blow stun chance: 4 yards, " + m_Bonus.ToString() + " sec\n Champion slayer +" + (m_Bonus * 10).ToString() + "%<basefont color=White>");
        }

        public override void AddNameProperties(ObjectPropertyList list)
        {
            base.AddNameProperties(list);

            if (m_Bonus > 0)
                list.Add(1072819, "<basefont color=#9966FF>" + m_Bonus.ToString() + "<basefont color=White>");//Current Tier: ~1_TIER~
        }

        public override void GetDamageTypes(Mobile wielder, out int phys, out int fire, out int cold, out int pois, out int nrgy)
        {
            pois = fire = cold = 0;
            phys = nrgy = 50;
        }

        public Zanbato(Serial serial) : base(serial)
        {
        }

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);

            writer.Write((int)1); // version
            writer.Write((int)m_Bonus);
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);

            int version = reader.ReadInt();

            switch (version)
            {
                case 1:
                    {
                        m_Bonus = reader.ReadInt();
                        break;
                    }
            }
        }

        public static bool HasFullSet(Mobile from)
        {
            if (!(from.ArmsArmor is ArmsOfMakoto && ((ArmsOfMakoto)from.ArmsArmor).Bonus > 4 && ((Item)from.ArmsArmor).BlessedFor == from))
                return false;
            else if (!(from.HeadArmor is KabutoOfChi && ((KabutoOfChi)from.HeadArmor).Bonus > 4 && ((Item)from.HeadArmor).BlessedFor == from))
                return false;
            else if (!(from.LegsArmor is LegsOfYuki && ((LegsOfYuki)from.LegsArmor).Bonus > 4 && ((Item)from.LegsArmor).BlessedFor == from))
                return false;
            else if (!(from.ChestArmor is PlateOfMeiyo && ((PlateOfMeiyo)from.ChestArmor).Bonus > 4 && ((Item)from.ChestArmor).BlessedFor == from))
                return false;
            else if (!(from.Weapon is Zanbato && ((Zanbato)from.Weapon).Bonus > 9 && ((Item)from.Weapon).BlessedFor == from))
                return false;
            else
                return true;
        }
    }
}