/*
 *   Scripter :
 *   Author : Lord Mashadow // Avalon Team
 *   Generator : Avalon Script Creator
 *   Created at :  1.9.2007 12:41:26
 *   Thank you for using this tool, feel free to visit our web site  www.avalon.gen.tr
 */
using System;
using Server;
using Server.Items;

namespace Server.Items
{
	[FlipableAttribute( 0x2B0A, 0x2B0B )]
	public class ArmsOfCompassion : PlateArms
	{
		private int m_Bonus = 0;
		
		//     		[CommandProperty(AccessLevel.GameMaster)]
		public int Bonus { get { return m_Bonus; } set { m_Bonus = Math.Min( value, 5 ); InvalidateProperties(); } }
		
		public bool UpgradeTier()
		{
			if ( m_Bonus + 1 > 5 ) //max tier
				return false;
			
			m_Bonus++;
			
			this.Attributes.AttackChance += 5;
			this.Attributes.BonusDex += 3;
			this.Attributes.BonusInt += 1;
			this.Attributes.BonusStr += 1;
			this.Attributes.LowerRegCost += 1;
			this.Attributes.Luck += 5;
			this.Attributes.RegenHits += 2;
			this.Attributes.RegenMana += 1;
			this.Attributes.RegenStam += 1;
			this.Attributes.WeaponDamage += 3;
			this.Attributes.BonusHits += 2;
			this.Attributes.BonusMana += 3;
			this.Attributes.BonusStam += 2;
			
			this.ArmorAttributes.LowerStatReq += 2;
			
			this.SkillBonuses.SetValues( 0, SkillName.Tactics, ( m_Bonus * 4 ) );
			this.SkillBonuses.SetValues( 1, SkillName.Swords, ( m_Bonus * 2 ) );
			
			return true;
		}
		
		public override int ArtifactRarity{ get{ return 72; } }
		public override int InitMinHits{ get{ return 125; } }
		public override int InitMaxHits{ get{ return 125; } }
		
		public override int BasePhysicalResistance{ get{ return 15; } }
		public override int BaseFireResistance{ get{ return 10; } }
		public override int BaseColdResistance{ get{ return 10; } }
		public override int BasePoisonResistance{ get{ return 10; } }
		public override int BaseEnergyResistance{ get{ return 10; } }

		[Constructable]
		public ArmsOfCompassion()
		{
			this.Weight = 4;
			this.Name = "Arms Of Compassion";
			this.ItemID = 0x2B0A;

			this.Attributes.AttackChance = 10;
			this.Attributes.BonusDex = 5;
			this.Attributes.BonusInt = 5;
			this.Attributes.BonusStr = 5;
			this.Attributes.LowerManaCost = 5;
			this.Attributes.LowerRegCost = 15;
			this.Attributes.Luck = 250;
			this.Attributes.RegenHits = 5;
			this.Attributes.RegenMana = 5;
			this.Attributes.RegenStam = 5;
			this.Attributes.WeaponDamage = 10;
			this.Attributes.BonusHits = 5;
			this.Attributes.BonusMana = 5;
			
			this.ArmorAttributes.SelfRepair = 5;
			this.ArmorAttributes.LowerStatReq = 15;
			this.ArmorAttributes.MageArmor = 1;
		}

		public ArmsOfCompassion( Serial serial ) : base( serial )
		{
		}
		
		public override void GetProperties(ObjectPropertyList list)
		{
			base.GetProperties(list);
			
         if ( m_Bonus > 4 )
			   list.Add( "<basefont color=#9999FF>Consecrate Weapon: +20 sec<basefont color=White>" );
		}
		
		public override void AddNameProperties( ObjectPropertyList list )
		{
			base.AddNameProperties( list );
			
			if ( m_Bonus > 0 )
				list.Add( 1072819, "<basefont color=#9999FF>" + m_Bonus.ToString() + "<basefont color=White>" );//Current Tier: ~1_TIER~
		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);

			writer.Write((int)1); // version
			writer.Write((int)m_Bonus);
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);

			int version = reader.ReadInt();

			switch (version)
			{
				case 1:
					{
						m_Bonus = reader.ReadInt();
						break;
					}
			}
		}
	}
}
