/*
 *   Scripter :
 *   Author : Lord Mashadow // Avalon Team
 *   Generator : Avalon Script Creator
 *   Created at :  1.9.2007 13:05:04
 *   Thank you for using this tool, feel free to visit our web site  www.avalon.gen.tr
 */
using System;
using Server;
using Server.Items;

namespace Server.Items
{
	[Flipable( 0x2B04, 0x2B05 )]
	public class CloakOfHumility : BaseCloak
	{
		private int m_Bonus = 0;
		
		//     		[CommandProperty(AccessLevel.GameMaster)]
		public int Bonus { get { return m_Bonus; } set { m_Bonus = Math.Min( value, 5 ); InvalidateProperties(); } }
		
		public bool UpgradeTier()
		{
			if ( m_Bonus + 1 > 5 ) //max tier
				return false;
			
			m_Bonus++;
			
			this.Attributes.LowerManaCost += 1;
			this.Attributes.BonusMana += 3;
			this.Attributes.Luck += 5;
			this.Attributes.WeaponDamage += 2;
			this.Attributes.SpellDamage += 2;
			this.Attributes.EnhancePotions += 2;
			this.Attributes.ReflectPhysical += 2;
			this.Attributes.BonusHits += 2;
			
			this.SkillBonuses.SetValues( 0, SkillName.Musicianship, ( m_Bonus * 4 ) );
			this.SkillBonuses.SetValues( 1, SkillName.Provocation, ( m_Bonus * 2 ) );
			this.SkillBonuses.SetValues( 2, SkillName.Discordance, ( m_Bonus * 2 ) );
			this.SkillBonuses.SetValues( 3, SkillName.Peacemaking, ( m_Bonus * 2 ) );
			
			return true;
		}
		
		[Constructable]
		public CloakOfHumility() : base( 0x2B05 )
		{
			this.Weight = 2;
			this.Name = "Cloak Of Humility";

			this.Attributes.LowerManaCost = 5;
			this.Attributes.LowerRegCost = 15;
			this.Attributes.Luck = 250;
			this.Attributes.CastRecovery = 2;
			this.Attributes.CastSpeed = 2;
			this.Attributes.EnhancePotions = 25;
			this.Attributes.ReflectPhysical = 15;
			//             this.ArmorAttributes.LowerStatReq = 15;
		}

		public CloakOfHumility( Serial serial ) : base( serial )
		{
		}

		// 		public override int ArtifactRarity{ get{ return 72; } }
		
		public override void GetProperties(ObjectPropertyList list)
		{
			base.GetProperties(list);
			
         if ( m_Bonus > 4 )
			   list.Add( "<basefont color=#9999FF>Peacemaking: +100% against teragons<basefont color=White>" );
		}

		public override void AddNameProperties( ObjectPropertyList list )
		{
			base.AddNameProperties( list );
			
			if ( m_Bonus > 0 )
				list.Add( 1072819, "<basefont color=#9999FF>" + m_Bonus.ToString() + "<basefont color=White>" );//Current Tier: ~1_TIER~
		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);

			writer.Write((int)1); // version
			writer.Write((int)m_Bonus);
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);

			int version = reader.ReadInt();

			switch (version)
			{
				case 1:
					{
						m_Bonus = reader.ReadInt();
						break;
					}
			}
		}
	}
}
