/*
 *   Scripter :
 *   Author : Lord Mashadow // Avalon Team
 *   Generator : Avalon Script Creator
 *   Created at :  1.9.2007 13:00:01
 *   Thank you for using this tool, feel free to visit our web site  www.avalon.gen.tr
 */
using System;
using Server;
using Server.Items;

namespace Server.Items
{
	public class DupresShield : HeaterShield
	{
		private int m_Bonus = 0;
		
		//     		[CommandProperty(AccessLevel.GameMaster)]
		public int Bonus { get { return m_Bonus; } set { m_Bonus = Math.Min( value, 5 ); InvalidateProperties(); } }
		
		public bool UpgradeTier()
		{
			if ( m_Bonus + 1 > 6 ) //max tier
				return false;
			
			m_Bonus++;
			
			this.SkillBonuses.Skill_1_Value += 4.0;
			this.Attributes.WeaponDamage += 2;
			this.Attributes.AttackChance += 3;
			this.Attributes.Luck += 5;
			this.Attributes.ReflectPhysical += 2;
			this.Attributes.DefendChance += 2;
			this.Attributes.SpellDamage += 1;
			this.Attributes.BonusHits += 3;
			this.ArmorAttributes.LowerStatReq += 2;
			
			if ( m_Bonus > 5 )
			{
            this.SkillBonuses.SetValues( 2, SkillName.Focus, 12.0 );
			   this.Attributes.SpellChanneling = 1;
         }
			
			this.SkillBonuses.SetValues( 1, SkillName.MagicResist, ( m_Bonus * 2 ) );
			
			return true;
		}
		
		public override int ArtifactRarity{ get{ return 72; } }
		public override int InitMinHits{ get{ return 125; } }
		public override int InitMaxHits{ get{ return 125; } }
		
		public override int BasePhysicalResistance{ get{ return 15; } }

		[Constructable]
		public DupresShield()
		{
			this.Weight = 5;
			this.Name = "Dupre's Shield";
			this.ItemID = 0x2B01;
			this.SkillBonuses.SetValues( 0, SkillName.Parry, 12.0 );
			this.Attributes.LowerManaCost = 20;
			this.Attributes.LowerRegCost = 15;
			this.Attributes.Luck = 250;
			this.Attributes.ReflectPhysical = 25;
			this.Attributes.DefendChance = 10;
			this.Attributes.CastRecovery = 1;
			this.Attributes.CastSpeed = 1;
			this.Attributes.BonusHits = 20;
			
			this.ArmorAttributes.SelfRepair = 5;
			this.ArmorAttributes.LowerStatReq = 15;
			this.ArmorAttributes.MageArmor = 1;
		}

		public DupresShield( Serial serial ) : base( serial )
		{
		}
		
		public override void GetProperties(ObjectPropertyList list)
		{
			base.GetProperties(list);
			
         if ( m_Bonus > 4 )
			   list.Add( "<basefont color=#9999FF>Arcane Circle Bonus: +2<basefont color=White>" );
		}

		public override void AddNameProperties( ObjectPropertyList list )
		{
			base.AddNameProperties( list );
			
			if ( m_Bonus > 0 )
				list.Add( 1072819, "<basefont color=#9999FF>" + m_Bonus.ToString() + "<basefont color=White>" );//Current Tier: ~1_TIER~
		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);

			writer.Write((int)1); // version
			writer.Write((int)m_Bonus);
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);

			int version = reader.ReadInt();

			switch (version)
			{
				case 1:
					{
						m_Bonus = reader.ReadInt();
						break;
					}
			}
		}
	}
}
