/*
 *   Scripter :
 *   Author : Lord Mashadow // Avalon Team
 *   Generator : Avalon Script Creator
 *   Created at :  1.9.2007 13:05:04
 *   Thank you for using this tool, feel free to visit our web site  www.avalon.gen.tr
 */
using System;
using Server;
using Server.Items;

namespace Server.Items
{
	public class HelmOfSpirituality : PlateHelm
	{
		private int m_Bonus = 0;
		
		//     		[CommandProperty(AccessLevel.GameMaster)]
		public int Bonus { get { return m_Bonus; } set { m_Bonus = Math.Min( value, 5 ); InvalidateProperties(); } }
		
		public bool UpgradeTier()
		{
			if ( m_Bonus + 1 > 5 ) //max tier
				return false;
			
			m_Bonus++;
			
			this.Attributes.AttackChance += 2;
			this.Attributes.BonusDex += 1;
			this.Attributes.BonusInt += 3;
			this.Attributes.BonusStr += 1;
			this.Attributes.LowerRegCost += 1;
			this.Attributes.Luck += 5;
			this.Attributes.WeaponDamage += 2;
			this.Attributes.RegenMana += 1;
			this.Attributes.SpellDamage += 5;
			this.Attributes.BonusHits += 3;
			this.Attributes.BonusMana += 4;
			
			this.ArmorAttributes.LowerStatReq += 2;
			
			this.SkillBonuses.SetValues( 0, SkillName.EvalInt, ( m_Bonus * 4 ) );
			this.SkillBonuses.SetValues( 1, SkillName.Spellweaving, ( m_Bonus * 2 ) );
			
			return true;
		}
		
		public override int ArtifactRarity{ get{ return 72; } }
		public override int InitMinHits{ get{ return 125; } }
		public override int InitMaxHits{ get{ return 125; } }
		
		public override int BasePhysicalResistance{ get{ return 10; } }
		public override int BaseFireResistance{ get{ return 20; } }
		public override int BaseColdResistance{ get{ return 10; } }
		public override int BasePoisonResistance{ get{ return 10; } }
		public override int BaseEnergyResistance{ get{ return 10; } }

		[Constructable]
		public HelmOfSpirituality()
		{
			this.Weight = 5;
			this.Name = "Helm Of Spirituality";
			this.ItemID = 0x2B11;
			
			this.Attributes.AttackChance = 15;
			this.Attributes.BonusDex = 5;
			this.Attributes.BonusInt = 5;
			this.Attributes.BonusStr = 5;
			this.Attributes.LowerManaCost = 5;
			this.Attributes.LowerRegCost = 15;
			this.Attributes.Luck = 250;
			this.Attributes.WeaponDamage = 10;
			this.Attributes.RegenMana = 10;
			this.Attributes.SpellDamage = 10;
			this.Attributes.BonusHits = 5;
			this.Attributes.BonusMana = 5;
			this.Attributes.DefendChance = 15;
			
			this.ArmorAttributes.SelfRepair = 5;
			this.ArmorAttributes.LowerStatReq = 15;
			this.ArmorAttributes.MageArmor = 1;
		}

		public HelmOfSpirituality( Serial serial ) : base( serial )
		{
		}
		
		public override void GetProperties(ObjectPropertyList list)
		{
			base.GetProperties(list);
			
         if ( m_Bonus > 4 )
			   list.Add( "<basefont color=#9999FF>Gift of Life: +20 sec<basefont color=White>" );
		}

		public override void AddNameProperties( ObjectPropertyList list )
		{
			base.AddNameProperties( list );
			
			if ( m_Bonus > 0 )
				list.Add( 1072819, "<basefont color=#9999FF>" + m_Bonus.ToString() + "<basefont color=White>" );//Current Tier: ~1_TIER~
		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);

			writer.Write((int)1); // version
			writer.Write((int)m_Bonus);
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);

			int version = reader.ReadInt();

			switch (version)
			{
				case 1:
					{
						m_Bonus = reader.ReadInt();
						break;
					}
			}
		}
	}
}
