using System;
using Server;
using System.Collections;
using System.Collections.Generic;

namespace Server.Items
{
    public class KnightsRing : GoldRing
    {
        public override int ArtifactRarity { get { return 190; } }

        private DateTime m_NextSpecial;
        private int m_Bonus = 0;

        //     		[CommandProperty(AccessLevel.GameMaster)]
        public int Bonus { get { return m_Bonus; } set { m_Bonus = Math.Min(value, 10); InvalidateProperties(); } }
        public DateTime NextSpecial { get { return m_NextSpecial; } set { m_NextSpecial = value; } }

        public bool UpgradeTier()
        {
            if (m_Bonus + 1 > 10) //max tier
                return false;

            m_Bonus++;

            this.Attributes.AttackChance += 3;
            this.Attributes.BonusDex += 2;
            this.Attributes.BonusInt += 2;
            this.Attributes.BonusStr += 2;
            this.Attributes.DefendChance += 1;
            this.Attributes.Luck += 10;
            this.Attributes.RegenHits += 1;
            this.Attributes.RegenMana += 1;
            this.Attributes.SpellDamage += 4;
            this.Attributes.WeaponDamage += 4;
            this.Attributes.BonusHits += 2;
            this.Attributes.BonusMana += 3;
            this.Attributes.BonusStam += 3;
            this.Attributes.EnhancePotions += 1;
            this.Attributes.NightSight = 1;
            this.Attributes.ReflectPhysical += 1;

            this.Resistances.Physical += 1;
            this.Resistances.Fire += 1;
            this.Resistances.Cold += 1;
            this.Resistances.Poison += 1;
            this.Resistances.Energy += 1;

            this.SkillBonuses.SetValues(0, SkillName.Tactics, (m_Bonus * 2));
            this.SkillBonuses.SetValues(1, SkillName.EvalInt, (m_Bonus * 2));

            return true;
        }

        [Constructable]
        public KnightsRing()
        {
            Hue = 2168;
            Name = "<basefont color=#FF9900>Knight's Ring";
        }

        public KnightsRing(Serial serial) : base(serial)
        {
        }

        public override void GetProperties(ObjectPropertyList list)
        {
            base.GetProperties(list);

            if (m_Bonus > 0)
                list.Add("<basefont color=#FF9900>+{0}% Damage Against Teragons\nFlames Of Revenge Ability<basefont color=White>", m_Bonus + 5);
        }

        public override void AddNameProperties(ObjectPropertyList list)
        {
            base.AddNameProperties(list);

            if (m_Bonus > 0)
                list.Add(1072819, "<basefont color=#9999FF>" + m_Bonus.ToString() + "<basefont color=White>");//Current Tier: ~1_TIER~
        }

        public void FlamesOfRevenge(Mobile monster, Mobile player)
        {
            m_NextSpecial = DateTime.Now + TimeSpan.FromMinutes(2.0);

            ExpireTimer timer = (ExpireTimer)m_Table[monster];

            if (timer == null)
            {
                player.Emote(String.Format("Flames of revenge on {0}!", monster.RawName));
                player.PlaySound(71);
                timer = new ExpireTimer(monster, player);
                timer.Start();
                m_Table[monster] = timer;
            }
        }

        private static Hashtable m_Table = new Hashtable();

        private class ExpireTimer : Timer
        {
            private Mobile m_Mobile;
            private Mobile m_From;
            private int m_Count;

            public ExpireTimer(Mobile m, Mobile from)
                : base(TimeSpan.FromSeconds(5.0), TimeSpan.FromSeconds(5.0))
            {
                m_Mobile = m;
                m_From = from;
                Priority = TimerPriority.FiveSeconds;
            }

            public void DoExpire()
            {
                Stop();
                m_Table.Remove(m_Mobile);
            }

            public void DrainLife()
            {
                if (m_Mobile.Alive && !m_Mobile.Blessed && !m_Mobile.Deleted)
                {
                    m_Mobile.FixedParticles(6581, 10, 180, 0x2543, 0, 0, EffectLayer.Head);
                    m_Mobile.PlaySound(0x5CF);
                    m_Mobile.PlaySound(477);
                    int damage = Engines.XmlSpawner2.XmlSpecial.PercentualDamage(4, m_Mobile);

                    m_Mobile.Hits -= damage;
                    m_Mobile.SendDamageToAll(damage);

                    if (m_Mobile.Hits < 2)
                        m_Mobile.Kill();
                }
                else
                    DoExpire();
            }

            protected override void OnTick()
            {
                DrainLife();

                if (++m_Count >= 3)
                {
                    DoExpire();
                }
            }
        }

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);

            writer.Write((int)0); // version
            writer.Write((int)m_Bonus);
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);

            int version = reader.ReadInt();

            switch (version)
            {
                case 0:
                    {
                        m_Bonus = reader.ReadInt();
                        break;
                    }
            }
        }
    }
}