/*
 *   Scripter :
 *   Author : Lord Mashadow // Avalon Team
 *   Generator : Avalon Script Creator
 *   Created at :  1.9.2007 12:49:40
 *   Thank you for using this tool, feel free to visit our web site  www.avalon.gen.tr
 */
using System;
using Server;

namespace Server.Items
{
	[FlipableAttribute( 0x2B09, 0x2B08 )]
	public class PlateOfJustice : PlateChest
	{
		private int m_Bonus = 0;
		
		//     		[CommandProperty(AccessLevel.GameMaster)]
		public int Bonus { get { return m_Bonus; } set { m_Bonus = Math.Min( value, 5 ); InvalidateProperties(); } }
		
		public bool UpgradeTier()
		{
			if ( m_Bonus + 1 > 5 ) //max tier
				return false;
			
			m_Bonus++;
			
			this.Attributes.BonusDex += 1;
			this.Attributes.BonusInt += 1;
			this.Attributes.BonusStr += 3;
			this.Attributes.AttackChance += 2;
			this.Attributes.Luck += 5;
			this.Attributes.SpellDamage += 3;
			this.Attributes.WeaponDamage += 2;
			this.Attributes.WeaponSpeed += 1;
			this.Attributes.BonusHits += 2;
			this.Attributes.BonusStam += 3;
			this.ArmorAttributes.LowerStatReq += 1;
			
			this.Attributes.ReflectPhysical += 1;
			this.Attributes.DefendChance += 1;
			
			this.SkillBonuses.SetValues( 0, SkillName.Anatomy, ( m_Bonus * 4 ) );
			this.SkillBonuses.SetValues( 1, SkillName.Macing, ( m_Bonus * 2 ) );
			
			return true;
		}
		
		public override int ArtifactRarity{ get{ return 72; } }
		public override int InitMinHits{ get{ return 125; } }
		public override int InitMaxHits{ get{ return 125; } }
		
		public override int BasePhysicalResistance{ get{ return 20; } }
		public override int BaseFireResistance{ get{ return 20; } }
		public override int BaseColdResistance{ get{ return 15; } }
		public override int BasePoisonResistance{ get{ return 15; } }
		public override int BaseEnergyResistance{ get{ return 15; } }
		
		[Constructable]
		public PlateOfJustice()// : base( 0x2B09 )
		{
			this.Weight = 6;
			this.ItemID = 0x2B09;
			this.Name = "Breastplate Of Justice";

			this.Attributes.BonusDex = 5;
			this.Attributes.BonusInt = 5;
			this.Attributes.BonusStr = 5;
			this.Attributes.LowerManaCost = 5;
			this.Attributes.LowerRegCost = 15;
			this.Attributes.Luck = 250;
			this.Attributes.SpellDamage = 20;
			this.Attributes.WeaponDamage = 15;
			this.Attributes.WeaponSpeed = 10;
			this.Attributes.BonusHits = 5;
			this.ArmorAttributes.LowerStatReq = 15;
			this.ArmorAttributes.MageArmor = 1;
			
			this.ArmorAttributes.SelfRepair = 5;
			this.Attributes.ReflectPhysical = 15;
			this.Attributes.DefendChance = 15;
		}

		public PlateOfJustice( Serial serial ) : base( serial )
		{
		}
		
		public override void GetProperties(ObjectPropertyList list)
		{
			base.GetProperties(list);
			
         if ( m_Bonus > 4 )
			   list.Add( "<basefont color=#9999FF>Enemy of One: +15% Damage to target<basefont color=White>" );
		}
		
		public override void AddNameProperties( ObjectPropertyList list )
		{
			base.AddNameProperties( list );
			
			if ( m_Bonus > 0 )
				list.Add( 1072819, "<basefont color=#9999FF>" + m_Bonus.ToString() + "<basefont color=White>" );//Current Tier: ~1_TIER~
		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);

			writer.Write((int)1); // version
			writer.Write((int)m_Bonus);
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);

			int version = reader.ReadInt();

			switch (version)
			{
				case 1:
					{
						m_Bonus = reader.ReadInt();
						break;
					}
			}
		}
	}
}
