using System;

namespace Server.Items
{
    [Flipable(0x2B04, 0x2B05)]
    public class CloakOfEmpowerment : BaseCloak
    {
        private OnEquipTimer m_Timer;

        public override int BasePhysicalResistance { get { return 20; } }
        public override int BaseFireResistance { get { return 0; } }
        public override int BaseColdResistance { get { return 17; } }
        public override int BasePoisonResistance { get { return 12; } }
        public override int BaseEnergyResistance { get { return 19; } }
        
        [Constructable]
        public CloakOfEmpowerment()
            : base(0x2B04)
        {
            Name = "Cloak of flaming Empowerment";
            Weight = 4.0;
            Hue = 1161;
            Attributes.EnhancePotions = 50;
            Attributes.LowerManaCost = 50;
            Attributes.LowerRegCost = 100;
            Attributes.BonusDex = 100;
            Attributes.BonusStr = 100;
            Attributes.BonusInt = 100;
            Attributes.CastRecovery = 6;
            Attributes.CastSpeed = 3;
            
            LootType = LootType.Blessed;
        }

        public override bool OnEquip(Mobile from)
        {
            return Validate(from) && base.OnEquip(from);
        }

        public override void OnSingleClick(Mobile from)
        {
            if (Validate(Parent as Mobile))
                base.OnSingleClick(from);
        }

        public bool Validate(Mobile m)
        {
            if (m == null || !m.Player)
                return false;
            else
            {
                m_Timer = new OnEquipTimer(this, m);
                m_Timer.Start();
                m.SendMessage("The great power of the cloak binds on you");
                m.FixedParticles(0x36BD, 20, 10, 5044, EffectLayer.Head);
                m.PlaySound(0x205);
                this.Movable = false;
            }

            return true;
        }

        public CloakOfEmpowerment(Serial serial)
            : base(serial)
        {
        }

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);

            writer.Write((int)0); // version
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);

            int version = reader.ReadInt();
            this.Movable = true;
        }

        private class OnEquipTimer : Timer
        {
            private Item m_Item;
            private Mobile m;

            public OnEquipTimer(Item item, Mobile from)
                : base(TimeSpan.FromSeconds(Utility.RandomMinMax(200, 300)))
            {
                Priority = TimerPriority.FiftyMS;

                m_Item = item;
                m = from;
            }

            protected override void OnTick()
            {
                if ( m_Item == null || m_Item.Deleted || m == null )
                    return;

                Map map = m_Item.Map;
                if (map == null)
                    return;

                m.FixedParticles(0x3709, 10, 30, 5052, EffectLayer.LeftFoot);
                m.FixedParticles( 0x36BD, 20, 10, 5044, EffectLayer.Head );
                Effects.PlaySound(m_Item.Location, m_Item.Map, 0x307);
                m_Item.Delete();
                m.PlaySound(0x208);
                AOS.Damage(m, 200, 0, 100, 0, 0, 0);
                m.SendMessage("The cloak destroyed itself after charging to much magical power");
            }
        }
    }
}