using System;

namespace Server.Items
{
	[FlipableAttribute( 0x2FB8, 0x3172 )]
	public class Eyes : BaseArmor
	{
		public override ArmorMaterialType MaterialType{ get{ return ArmorMaterialType.Plate; } }

		[Constructable]
		public Eyes() : base( 0x2FB8 )
		{
			Name = "Eyes of the Beholder";
			Hue = 1157;
			Weight = 1.0;
			Layer = Layer.Talisman;

         Attributes.BonusInt = 5;
         Attributes.CastRecovery = 2;
         Attributes.CastSpeed = 1;
         Attributes.LowerManaCost = 10;
         Attributes.LowerRegCost = 17;
         Attributes.Luck = 100;
         Attributes.NightSight = 1;
		}

		public Eyes( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}

