//Scripted by Morgion (this script is based on AncientSmithyHammer and using Skillgroups from MarkOfTravesty script by Midnight Dragon)
using System;
using Server;
using Server.Engines.Craft;

namespace Server.Items
{
    public class NeonRing : GoldRing
    {
        private int m_Bonus;
        private int m_Bonus2;
        private SkillMod m_SkillMod;
        private SkillMod m_SkillMod2;
        private SkillName m_WhatSkill;
        private SkillName m_WhatSkill2;

        [CommandProperty(AccessLevel.GameMaster)]
        public int Bonus
        {
            get
            {
                return m_Bonus;
            }
            set
            {
                m_Bonus = value;
                InvalidateProperties();

                if (m_Bonus == 0)
                {
                    if (m_SkillMod != null)
                        m_SkillMod.Remove();

                    m_SkillMod = null;
                }
                else if (m_SkillMod == null && Parent is Mobile)
                {
                    m_SkillMod = new DefaultSkillMod(m_WhatSkill, true, m_Bonus);
                    m_SkillMod.ObeyCap = false;
                    ((Mobile)Parent).AddSkillMod(m_SkillMod);
                }
                else if (m_SkillMod != null)
                {
                    m_SkillMod.Value = m_Bonus;
                }
            }
        }

        [CommandProperty(AccessLevel.GameMaster)]
        public int Bonus2
        {
            get
            {
                return m_Bonus2;
            }
            set
            {
                m_Bonus2 = value;
                InvalidateProperties();

                if (m_Bonus2 == 0)
                {
                    if (m_SkillMod2 != null)
                        m_SkillMod2.Remove();

                    m_SkillMod2 = null;
                }
                else if (m_SkillMod2 == null && Parent is Mobile)
                {
                    m_SkillMod2 = new DefaultSkillMod(m_WhatSkill2, true, m_Bonus2);
                    m_SkillMod2.ObeyCap = false;
                    ((Mobile)Parent).AddSkillMod(m_SkillMod);
                }
                else if (m_SkillMod2 != null)
                {
                    m_SkillMod2.Value = m_Bonus2;
                }
            }
        }

        [CommandProperty(AccessLevel.GameMaster)]
        public SkillName WhatSkill
        {
            get
            {
                return m_WhatSkill;
            }
            set
            {
                m_WhatSkill = value;
                InvalidateProperties();
            }
        }

        [CommandProperty(AccessLevel.GameMaster)]
        public SkillName WhatSkill2
        {
            get
            {
                return m_WhatSkill2;
            }
            set
            {
                m_WhatSkill2 = value;
                InvalidateProperties();
            }
        }

        public override void OnAdded(object parent)
        {
            base.OnAdded(parent);

            if (m_Bonus != 0 && parent is Mobile)
            {
                if (m_SkillMod != null)
                    m_SkillMod.Remove();

                m_SkillMod = new DefaultSkillMod(m_WhatSkill, true, m_Bonus);
                m_SkillMod.ObeyCap = false;
                ((Mobile)parent).AddSkillMod(m_SkillMod);
            }

            if (m_Bonus2 != 0 && parent is Mobile)
            {
                if (m_SkillMod2 != null)
                    m_SkillMod2.Remove();

                m_SkillMod2 = new DefaultSkillMod(m_WhatSkill2, true, m_Bonus2);
                m_SkillMod2.ObeyCap = false;
                ((Mobile)parent).AddSkillMod(m_SkillMod2);
            }
        }

        public override void OnRemoved(object parent)
        {
            base.OnRemoved(parent);

            if (m_SkillMod != null)
                m_SkillMod.Remove();

            m_SkillMod = null;

            if (m_SkillMod2 != null)
                m_SkillMod2.Remove();

            m_SkillMod2 = null;
        }

        [Constructable]
        public NeonRing()
            : base()
        {
            Name = "Neon Ring";
            Weight = 0.1;
            Hue = 1080; //1167

            m_Bonus = Utility.RandomMinMax(5, 10);
            m_Bonus2 = Utility.RandomMinMax(5, 10);

            switch (Utility.Random(94))
            {
                //---------------------------------------Begin Random Skill Groups------------------------------------------------// 
                //--Warrior Skill Group 0 ----------------------------------------------------------------------------------------//
                case 0: m_WhatSkill = SkillName.Archery;
                    m_WhatSkill2 = SkillName.Anatomy; AddBonuses(0); break;

                case 1: m_WhatSkill = SkillName.Archery;
                    m_WhatSkill2 = SkillName.Tactics; AddBonuses(0); break;

                case 2: m_WhatSkill = SkillName.Archery;
                    m_WhatSkill2 = SkillName.Anatomy; AddBonuses(0); break;

                case 3: m_WhatSkill = SkillName.Archery;
                    m_WhatSkill2 = SkillName.Chivalry; AddBonuses(0); break;

                case 4: m_WhatSkill = SkillName.Archery;
                    m_WhatSkill2 = SkillName.Poisoning; AddBonuses(0); break;

                case 5: m_WhatSkill = SkillName.Archery;
                    m_WhatSkill2 = SkillName.Focus; AddBonuses(0); break;

                case 6: m_WhatSkill = SkillName.Archery;
                    m_WhatSkill2 = SkillName.Bushido; AddBonuses(0); break;

                case 7: m_WhatSkill = SkillName.Swords;
                    m_WhatSkill2 = SkillName.Anatomy; AddBonuses(0); break;

                case 8: m_WhatSkill = SkillName.Swords;
                    m_WhatSkill2 = SkillName.Tactics; AddBonuses(0); break;

                case 9: m_WhatSkill = SkillName.Swords;
                    m_WhatSkill2 = SkillName.Parry; AddBonuses(0); break;

                case 10: m_WhatSkill = SkillName.Swords;
                    m_WhatSkill2 = SkillName.Chivalry; AddBonuses(0); break;

                case 11: m_WhatSkill = SkillName.Swords;
                    m_WhatSkill2 = SkillName.Poisoning; AddBonuses(0); break;

                case 12: m_WhatSkill = SkillName.Swords;
                    m_WhatSkill2 = SkillName.Focus; AddBonuses(0); break;

                case 13: m_WhatSkill = SkillName.Swords;
                    m_WhatSkill2 = SkillName.Bushido; AddBonuses(0); break;

                case 14: m_WhatSkill = SkillName.Macing;
                    m_WhatSkill2 = SkillName.Anatomy; AddBonuses(0); break;

                case 15: m_WhatSkill = SkillName.Macing;
                    m_WhatSkill2 = SkillName.Tactics; AddBonuses(0); break;

                case 16: m_WhatSkill = SkillName.Macing;
                    m_WhatSkill2 = SkillName.Parry; AddBonuses(0); break;

                case 17: m_WhatSkill = SkillName.Macing;
                    m_WhatSkill2 = SkillName.Chivalry; AddBonuses(0); break;

                case 18: m_WhatSkill = SkillName.Macing;
                    m_WhatSkill2 = SkillName.Poisoning; AddBonuses(0); break;

                case 19: m_WhatSkill = SkillName.Macing;
                    m_WhatSkill2 = SkillName.Focus; AddBonuses(0); break;

                case 20: m_WhatSkill = SkillName.Macing;
                    m_WhatSkill2 = SkillName.Bushido; AddBonuses(0); break;

                case 21: m_WhatSkill = SkillName.Fencing;
                    m_WhatSkill2 = SkillName.Anatomy; AddBonuses(0); break;

                case 22: m_WhatSkill = SkillName.Fencing;
                    m_WhatSkill2 = SkillName.Tactics; AddBonuses(0); break;

                case 23: m_WhatSkill = SkillName.Fencing;
                    m_WhatSkill2 = SkillName.Parry; AddBonuses(0); break;

                case 24: m_WhatSkill = SkillName.Fencing;
                    m_WhatSkill2 = SkillName.Chivalry; AddBonuses(0); break;

                case 25: m_WhatSkill = SkillName.Fencing;
                    m_WhatSkill2 = SkillName.Poisoning; AddBonuses(0); break;

                case 26: m_WhatSkill = SkillName.Fencing;
                    m_WhatSkill2 = SkillName.Focus; AddBonuses(0); break;

                case 27: m_WhatSkill = SkillName.Fencing;
                    m_WhatSkill2 = SkillName.Bushido; AddBonuses(0); break;

                case 28: m_WhatSkill = SkillName.Wrestling;
                    m_WhatSkill2 = SkillName.Anatomy; AddBonuses(0); break;

                case 29: m_WhatSkill = SkillName.Wrestling;
                    m_WhatSkill2 = SkillName.Tactics; AddBonuses(0); break;

                case 30: m_WhatSkill = SkillName.Anatomy;
                    m_WhatSkill2 = SkillName.Focus; AddBonuses(0); break;

                case 31: m_WhatSkill = SkillName.Focus;
                    m_WhatSkill2 = SkillName.Chivalry; AddBonuses(0); break;

                case 32: m_WhatSkill = SkillName.Focus;
                    m_WhatSkill2 = SkillName.Bushido; AddBonuses(0); break;

                case 33: m_WhatSkill = SkillName.Anatomy;
                    m_WhatSkill2 = SkillName.Tactics; AddBonuses(0); break;
                //--Spell Casting Skill Group 1 ----------------------------------------------------------------------------------//
                case 34: m_WhatSkill = SkillName.Magery;
                    m_WhatSkill2 = SkillName.MagicResist; AddBonuses(1); break;

                case 35: m_WhatSkill = SkillName.Magery;
                    m_WhatSkill2 = SkillName.EvalInt; AddBonuses(1); break;

                case 36: m_WhatSkill = SkillName.Magery;
                    m_WhatSkill2 = SkillName.Poisoning; AddBonuses(1); break;

                case 37: m_WhatSkill = SkillName.Magery;
                    m_WhatSkill2 = SkillName.SpiritSpeak; AddBonuses(1); break;

                case 38: m_WhatSkill = SkillName.Magery;
                    m_WhatSkill2 = SkillName.Inscribe; AddBonuses(1); break;

                case 39: m_WhatSkill = SkillName.Magery;
                    m_WhatSkill2 = SkillName.Meditation; AddBonuses(1); break;

                case 40: m_WhatSkill = SkillName.Magery;
                    m_WhatSkill2 = SkillName.Parry; AddBonuses(1); break;

                case 41: m_WhatSkill = SkillName.Necromancy;
                    m_WhatSkill2 = SkillName.MagicResist; AddBonuses(1); break;

                case 42: m_WhatSkill = SkillName.Necromancy;
                    m_WhatSkill2 = SkillName.EvalInt; AddBonuses(1); break;

                case 43: m_WhatSkill = SkillName.Necromancy;
                    m_WhatSkill2 = SkillName.Poisoning; AddBonuses(1); break;

                case 44: m_WhatSkill = SkillName.Necromancy;
                    m_WhatSkill2 = SkillName.SpiritSpeak; AddBonuses(1); break;

                case 45: m_WhatSkill = SkillName.Necromancy;
                    m_WhatSkill2 = SkillName.Inscribe; AddBonuses(1); break;

                case 46: m_WhatSkill = SkillName.Necromancy;
                    m_WhatSkill2 = SkillName.Meditation; AddBonuses(1); break;

                case 47: m_WhatSkill = SkillName.Necromancy;
                    m_WhatSkill2 = SkillName.Parry; AddBonuses(1); break;

                case 48: m_WhatSkill = SkillName.Spellweaving;
                    m_WhatSkill2 = SkillName.MagicResist; AddBonuses(1); break;

                case 49: m_WhatSkill = SkillName.Spellweaving;
                    m_WhatSkill2 = SkillName.EvalInt; AddBonuses(1); break;

                case 50: m_WhatSkill = SkillName.Spellweaving;
                    m_WhatSkill2 = SkillName.Meditation; AddBonuses(1); break;

                case 51: m_WhatSkill = SkillName.Spellweaving;
                    m_WhatSkill2 = SkillName.Inscribe; AddBonuses(1); break;

                case 52: m_WhatSkill = SkillName.MagicResist;
                    m_WhatSkill2 = SkillName.EvalInt; AddBonuses(1); break;

                case 53: m_WhatSkill = SkillName.MagicResist;
                    m_WhatSkill2 = SkillName.SpiritSpeak; AddBonuses(1); break;

                case 54: m_WhatSkill = SkillName.MagicResist;
                    m_WhatSkill2 = SkillName.Meditation; AddBonuses(1); break;

                case 55: m_WhatSkill = SkillName.EvalInt;
                    m_WhatSkill2 = SkillName.SpiritSpeak; AddBonuses(1); break;

                case 56: m_WhatSkill = SkillName.EvalInt;
                    m_WhatSkill2 = SkillName.Inscribe; AddBonuses(1); break;

                case 57: m_WhatSkill = SkillName.EvalInt;
                    m_WhatSkill2 = SkillName.Meditation; AddBonuses(1); break;

                case 58: m_WhatSkill = SkillName.Alchemy;
                    m_WhatSkill2 = SkillName.Inscribe; AddBonuses(1); break;

                case 59: m_WhatSkill = SkillName.SpiritSpeak;
                    m_WhatSkill2 = SkillName.Meditation; AddBonuses(1); break;

                case 60: m_WhatSkill = SkillName.Inscribe;
                    m_WhatSkill2 = SkillName.Meditation; AddBonuses(1); break;
                //--Crafting Skill Group 2 ---------------------------------------------------------------------------------------//
                case 61: m_WhatSkill = SkillName.Blacksmith;
                    m_WhatSkill2 = SkillName.Mining; AddBonuses(2); break;

                case 62: m_WhatSkill = SkillName.Blacksmith;
                    m_WhatSkill2 = SkillName.Tinkering; AddBonuses(2); break;

                case 63: m_WhatSkill = SkillName.Tailoring;
                    m_WhatSkill2 = SkillName.Alchemy; AddBonuses(2); break;

                case 64: m_WhatSkill = SkillName.Tailoring;
                    m_WhatSkill2 = SkillName.Cartography; AddBonuses(2); break;

                case 65: m_WhatSkill = SkillName.Fletching;
                    m_WhatSkill2 = SkillName.Blacksmith; AddBonuses(2); break;

                case 66: m_WhatSkill = SkillName.Carpentry;
                    m_WhatSkill2 = SkillName.Lumberjacking; AddBonuses(2); break;

                case 67: m_WhatSkill = SkillName.Carpentry;
                    m_WhatSkill2 = SkillName.Fletching; AddBonuses(2); break;

                case 68: m_WhatSkill = SkillName.Carpentry;
                    m_WhatSkill2 = SkillName.Tinkering; AddBonuses(2); break;

                case 69: m_WhatSkill = SkillName.Inscribe;
                    m_WhatSkill2 = SkillName.Cartography; AddBonuses(2); break;

                case 70: m_WhatSkill = SkillName.Inscribe;
                    m_WhatSkill2 = SkillName.Alchemy; AddBonuses(2); break;
                //--Misc Fighters Skill Group 3 ----------------------------------------------------------------------------------//
                case 71: m_WhatSkill = SkillName.Ninjitsu;
                    m_WhatSkill2 = SkillName.Stealth; AddBonuses(3); break;
                //--Tamers Skill Group 4 -----------------------------------------------------------------------------------------//
                case 72: m_WhatSkill = SkillName.AnimalTaming;
                    m_WhatSkill2 = SkillName.Veterinary; AddBonuses(4); break;

                case 73: m_WhatSkill = SkillName.AnimalTaming;
                    m_WhatSkill2 = SkillName.AnimalLore; AddBonuses(4); break;

                case 74: m_WhatSkill = SkillName.AnimalTaming;
                    m_WhatSkill2 = SkillName.Musicianship; AddBonuses(4); break;

                case 75: m_WhatSkill = SkillName.AnimalTaming;
                    m_WhatSkill2 = SkillName.Magery; AddBonuses(4); break;

                case 76: m_WhatSkill = SkillName.Veterinary;
                    m_WhatSkill2 = SkillName.AnimalLore; AddBonuses(4); break;
                //--Bard Skill Group 5 -------------------------------------------------------------------------------------------//
                case 77: m_WhatSkill = SkillName.Musicianship;
                    m_WhatSkill2 = SkillName.Peacemaking; AddBonuses(5); break;

                case 78: m_WhatSkill = SkillName.Musicianship;
                    m_WhatSkill2 = SkillName.Discordance; AddBonuses(5); break;

                case 79: m_WhatSkill = SkillName.Musicianship;
                    m_WhatSkill2 = SkillName.Provocation; AddBonuses(5); break;

                case 81: m_WhatSkill = SkillName.Peacemaking;
                    m_WhatSkill2 = SkillName.Provocation; AddBonuses(5); break;

                case 82: m_WhatSkill = SkillName.Peacemaking;
                    m_WhatSkill2 = SkillName.Discordance; AddBonuses(5); break;

                case 83: m_WhatSkill = SkillName.Provocation;
                    m_WhatSkill2 = SkillName.Discordance; AddBonuses(5); break;
                //--Misc Skill Group 2 -------------------------------------------------------------------------------------------//
                case 84: m_WhatSkill = SkillName.EvalInt;
                    m_WhatSkill2 = SkillName.Anatomy; AddBonuses(2); break;
                //--Misc Support Skill Group 6 -----------------------------------------------------------------------------------//
                case 85: m_WhatSkill = SkillName.Healing;
                    m_WhatSkill2 = SkillName.Anatomy; AddBonuses(6); break;
                //--T Hunter Skill Group 6 ---------------------------------------------------------------------------------------//
                case 86: m_WhatSkill = SkillName.Lockpicking;
                    m_WhatSkill2 = SkillName.RemoveTrap; AddBonuses(6); break;

                case 87: m_WhatSkill = SkillName.Lockpicking;
                    m_WhatSkill2 = SkillName.Cartography; AddBonuses(6); break;
                //--Rogue Skill Group 6 ------------------------------------------------------------------------------------------//
                case 88: m_WhatSkill = SkillName.Stealing;
                    m_WhatSkill2 = SkillName.Lockpicking; AddBonuses(6); break;

                case 89: m_WhatSkill = SkillName.Stealing;
                    m_WhatSkill2 = SkillName.Stealth; AddBonuses(6); break;

                case 90: m_WhatSkill = SkillName.Stealing;
                    m_WhatSkill2 = SkillName.Hiding; AddBonuses(6); break;

                case 91: m_WhatSkill = SkillName.Hiding;
                    m_WhatSkill2 = SkillName.Lockpicking; AddBonuses(6); break;

                case 92: m_WhatSkill = SkillName.Hiding;
                    m_WhatSkill2 = SkillName.Stealth; AddBonuses(6); break;

                case 93: m_WhatSkill = SkillName.RemoveTrap;
                    m_WhatSkill2 = SkillName.Stealth; AddBonuses(6); break;
                //---------------------------------------End Random Skill Groups--------------------------------------------------//
            }
        }

        public override void GetProperties(ObjectPropertyList list)
        {
            base.GetProperties(list);

            if (m_Bonus != 0)
                list.Add(1060451, "{0}\t{1}", m_WhatSkill, m_Bonus); // ~1_skillname~ +~2_val~
            if (m_Bonus2 != 0)
                list.Add(1060452, "{0}\t{1}", m_WhatSkill2, m_Bonus2); // ~1_skillname~ +~2_val~
        }

        public NeonRing(Serial serial)
            : base(serial)
        {
        }

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);

            writer.Write((int)0); // version

            writer.Write((int)m_Bonus);
            writer.Write((int)m_Bonus2);
            writer.Write((int)m_WhatSkill);
            writer.Write((int)m_WhatSkill2);
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);

            int version = reader.ReadInt();

            switch (version)
            {
                case 0:
                    {
                        m_Bonus = reader.ReadInt();
                        m_Bonus2 = reader.ReadInt();
                        m_WhatSkill = (SkillName)reader.ReadInt();
                        m_WhatSkill2 = (SkillName)reader.ReadInt();
                        break;
                    }
            }

            if (m_Bonus != 0 && Parent is Mobile)
            {
                if (m_SkillMod != null)
                    m_SkillMod.Remove();

                m_SkillMod = new DefaultSkillMod(m_WhatSkill, true, m_Bonus);
                m_SkillMod.ObeyCap = false;
                ((Mobile)Parent).AddSkillMod(m_SkillMod);
            }

            if (m_Bonus2 != 0 && Parent is Mobile)
            {
                if (m_SkillMod2 != null)
                    m_SkillMod2.Remove();

                m_SkillMod2 = new DefaultSkillMod(m_WhatSkill2, true, m_Bonus2);
                m_SkillMod2.ObeyCap = false;
                ((Mobile)Parent).AddSkillMod(m_SkillMod2);
            }
        }

        public void AddBonuses(int SkillGroup)
        {
            switch (SkillGroup)
            {
                case 0: //Warrior Skill Group
                    {
                        Attributes.WeaponDamage = Utility.RandomList(5, 10, 15, 20, 25, 30);
                        Attributes.DefendChance = Utility.RandomList(5, 10, 15);
                        Attributes.WeaponSpeed = Utility.RandomList(5, 10, 15);
                    }
                    break;
                case 1: //Spell Casting Group
                    {
                        Attributes.BonusInt = Utility.RandomMinMax(5, 10);
                        Attributes.SpellDamage = Utility.RandomList(5, 10, 15, 20);
                        Attributes.LowerManaCost = Utility.RandomList(5, 10, 15);
                    }
                    break;
                case 2: //Crafting Group
                    {
                        Attributes.BonusInt = Utility.RandomMinMax(5, 15);
                        Attributes.BonusDex = Utility.RandomMinMax(5, 15);
                        Attributes.BonusStr = Utility.RandomMinMax(5, 15);
                    }
                    break;
                case 3: //Misc Fighters Skill
                    {
                        Attributes.WeaponDamage = Utility.RandomList(5, 10, 15, 20, 25, 30);
                        Attributes.AttackChance = Utility.RandomList(5, 10, 15);
                        Attributes.WeaponSpeed = Utility.RandomList(5, 10, 15);
                    }
                    break;
                case 4: //Tamers Skill Group
                    {
                        Attributes.BonusHits = Utility.RandomMinMax(5, 15);
                        Attributes.RegenHits = Utility.RandomMinMax(1, 4);
                        Attributes.Luck = Utility.RandomMinMax(40, 170);
                    }
                    break;
                case 5: //Bard Skill Group
                    {
                        Attributes.BonusHits = Utility.RandomMinMax(5, 15);
                        Attributes.BonusMana = Utility.RandomMinMax(5, 15);
                        Attributes.Luck = Utility.RandomMinMax(40, 170);
                    }
                    break;
                case 6: //Other Group
                    {
                        Attributes.BonusHits = Utility.RandomMinMax(5, 15);
                        Attributes.BonusDex = Utility.RandomMinMax(5, 15);
                        Attributes.ReflectPhysical = Utility.RandomList(5, 10, 15, 20, 25, 30);
                    }
                    break;
            }
        }
    }
}
