using System;
using Server;

namespace Server.Items
{
	public class PlateOfHonorHelm : BaseArmor
	{
		public override int ArtifactRarity{ get{ return 32; } }
      
      public override int LabelNumber{ get{ return 1074303; } }
		public override int BasePhysicalResistance{ get{ return 8; } }
		public override int BaseFireResistance{ get{ return 5; } }
		public override int BaseColdResistance{ get{ return 5; } }
		public override int BasePoisonResistance{ get{ return 7; } }
		public override int BaseEnergyResistance{ get{ return 5; } }

		public override int InitMinHits{ get{ return 50; } }
		public override int InitMaxHits{ get{ return 65; } }

		public override int AosStrReq{ get{ return 80; } }
		public override int OldStrReq{ get{ return 40; } }

		public override int OldDexBonus{ get{ return -1; } }

		public override int ArmorBase{ get{ return 40; } }

		public override ArmorMaterialType MaterialType{ get{ return ArmorMaterialType.Plate; } }

		[Constructable]
		public PlateOfHonorHelm() : base( 0x1412 )
		{
			Weight = 5.0;
			Attributes.RegenHits = 1;
         Attributes.Luck = 100;
         Attributes.LowerRegCost = 5;
			Attributes.AttackChance = 5;
         Attributes.BonusStr = 3;
         Attributes.RegenMana = 2;
		}

		public PlateOfHonorHelm( Serial serial ) : base( serial )
		{
		}
		
		public override void AddNameProperties( ObjectPropertyList list )
		{
			base.AddNameProperties( list );
			
			list.Add( 1072376, "6" );
			
			if ( this.Parent is Mobile )
			{
				if ( this.Hue == 0x47E )
				{
					list.Add( 1072377 );
					list.Add( 1072513, "25" );
					list.Add( "Chivalry 10 (total)" );
				}
			}
		}

		public override void GetProperties( ObjectPropertyList list )
		{
			base.GetProperties( list );

			if ( this.Hue == 0x0 )
			{
				list.Add( 1072378 );
				list.Add( 1072382, "5" );
				list.Add( 1072383, "7" );
				list.Add( 1072384, "7" );
				list.Add( 1072385, "5" );
				list.Add( 1072386, "7" );
				list.Add( 1060450, "3" );
				list.Add( 1072513, "25" );
				list.Add( "Chivalry 10 (total)" );
				list.Add( 1060441 );list.Add( 1060437 );
			}
		}

		public override bool OnEquip( Mobile from )
		{
			
			Item shirt = from.FindItemOnLayer( Layer.InnerTorso );
			Item glove = from.FindItemOnLayer( Layer.Gloves );
			Item pants = from.FindItemOnLayer( Layer.Pants );
			Item neck = from.FindItemOnLayer( Layer.Neck );
			Item arms = from.FindItemOnLayer( Layer.Arms );
			
			if ( shirt != null && shirt.GetType() == typeof( PlateOfHonorChest ) && glove != null && glove.GetType() == typeof( PlateOfHonorGloves ) && pants != null && pants.GetType() == typeof( PlateOfHonorLegs ) && neck != null && neck.GetType() == typeof( PlateOfHonorGorget ) && arms != null && arms.GetType() == typeof( PlateOfHonorArms ) )
			{
				Effects.PlaySound( from.Location, from.Map, 503 );
				from.FixedParticles( 0x376A, 9, 32, 5030, EffectLayer.Waist );

				Hue = 0x47E;
				ArmorAttributes.SelfRepair = 3;ArmorAttributes.MageArmor = 1;
				Attributes.NightSight = 1;
				PhysicalBonus = 5;
				FireBonus = 7;
				ColdBonus = 7;
				PoisonBonus = 5;
				EnergyBonus = 7;

				PlateOfHonorChest chest = from.FindItemOnLayer( Layer.InnerTorso ) as PlateOfHonorChest;
				PlateOfHonorGloves gloves = from.FindItemOnLayer( Layer.Gloves ) as PlateOfHonorGloves;
				PlateOfHonorLegs legs = from.FindItemOnLayer( Layer.Pants ) as PlateOfHonorLegs;
				PlateOfHonorGorget gorget = from.FindItemOnLayer( Layer.Neck ) as PlateOfHonorGorget;
				PlateOfHonorArms arm = from.FindItemOnLayer( Layer.Arms ) as PlateOfHonorArms;

				chest.Hue = 0x47E;
				chest.Attributes.NightSight = 1;
				chest.Attributes.ReflectPhysical = 25;
				chest.ArmorAttributes.SelfRepair = 3;chest.ArmorAttributes.MageArmor = 1;
				chest.SkillBonuses.SetValues( 0, SkillName.Chivalry, 10.0 );
				chest.PhysicalBonus = 5;
				chest.FireBonus = 7;
				chest.ColdBonus = 7;
				chest.PoisonBonus = 5;
				chest.EnergyBonus = 7;

				gloves.Hue = 0x47E;
				gloves.Attributes.NightSight = 1;
				gloves.ArmorAttributes.SelfRepair = 3;gloves.ArmorAttributes.MageArmor = 1;
				gloves.PhysicalBonus = 5;
				gloves.FireBonus = 7;
				gloves.ColdBonus = 7;
				gloves.PoisonBonus = 5;
				gloves.EnergyBonus = 7;

				legs.Hue = 0x47E;
				legs.Attributes.NightSight = 1;
				legs.ArmorAttributes.SelfRepair = 3;legs.ArmorAttributes.MageArmor = 1;
				legs.PhysicalBonus = 5;
				legs.FireBonus = 7;
				legs.ColdBonus = 7;
				legs.PoisonBonus = 5;
				legs.EnergyBonus = 7;

				gorget.Hue = 0x47E;
				gorget.Attributes.NightSight = 1;
				gorget.ArmorAttributes.SelfRepair = 3;gorget.ArmorAttributes.MageArmor = 1;
				gorget.PhysicalBonus = 5;
				gorget.FireBonus = 7;
				gorget.ColdBonus = 7;
				gorget.PoisonBonus = 5;
				gorget.EnergyBonus = 7;
				
				arm.Hue = 0x47E;
				arm.Attributes.NightSight = 1;
				arm.ArmorAttributes.SelfRepair = 3;arm.ArmorAttributes.MageArmor = 1;
				arm.PhysicalBonus = 5;
				arm.FireBonus = 7;
				arm.ColdBonus = 7;
				arm.PoisonBonus = 5;
				arm.EnergyBonus = 7;
										
				from.SendLocalizedMessage( 1072391 );
			}
			this.InvalidateProperties();
			return base.OnEquip( from );							
		}

		public override void OnRemoved( object parent )
		{
			if ( parent is Mobile )
			{
				Mobile m = ( Mobile )parent;
				Hue = 0x0;
				ArmorAttributes.SelfRepair = 0;ArmorAttributes.MageArmor = 0;
				Attributes.NightSight = 0;
				PhysicalBonus = 0;
				FireBonus = 0;
				ColdBonus = 0;
				PoisonBonus = 0;
				EnergyBonus = 0;
				if ( m.FindItemOnLayer( Layer.InnerTorso ) is PlateOfHonorChest && m.FindItemOnLayer( Layer.Gloves ) is PlateOfHonorGloves && m.FindItemOnLayer( Layer.Arms ) is PlateOfHonorArms && m.FindItemOnLayer( Layer.Pants ) is PlateOfHonorLegs && m.FindItemOnLayer( Layer.Neck ) is PlateOfHonorGorget )
				{
					PlateOfHonorChest chest = m.FindItemOnLayer( Layer.InnerTorso ) as PlateOfHonorChest;
					chest.Hue = 0x0;
					chest.Attributes.NightSight = 0;
					chest.Attributes.ReflectPhysical = 0;
					chest.ArmorAttributes.SelfRepair = 0;chest.ArmorAttributes.MageArmor = 0;
					chest.SkillBonuses.SetValues( 0, SkillName.Chivalry, 0.0 );
					chest.PhysicalBonus = 0;
					chest.FireBonus = 0;
					chest.ColdBonus = 0;
					chest.PoisonBonus = 0;
					chest.EnergyBonus = 0;

					PlateOfHonorGloves gloves = m.FindItemOnLayer( Layer.Gloves ) as PlateOfHonorGloves;
					gloves.Hue = 0x0;
					gloves.Attributes.NightSight = 0;
					gloves.ArmorAttributes.SelfRepair = 0;gloves.ArmorAttributes.MageArmor = 0;
					gloves.PhysicalBonus = 0;
					gloves.FireBonus = 0;
					gloves.ColdBonus = 0;
					gloves.PoisonBonus = 0;
					gloves.EnergyBonus = 0;
					
					PlateOfHonorArms arm = m.FindItemOnLayer( Layer.Arms ) as PlateOfHonorArms;
					arm.Hue = 0x0;
					arm.Attributes.NightSight = 0;
					arm.ArmorAttributes.SelfRepair = 0;ArmorAttributes.MageArmor = 0;
					arm.PhysicalBonus = 0;
					arm.FireBonus = 0;
					arm.ColdBonus = 0;
					arm.PoisonBonus = 0;
					arm.EnergyBonus = 0;

					PlateOfHonorLegs legs = m.FindItemOnLayer( Layer.Pants ) as PlateOfHonorLegs;
					legs.Hue = 0x0;
					legs.Attributes.NightSight = 0;
					legs.ArmorAttributes.SelfRepair = 0;legs.ArmorAttributes.MageArmor = 0;
					legs.PhysicalBonus = 0;
					legs.FireBonus = 0;
					legs.ColdBonus = 0;
					legs.PoisonBonus = 0;
					legs.EnergyBonus = 0;

					PlateOfHonorGorget gorget = m.FindItemOnLayer( Layer.Neck ) as PlateOfHonorGorget;
					gorget.Hue = 0x0;
					gorget.Attributes.NightSight = 0;
					gorget.ArmorAttributes.SelfRepair = 0;gorget.ArmorAttributes.MageArmor = 0;
					gorget.PhysicalBonus = 0;
					gorget.FireBonus = 0;
					gorget.ColdBonus = 0;
					gorget.PoisonBonus = 0;
					gorget.EnergyBonus = 0;
				}
				this.InvalidateProperties();
			}
			base.OnRemoved( parent );
		}


		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}
		
		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();

			if ( Weight == 1.0 )
				Weight = 5.0;
		}
	}
}