using System;
using Server;
using System.Collections;
using System.Collections.Generic;

namespace Server.Items
{
    public class ShamansMask : LevelHornedTribalMask
	{
		public override int ArtifactRarity{ get{ return 42; } }

		public override int BasePhysicalResistance{ get{ return 5; } }
		public override int BaseFireResistance{ get{ return 12; } }
		public override int BaseColdResistance{ get{ return 12; } }
		public override int BaseEnergyResistance{ get{ return 25; } }

		public override int InitMinHits{ get{ return 125; } }
		public override int InitMaxHits{ get{ return 125; } }

		[Constructable]
		public ShamansMask()
		{
			Hue = 2567;
         Name = "<basefont color=lime>Shaman's Mask";

			Attributes.BonusInt = 10;
			Attributes.RegenMana = 3;
			Attributes.SpellDamage = 25;
			Attributes.LowerManaCost = 5;
			
			this.SkillBonuses.SetValues( 0, SkillName.Meditation, 10 );
			this.SkillBonuses.SetValues( 1, SkillName.EvalInt, 10 );
			this.SkillBonuses.SetValues( 2, SkillName.Necromancy, 10 );
			this.SkillBonuses.SetValues( 3, SkillName.Magery, 10 );
		}
		
		public override void GetProperties(ObjectPropertyList list)
		{
			base.GetProperties(list);
			
			list.Add( "<basefont color=lime>Can summon all totem types\nFireball totem\nFreezing totem\nCleansing totem<basefont color=White>" );
		}
		
		public override void OnRemoved( object parent )
		{
			if ( parent is Mobile )
			{
				Mobile from = ( Mobile )parent;
				ArrayList toDelete = new ArrayList();
				
           foreach ( Item i in from.GetItemsInRange( 18 ) )
           {
              if ( i is BaseTotem && ((BaseTotem)i).Owner == from )
               toDelete.Add( i ); 
           }
           
            foreach ( Item ite in toDelete )
            {
				  if ( ite == null || ite.Deleted )
				     continue;
              
              Effects.SendLocationParticles( EffectItem.Create( ite.Location, ite.Map, EffectItem.DefaultDuration ), 0x3728, 8, 20, 5042 );
				  Effects.PlaySound( ite.Location, ite.Map, 0x201 );
				  ite.Delete();
            }
			}
						
			base.OnRemoved( parent );
		}

		public ShamansMask( Serial serial ) : base( serial )
		{
		}
		
		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 );
		}
		
		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}