using System;
using Server.Items;
using Server.Mobiles;
using Server.Network;
using Server.Regions;
using Server.Gumps;
using Server.Spells;
using Server.Multis;
using Server.ContextMenus;
using System.Collections;
using System.Collections.Generic;

namespace Server.Items
{
	public class BankCrystal : Item, ISecurable
	{
		private SecureLevel m_Level;

		[CommandProperty(AccessLevel.GameMaster)]
		public SecureLevel Level
		{
			get { return m_Level; }
			set { m_Level = value; }
		}

		[Constructable]
		public BankCrystal() : base(0x1F1C)
		{
			Movable = true;
			Name = "Bankovni krystal";
			Hue = 1161;
			LootType = LootType.Blessed;
		}

		public override void OnDoubleClick(Mobile from)
		{
			Region region = Region.Find(from.Location, from.Map);

			bool IsDung = (region.IsPartOf(typeof(DungeonRegion)) || region.IsPartOf(typeof(CustomRegion)) || SpellHelper.IsTokunoDungeon(from.Map, from.Location));
			GroupDungeonRegion GroupDungeonRegion = (GroupDungeonRegion) Region.Find(from.Location, from.Map).GetRegion(typeof(GroupDungeonRegion));

			if (!IsChildOf(from.Backpack) && !(from.InRange(this.GetWorldLocation(), 4) && from.InLOS(this)))
			{
				from.SendLocalizedMessage(502138);
			}
			else if (from.AccessLevel < AccessLevel.Counselor && (IsDung || GroupDungeonRegion != null || SpellHelper.IsDoomGauntlet(from.Map, from.Location)))
			{
				if (GroupDungeonRegion != null || SpellHelper.IsDoomGauntlet(from.Map, from.Location) || SpellHelper.IsPandemonium(from.Map, from.Location) || from.Map == Map.Underworld)
				{
					from.SendMessage("Zde nelze bankovni krystal pouzit!");
				}
				else
				{
					int cost = (from.Map == Map.Auberon || from.Region.IsPartOf(typeof(FireRegion))) ? 10000 : 5000;

					if (from.Guild != null)
						cost -= AOS.Scale(cost, Math.Min(25, Guilds.Guild.GetLevel(from)));

					from.SendGump(new BankCrystalGump((PlayerMobile)from, this, cost));
				}
			}
			else
			{
				BankBox box = from.BankBox;
				if (box != null)
					box.Open();
			}
		}

		public override void GetContextMenuEntries(Mobile from, List<ContextMenuEntry> list)
		{
			base.GetContextMenuEntries(from, list);

			SetSecureLevelEntry.AddTo(from, this, list);
		}

		public BankCrystal(Serial serial) : base(serial)
		{
		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);

			writer.Write((int) 1); // version

			writer.WriteEncodedInt((int) m_Level);
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);

			int version = reader.ReadInt();

			switch(version)
			{
				case 1:
				{
					m_Level = (SecureLevel) reader.ReadEncodedInt();
					goto case 0;
				}

				case 0:
				{
					break;
				}
			}
		}
	}
}

namespace Server.Gumps
{
	public class BankCrystalGump : Gump
	{
		private BankCrystal m_Crystal;
		private PlayerMobile m_From;
		private int m_Cost;

		public BankCrystalGump(PlayerMobile from, BankCrystal crystal, int cost)
		: base(250, 150)
		{
			m_Crystal = crystal;
			m_From = from;
			m_Cost = cost;

			this.Closable = true;
			this.Disposable = true;
			this.Dragable = true;
			this.Resizable = false;
			this.AddPage(0);
			this.AddBackground(48, 68, 225, 180, 9300);
			//         this.AddAlphaRegion(53, 97, 214, 119);
			this.AddButton(71, 220, 242, 241, (int)Buttons.Cancel, GumpButtonType.Reply, 0);
			this.AddButton(188, 220, 247, 248, (int)Buttons.Okay, GumpButtonType.Reply, 0);
			string costString = string.Format("<basefont color=black>Pristup do bankovniho boxu z dungeonu je zpoplatnen castkou: <basefont color=red>{0} Zlatych<basefont color=black><br /><br />"+
			                                  "Opravdu chces bankovni box otevrit?", m_Cost.ToString("N0", Auberon.Chat.General.Nfi));
			this.AddHtml(55, 99, 209, 114, costString, (bool)true, (bool)false);
			this.AddImage(208, 52, 9804);
			this.AddLabel(56, 72, 32, @"Upozorneni:");
		}

		public enum Buttons
		{
			Cancel,
			Okay
		}

		public override void OnResponse(NetState ns, RelayInfo info)
		{
			switch(info.ButtonID)
			{
				case (int)Buttons.Okay:
				{
					if (m_From == null || m_Crystal == null)
						return;

					if (!m_Crystal.IsChildOf(m_From.Backpack) && !(m_From.InRange(m_Crystal.GetWorldLocation(), 4) && m_From.InLOS(m_Crystal)))
						m_From.SendLocalizedMessage(502138);
					else
					{
						if (ChargePlayer(m_From, m_Cost))
						{
							BankBox box = m_From.BankBox;
							if (box != null)
								box.Open();
						}
					}
				}

				break;
				case (int)Buttons.Cancel:
				{
				}

				break;
			}
		}

		private bool ChargePlayer(PlayerMobile p, int c_cost)
		{
			if (c_cost > 0)
			{
				if (Banker.Withdraw(p, c_cost))
				{
					p.SendLocalizedMessage(1060398, c_cost.ToString("N0")); // Amount charged
					p.SendLocalizedMessage(1060022, Banker.GetBalance(p).ToString("N0", Auberon.Chat.General.Nfi)); // Amount left, from bank
				}
				else
				{
					p.SendMessage("Nemas dostatek penez na otevreni bankovniho boxu v dungeonu.");
					return false;
				}
			}

			return true;
		}
	}
}