using System;
using System.Collections;
using Server;
using Server.Prompts;
using Server.Mobiles;
using Server.ContextMenus;
using Server.Gumps;
using Server.Items;
using Server.Network;
using Server.Targeting;
using Server.Misc;
using System.Text;
using System.Collections.Generic;

namespace Server.Items
{
    public class CheckBook : BaseContainer
    {
        private int m_Cash;
        private Mobile m_Owner;
        public override bool DisplaysContent { get { return false; } }
        public override bool DisplayWeight { get { return true; } }

        [CommandProperty(AccessLevel.GameMaster)]
        public int Cash { get { return m_Cash; } set { m_Cash = value; InvalidateProperties(); } }

        [CommandProperty(AccessLevel.GameMaster)]
        public Mobile Owner
        {
            get { return m_Owner; }
            set { m_Owner = value; }
        }

        [Constructable]
        public CheckBook()
            : base(0x23A0)
        {
            Movable = true;
            Weight = 0.5;
            Name = "Sekova knizka";
            LootType = LootType.Blessed;
            Hue = 186;
        }

        [Constructable]
        public CheckBook(Mobile m)
            : base(0x23A0)
        {
            Movable = true;
            Weight = 0.5;
            Name = "Sekova knizka";
            LootType = LootType.Blessed;
            m_Owner = m;
            Hue = 186;
        }

        public override void OnDoubleClick(Mobile from)
        {
            BankBox box = from.BankBox;
            if (m_Owner == null)
            {
                Mobile mobile = (Mobile)from;
                PlayerMobile pm = (PlayerMobile)from;

                Owner = pm;
            }
            if (from != m_Owner)
            {
                from.SendMessage("Tato sekova knizka neni tvoje");
            }
            else if (!IsChildOf(from.Backpack) && !(box != null && IsChildOf(box))) // Make sure its in their pack
            {
                from.SendLocalizedMessage(1042001); // That must be in your pack for you to use it.
                from.SendLocalizedMessage(1047026); // That must be in your bank box to use it.
            }
            else if (from is PlayerMobile)
            {
                from.SendGump(new CheckBookGump((PlayerMobile)from, this));
            }
        }
       
        public override bool OnDragDrop(Mobile from, Item dropped)
        {
            BankBox box = from.BankBox;

            if (box != null && IsChildOf(box))
            {
                if (dropped is Gold)
                {

                    if (Cash >= 1000000000)
                    {
                        from.SendMessage("Sekova knizka je plna");
                        return false;
                    }
                    else
                    {
                        Item curItem = dropped as Item;
                        Cash += curItem.Amount;
                        curItem.Delete();
                        from.CloseGump(typeof(CheckBookGump));
                        from.PlaySound(0x2E6);
                        //          from.SendGump( new CheckBookGump( (PlayerMobile)from, this ) );
                        return true;
                    }
                }

                if (dropped is BankCheck)
                {

                    if (Cash >= 1000000000)
                    {
                        from.SendMessage("Sekova knizka je plna");
                        return false;
                    }
                    else
                    {
                        BankCheck bankcheck = dropped as BankCheck;
                        Cash += bankcheck.Worth;
                        bankcheck.Delete();
                        from.CloseGump(typeof(CheckBookGump));
                        from.PlaySound(0x2E6);
                        //          from.SendGump( new CheckBookGump( (PlayerMobile)from, this ) );
                        return true;
                    }
                }
            }
            else
            {
                from.SendLocalizedMessage(1047026); // That must be in your bank box to use it.
                return false;
            }

            return false;
        }

        public void BeginCombine(Mobile from)
        {
            from.Target = new CheckBookTarget(this);
        }

        public void EndCombine(Mobile from, object o)
        {
            if (o is Item && ((Item)o).IsChildOf(from.Backpack))
            {
                // if (!( o is Gold ) || !( o is BankCheck ) )
                // {
                // from.SendMessage( "Toto neni zlato nebo sek" );
                // }
                if (o is Gold)
                {

                    if (Cash >= 1000000000)
                        from.SendMessage("Sekova knizka je plna");
                    else
                    {
                        Item curItem = o as Item;
                        Cash += curItem.Amount;
                        curItem.Delete();
                        from.PlaySound(0x2E6);
                        from.SendGump(new CheckBookGump((PlayerMobile)from, this));
                        BeginCombine(from);
                    }
                }

                if (o is BankCheck)
                {

                    if (Cash >= 1000000000)
                        from.SendMessage("Sekova knizka je plna");
                    else
                    {
                        BankCheck bankcheck = o as BankCheck;
                        Cash += bankcheck.Worth;
                        bankcheck.Delete();
                        from.PlaySound(0x2E6);
                        from.SendGump(new CheckBookGump((PlayerMobile)from, this));
                        BeginCombine(from);
                    }
                }
            }
            else
            {
                from.SendLocalizedMessage(1045158); // You must have the item in your backpack to target it.
            }
        }

        public CheckBook(Serial serial)
            : base(serial)
        {
        }

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);
            writer.Write((int)0); // version

            writer.Write((int)m_Cash);
            writer.Write((Mobile)m_Owner);

        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);
            int version = reader.ReadInt();

            m_Cash = reader.ReadInt();
            m_Owner = reader.ReadMobile();
            
            this.BlessedFor = m_Owner;
        }
    }
}

namespace Server.Gumps
{

    public class CheckBookGump : Gump
    {

        private PlayerMobile m_From;
        private CheckBook m_Book;

        public CheckBookGump(PlayerMobile from, Item item)
            : base(0, 0)
        {

            m_From = from;
            if (!(item is CheckBook))
                return;
            CheckBook book = item as CheckBook;
            m_Book = book;
            BankBox box = from.BankBox;

            m_From.CloseGump(typeof(CheckBookGump));

            this.Closable = true;
            this.Disposable = true;
            this.Dragable = true;
            this.Resizable = false;
            this.AddPage(0);
            this.AddImageTiled(53, 94, 511, 247, 3504);
            this.AddImage(560, 338, 3508);
            this.AddImage(31, 73, 3500);
            this.AddImage(31, 338, 3506);
            this.AddImageTiled(56, 73, 507, 24, 3501);
            this.AddImageTiled(57, 338, 504, 24, 3507);
            this.AddImageTiled(31, 98, 25, 245, 3503);
            this.AddImageTiled(560, 95, 25, 245, 3505);
            this.AddLabel(259, 89, 0, @"Sekova knizka");
            this.AddImage(537, 176, 3502);
            this.AddImage(537, 218, 3508);
            this.AddImage(381, 218, 3506);
            this.AddImage(381, 176, 3500);
            this.AddImageTiled(406, 176, 135, 24, 3501);
            this.AddImageTiled(406, 218, 132, 24, 3507);
            this.AddImageTiled(381, 200, 25, 20, 3503);
            this.AddImageTiled(537, 201, 25, 17, 3505);
            this.AddImage(560, 73, 3502);
            this.AddImageTiled(65, 234, 302, 5, 3007);
            this.AddImageTiled(59, 283, 203, 5, 3007);
            this.AddImageTiled(320, 283, 230, 5, 3007);
            this.AddLabel(64, 265, 0, @"Hlavni banka " + ServerList.ServerName.ToString());
            this.AddLabel(325, 262, 0, @"Majitel : ");
            this.AddImageTiled(65, 184, 302, 5, 3007);
            this.AddLabel(510, 89, 0, @"# 001");
            this.AddLabel(70, 164, 0, @"Castka na vyber :");
            this.AddLabel(318, 215, 0, @"Zlatych");
            this.AddLabel(59, 321, 0, @"Celkova castka v bance: " + Banker.GetBalance( m_From ).ToString( "N0", Auberon.Chat.General.Nfi ) + " Zlatych");
            this.AddLabel(398, 262, 0, from.Name.ToString());
            this.AddLabel(462, 310, 0, @"Vybrat hotovost");
            this.AddLabel(462, 333, 0, @"Vypsat sek");

            if (box != null && book.IsChildOf(box))
            {
                this.AddLabel(462, 288, 0, @"Ulozit");
                this.AddButton(445, 295, 2103, 2104, 1, GumpButtonType.Reply, 0); // Deposit
            }

            this.AddButton(445, 315, 2103, 2104, 2, GumpButtonType.Reply, 0); // withdraw
            this.AddButton(445, 336, 2103, 2104, 3, GumpButtonType.Reply, 0); // Check
            this.AddLabel(399, 164, 0, @"Pouzitelna castka:");
            this.AddLabel(399, 200, 0, book.Cash.ToString( "N0", Auberon.Chat.General.Nfi ));
            AddTextEntry(68, 216, 242, 20, 0, 1, "0");
        }

        public override void OnResponse(NetState sender, RelayInfo info)
        {
            BankBox box = m_From.BankBox;

            if (m_Book.Deleted)
                return;

            if (info.ButtonID == 1)
            {
                if (box != null && m_Book.IsChildOf(box))
                {
                    m_From.SendGump(new CheckBookGump(m_From, m_Book));
                    m_Book.BeginCombine(m_From);
                }
                else
                {
                    m_From.SendLocalizedMessage(1047026); // That must be in your bank box to use it.
                }
            }

            if (info.ButtonID == 2)
            {
                TextRelay tr_CashAmount = info.GetTextEntry(1);
                if (tr_CashAmount != null)
                {
                    int i_MaxAmount = 0;
                    try
                    {
                        i_MaxAmount = Convert.ToInt32(tr_CashAmount.Text, 10);
                    }
                    catch
                    {
                        m_From.SendMessage(1161, "Musis napsat pouze cisla");
                    }
                    if (i_MaxAmount > 0)
                    {
                        if (i_MaxAmount <= ((CheckBook)m_Book).Cash)
                        {
                            if (i_MaxAmount <= 60000)
                            {
                                m_From.AddToBackpack(new Gold(i_MaxAmount));
                                m_From.PlaySound(0x2E6);
                                m_From.SendMessage(1161, "Vybral(a) jsi {0} zlatych.", i_MaxAmount);
                                ((CheckBook)m_Book).Cash = (((CheckBook)m_Book).Cash - i_MaxAmount);
                            }
                            else
                                m_From.SendMessage(1161, "60.000 zlatych je maximalni castka");
                        }
                        else
                            m_From.SendMessage(1173, "Nemas tolik zlatych");
                    }
                    m_From.SendGump(new CheckBookGump(m_From, m_Book));
                }
            }

            if (info.ButtonID == 3)
            {
                TextRelay tr_CashAmount = info.GetTextEntry(1);
                if (tr_CashAmount != null)
                {
                    int i_MaxAmount = 0;
                    try
                    {
                        i_MaxAmount = Convert.ToInt32(tr_CashAmount.Text, 10);
                    }
                    catch
                    {
                        m_From.SendMessage(1161, "Musis napsat pouze cisla");
                    }
                    if (i_MaxAmount > 0)
                    {
                        if (i_MaxAmount <= ((CheckBook)m_Book).Cash)
                        {
                            if (i_MaxAmount <= 10000000)
                            {
                                m_From.AddToBackpack(new BankCheck(i_MaxAmount));
                                m_From.SendMessage(1161, "Vypsal(a) jsi sek na {0} zlatych.", i_MaxAmount);
                                ((CheckBook)m_Book).Cash = (((CheckBook)m_Book).Cash - i_MaxAmount);
                            }
                            else
                                m_From.SendMessage(1161, "Maximalni hodnota seku muze byt 10.000.000 zlatych .");
                        }
                        else
                            m_From.SendMessage(1173, "Nemas dostatek zlatych pro vypsani seku .");
                    }
                    m_From.SendGump(new CheckBookGump(m_From, m_Book));
                }
            }
        }
    }
}

namespace Server.Items
{
    public class CheckBookTarget : Target
    {
        private CheckBook m_Book;

        public CheckBookTarget(CheckBook book)
            : base(18, false, TargetFlags.None)
        {
            m_Book = book;
        }

        protected override void OnTarget(Mobile from, object targeted)
        {
            if (m_Book.Deleted)
                return;

            m_Book.EndCombine(from, targeted);
        }
    }
}
