using System;
using Server;
using Server.Items;
using Server.Gumps;
using Server.Mobiles;
using Server.Engines.Plants;
using System.Collections;
using System.Collections.Generic;

namespace Server.Items
{
    public class RegBook : BaseContainer
    {
        #region Vars
        public int m_BlackPearl;
        public int m_BloodMoss;
        public int m_Garlic;
        public int m_Ginseng;
        public int m_SulfurousAsh;
        public int m_SpidersSilk;
        public int m_NightShade;
        public int m_MandrakeRoot;
        public int m_NoxCrystal;
        public int m_PigIron;
        public int m_BatWing;
        public int m_DaemonBlood;
        public int m_GraveDust;
        public int m_EmptyBags;

        public override bool DisplaysContent { get { return false; } }
        public override bool DisplayWeight { get { return true; } }
        #endregion
        #region Props
        [CommandProperty(AccessLevel.GameMaster)]
        public int zEmptyBags
        {
            get { return m_EmptyBags; }
            set { m_EmptyBags = value; }
        }
        [CommandProperty(AccessLevel.GameMaster)]
        public int GraveDust
        {
            get { return m_GraveDust; }
            set { m_GraveDust = value; }
        }
        [CommandProperty(AccessLevel.GameMaster)]
        public int DaemonBlood
        {
            get { return m_DaemonBlood; }
            set { m_DaemonBlood = value; }
        }
        [CommandProperty(AccessLevel.GameMaster)]
        public int BatWing
        {
            get { return m_BatWing; }
            set { m_BatWing = value; }
        }
        [CommandProperty(AccessLevel.GameMaster)]
        public int PigIron
        {
            get { return m_PigIron; }
            set { m_PigIron = value; }
        }
        [CommandProperty(AccessLevel.GameMaster)]
        public int NoxCrystal
        {
            get { return m_NoxCrystal; }
            set { m_NoxCrystal = value; }
        }
        [CommandProperty(AccessLevel.GameMaster)]
        public int MandrakeRoot
        {
            get { return m_MandrakeRoot; }
            set { m_MandrakeRoot = value; }
        }
        [CommandProperty(AccessLevel.GameMaster)]
        public int NightShade
        {
            get { return m_NightShade; }
            set { m_NightShade = value; }
        }
        [CommandProperty(AccessLevel.GameMaster)]
        public int SpidersSilk
        {
            get { return m_SpidersSilk; }
            set { m_SpidersSilk = value; }
        }
        [CommandProperty(AccessLevel.GameMaster)]
        public int SulfAsh
        {
            get { return m_SulfurousAsh; }
            set { m_SulfurousAsh = value; }
        }
        [CommandProperty(AccessLevel.GameMaster)]
        public int Ginseng
        {
            get { return m_Ginseng; }
            set { m_Ginseng = value; }
        }
        [CommandProperty(AccessLevel.GameMaster)]
        public int Garlic
        {
            get { return m_Garlic; }
            set { m_Garlic = value; }
        }
        [CommandProperty(AccessLevel.GameMaster)]
        public int BloodMoss
        {
            get { return m_BloodMoss; }
            set { m_BloodMoss = value; }
        }
        [CommandProperty(AccessLevel.GameMaster)]
        public int BlackPearl
        {
            get { return m_BlackPearl; }
            set { m_BlackPearl = value; }
        }
        #endregion
        #region Ctor's
        [Constructable]
        public RegBook(int amount)
            : base(0xE3B)
        {
            Movable = true;
            Weight = 10.0;
            LootType = LootType.Blessed;
            Hue = 1161;
            Name = "Herbar";
            m_BlackPearl = amount;
            m_BloodMoss = amount;
            m_Garlic = amount;
            m_Ginseng = amount;
            m_SulfurousAsh = amount;
            m_SpidersSilk = amount;
            m_NightShade = amount;
            m_MandrakeRoot = amount;
            m_NoxCrystal = amount;
            m_PigIron = amount;
            m_BatWing = amount;
            m_DaemonBlood = amount;
            m_GraveDust = amount;
            m_EmptyBags = amount;
        }


        [Constructable]
        public RegBook()
            : base(0xE3B)
        {
            Movable = true;
            Weight = 10.0;
            LootType = LootType.Blessed;
            Hue = 1161;
            Name = "Herbar";
            m_BlackPearl = 0;
            m_BloodMoss = 0;
            m_Garlic = 0;
            m_Ginseng = 0;
            m_SulfurousAsh = 0;
            m_SpidersSilk = 0;
            m_NightShade = 0;
            m_MandrakeRoot = 0;
            m_NoxCrystal = 0;
            m_PigIron = 0;
            m_BatWing = 0;
            m_DaemonBlood = 0;
            m_GraveDust = 0;
            m_EmptyBags = 0;
        }

        public RegBook(Serial serial)
            : base(serial)
        {
        }

        #endregion
        #region Actions

        public override void OnDoubleClick(Mobile from)
        {
            from.CloseGump(typeof(RegBookGump));
            from.SendGump(new RegBookGump(from, this));
            //from.SendGump( new SeedBoxGump( ( PlayerMobile ) from, this ) );
        }

        public override bool OnDragDrop(Mobile from, Item dropped)
        {
            if (dropped is BaseReagent && !(dropped is DaemonBone))
            {
                if (dropped is BlackPearl)
                {
                    from.SendMessage(0x55C, String.Format("{0} Black Pearl bylo vlozeno do herbare.", dropped.Amount));
                    m_BlackPearl += dropped.Amount;
                    dropped.Delete();
                }
                if (dropped is Nightshade)
                {
                    from.SendMessage(0x55C, String.Format("{0} Nightshade bylo vlozeno do herbare.", dropped.Amount));
                    m_NightShade += dropped.Amount;
                    dropped.Delete();
                }
                if (dropped is SpidersSilk)
                {
                    from.SendMessage(0x55C, String.Format("{0} Spider's Silk bylo vlozeno do herbare.", dropped.Amount));
                    m_SpidersSilk += dropped.Amount;
                    dropped.Delete();
                }
                if (dropped is SulfurousAsh)
                {
                    from.SendMessage(0x55C, String.Format("{0} Sulfurous Ash bylo vlozeno do herbare.", dropped.Amount));
                    m_SulfurousAsh += dropped.Amount;
                    dropped.Delete();
                }
                if (dropped is Bloodmoss)
                {
                    from.SendMessage(0x55C, String.Format("{0} Bloodmoss bylo vlozeno do herbare.", dropped.Amount));
                    m_BloodMoss += dropped.Amount;
                    dropped.Delete();
                }
                if (dropped is Ginseng)
                {
                    from.SendMessage(0x55C, String.Format("{0} Ginseng bylo vlozeno do herbare.", dropped.Amount));
                    m_Ginseng += dropped.Amount;
                    dropped.Delete();
                }
                if (dropped is Garlic)
                {
                    from.SendMessage(0x55C, String.Format("{0} Garlic bylo vlozeno do herbare.", dropped.Amount));
                    m_Garlic += dropped.Amount;
                    dropped.Delete();
                }
                if (dropped is MandrakeRoot)
                {
                    from.SendMessage(0x55C, String.Format("{0} Mandrake Root bylo vlozeno do herbare.", dropped.Amount));
                    m_MandrakeRoot += dropped.Amount;
                    dropped.Delete();
                }
                if (dropped is NoxCrystal)
                {
                    from.SendMessage(0x55C, String.Format("{0} Nox Crystal bylo vlozeno do herbare.", dropped.Amount));
                    m_NoxCrystal += dropped.Amount;
                    dropped.Delete();
                }
                if (dropped is PigIron)
                {
                    from.SendMessage(0x55C, String.Format("{0} Pig Iron bylo vlozeno do herbare.", dropped.Amount));
                    m_PigIron += dropped.Amount;
                    dropped.Delete();
                }
                if (dropped is BatWing)
                {
                    from.SendMessage(0x55C, String.Format("{0} Bat Wing bylo vlozeno do herbare.", dropped.Amount));
                    m_BatWing += dropped.Amount;
                    dropped.Delete();
                }
                if (dropped is DaemonBlood)
                {
                    from.SendMessage(0x55C, String.Format("{0} Daemon Blood bylo vlozeno do herbare.", dropped.Amount));
                    m_DaemonBlood += dropped.Amount;
                    dropped.Delete();
                }
                if (dropped is GraveDust)
                {
                    from.SendMessage(0x55C, String.Format("{0} Grave Dust bylo vlozeno do herbare.", dropped.Amount));
                    m_GraveDust += dropped.Amount;
                    dropped.Delete();
                }
                from.CloseGump(typeof(RegBookGump));
                // 				from.SendGump( new RegBookGump( from, this ));
                return true;
            }
            else if (dropped is Bag && !(dropped is PlantBag) )
            {

                List<Item> items = ((Container)dropped).Items;
                if (items.Count > 0)
                {
                    from.SendMessage(0x26, "Muzes vhodit pouze prazdny pytlik.");
                    return false;
                }

                m_EmptyBags++;
                dropped.Delete();
                from.CloseGump(typeof(RegBookGump));
                // 				from.SendGump( new RegBookGump( from, this ));
                return true;
            }
            else
            {
                from.SendMessage(0x26, "Tento predmet nemuzes do herbare vlozit.");
                return false;
            }
            return false;
        }

        #endregion

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);

            writer.Write((int)0); // version
            writer.Write((int)m_BlackPearl);
            writer.Write((int)m_BloodMoss);
            writer.Write((int)m_Garlic);
            writer.Write((int)m_Ginseng);
            writer.Write((int)m_SulfurousAsh);
            writer.Write((int)m_SpidersSilk);
            writer.Write((int)m_NightShade);
            writer.Write((int)m_MandrakeRoot);
            writer.Write((int)m_NoxCrystal);
            writer.Write((int)m_PigIron);
            writer.Write((int)m_BatWing);
            writer.Write((int)m_DaemonBlood);
            writer.Write((int)m_GraveDust);
            writer.Write((int)m_EmptyBags);
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);

            int version = reader.ReadInt(); // version
            switch (version)
            {
                case 0:
                    {
                        m_BlackPearl = reader.ReadInt();
                        m_BloodMoss = reader.ReadInt();
                        m_Garlic = reader.ReadInt();
                        m_Ginseng = reader.ReadInt();
                        m_SulfurousAsh = reader.ReadInt();
                        m_SpidersSilk = reader.ReadInt();
                        m_NightShade = reader.ReadInt();
                        m_MandrakeRoot = reader.ReadInt();
                        m_NoxCrystal = reader.ReadInt();
                        m_PigIron = reader.ReadInt();
                        m_BatWing = reader.ReadInt();
                        m_DaemonBlood = reader.ReadInt();
                        m_GraveDust = reader.ReadInt();
                        m_EmptyBags = reader.ReadInt();
                        break;
                    }
            }
            //          LootType = LootType.Blessed;
        }


    }
}
