using System;
using System.Collections;
using Server;
using Server.Items;
using Server.Mobiles;
using Server.Gumps;
using Server.Prompts;
using Server.Targeting;
using Server.Misc;
using Server.Multis;
using Server.ContextMenus;
using Server.Network;

namespace Server.Gumps
{
    public class RegBookGump : Server.Gumps.Gump
    {
        private Mobile m_Player;
        private RegBook m_RegBook;
        public RegBookGump(Mobile player, RegBook regbook)
            : base(10, 10)
        {
            m_Player = player;
            m_RegBook = regbook;
            this.Closable = true;
            this.Disposable = true;
            this.Dragable = true;
            this.Resizable = false;
            this.AddPage(0);
            this.AddImage(-2, 0, 500);
            this.AddItem(20, 10, 3976);
            this.AddItem(23, 40, 3962);
            this.AddItem(20, 60, 3963);
            this.AddItem(25, 90, 3972);
            this.AddItem(20, 110, 3973);
            this.AddItem(20, 135, 3974);
            this.AddItem(20, 160, 3980);
            this.AddItem(20, 185, 3981);
            this.AddLabel(70, 10, 900, String.Format("{0}", m_RegBook.m_NightShade));
            this.AddLabel(70, 35, 900, String.Format("{0}", m_RegBook.m_BlackPearl));
            this.AddLabel(70, 60, 900, String.Format("{0}", m_RegBook.m_BloodMoss));
            this.AddLabel(70, 85, 900, String.Format("{0}", m_RegBook.m_Garlic));
            this.AddLabel(70, 110, 900, String.Format("{0}", m_RegBook.m_Ginseng));
            this.AddLabel(70, 135, 900, String.Format("{0}", m_RegBook.m_MandrakeRoot));
            this.AddLabel(70, 160, 900, String.Format("{0}", m_RegBook.m_SulfurousAsh));
            this.AddLabel(70, 185, 900, String.Format("{0}", m_RegBook.m_SpidersSilk));
            this.AddItem(220, 10, 3982);
            this.AddItem(210, 40, 3983);
            this.AddItem(210, 60, 3965);
            this.AddItem(210, 90, 3960);
            this.AddItem(210, 110, 3978);
            this.AddLabel(250, 10, 900, String.Format("{0}", m_RegBook.m_NoxCrystal));
            this.AddLabel(250, 35, 900, String.Format("{0}", m_RegBook.m_GraveDust));
            this.AddLabel(250, 60, 900, String.Format("{0}", m_RegBook.m_DaemonBlood));
            this.AddLabel(250, 85, 900, String.Format("{0}", m_RegBook.m_BatWing));
            this.AddLabel(250, 110, 900, String.Format("{0}", m_RegBook.m_PigIron));
            this.AddLabel(225, 185, 66, @"Rychlych  50 [Necro]");
            this.AddLabel(225, 160, 32, @"Rychlych  50 [Mage]");
            this.AddItem(210, 140, 3702);
            this.AddLabel(250, 140, 900, String.Format("{0}", m_RegBook.m_EmptyBags));
            this.AddButton(180, 10, 2087, 2087, (int)Buttons.SelectNightShade, GumpButtonType.Reply, 0);
            this.AddButton(180, 35, 2087, 2087, (int)Buttons.SelectBlackPearl, GumpButtonType.Reply, 0);
            this.AddButton(180, 60, 2087, 2087, (int)Buttons.SelectBloodMoss, GumpButtonType.Reply, 0);
            this.AddButton(180, 85, 2087, 2087, (int)Buttons.SelectGarlic, GumpButtonType.Reply, 0);
            this.AddButton(180, 110, 2087, 2087, (int)Buttons.SelectGinsing, GumpButtonType.Reply, 0);
            this.AddButton(180, 135, 2087, 2087, (int)Buttons.SelectMandrake, GumpButtonType.Reply, 0);
            this.AddButton(180, 160, 2087, 2087, (int)Buttons.SelectSulfurousAsh, GumpButtonType.Reply, 0);
            this.AddButton(180, 185, 2087, 2087, (int)Buttons.SelectSpidersSilk, GumpButtonType.Reply, 0);
            this.AddButton(370, 10, 2087, 2087, (int)Buttons.SelectNoxCrystal, GumpButtonType.Reply, 0);
            this.AddButton(370, 35, 2087, 2087, (int)Buttons.SelectGraveDust, GumpButtonType.Reply, 0);
            this.AddButton(370, 60, 2087, 2087, (int)Buttons.SelectDaemonBlood, GumpButtonType.Reply, 0);
            this.AddButton(370, 85, 2087, 2087, (int)Buttons.SelectBatWings, GumpButtonType.Reply, 0);
            this.AddButton(370, 110, 2087, 2087, (int)Buttons.SelectPigIron, GumpButtonType.Reply, 0);
            this.AddButton(370, 140, 2087, 2087, (int)Buttons.SelectEmptyBag, GumpButtonType.Reply, 0);
            this.AddButton(370, 160, 2087, 2087, (int)Buttons.SelectQuick50Mage, GumpButtonType.Reply, 0);
            this.AddButton(370, 185, 2087, 2087, (int)Buttons.SelectQuick50Necro, GumpButtonType.Reply, 0);
        }

        public enum Buttons
        {
            SelectNightShade = 1,
            SelectBlackPearl,
            SelectBloodMoss,
            SelectGarlic,
            SelectGinsing,
            SelectMandrake,
            SelectSulfurousAsh,
            SelectSpidersSilk,
            SelectNoxCrystal,
            SelectGraveDust,
            SelectDaemonBlood,
            SelectBatWings,
            SelectPigIron,
            SelectEmptyBag,
            SelectQuick50Mage,
            SelectQuick50Necro,
        }

        public override void OnResponse(NetState state, RelayInfo info)
        {
            Mobile from = state.Mobile;
            
    			if (m_RegBook.Deleted)
    				return;
    		   else if ( !from.InRange( m_RegBook.GetWorldLocation(), 5 ) )
    			{
                from.SendMessage( "Jsi od {0} prilis daleko!", m_RegBook.Name );            
    			   if( from.HasGump( typeof(RegBookGump) ) )
    				  from.CloseGump( typeof(RegBookGump) );
    				return;
             }

            switch ((Buttons)info.ButtonID)
            {
                case Buttons.SelectNightShade:
                    {
                        from.SendMessage(0x55C, "Kolik Nightshade chces vybrat?");
                        from.Prompt = new RegRemovalPrompt(from, m_RegBook, (int)info.ButtonID);
                    } break;
                case Buttons.SelectBlackPearl:
                    {
                        from.SendMessage(0x55C, "Kolik Black Pearl chces vybrat?");
                        from.Prompt = new RegRemovalPrompt(from, m_RegBook, (int)info.ButtonID);
                    } break;
                case Buttons.SelectBloodMoss:
                    {
                        from.SendMessage(0x55C, "Kolik Bloodmoss chces vybrat?");
                        from.Prompt = new RegRemovalPrompt(from, m_RegBook, (int)info.ButtonID);
                    } break;
                case Buttons.SelectGarlic:
                    {
                        from.SendMessage(0x55C, "Kolik Garlic chces vybrat?");
                        from.Prompt = new RegRemovalPrompt(from, m_RegBook, (int)info.ButtonID);
                    } break;
                case Buttons.SelectGinsing:
                    {
                        from.SendMessage(0x55C, "Kolik Ginseng chces vybrat?");
                        from.Prompt = new RegRemovalPrompt(from, m_RegBook, (int)info.ButtonID);
                    } break;
                case Buttons.SelectMandrake:
                    {
                        from.SendMessage(0x55C, "Kolik Mandrake Root chces vybrat?");
                        from.Prompt = new RegRemovalPrompt(from, m_RegBook, (int)info.ButtonID);
                    } break;
                case Buttons.SelectSulfurousAsh:
                    {
                        from.SendMessage(0x55C, "Kolik Sulfurous Ash chces vybrat?");
                        from.Prompt = new RegRemovalPrompt(from, m_RegBook, (int)info.ButtonID);
                    } break;
                case Buttons.SelectSpidersSilk:
                    {
                        from.SendMessage(0x55C, "Kolik Spiders Silk chces vybrat?");
                        from.Prompt = new RegRemovalPrompt(from, m_RegBook, (int)info.ButtonID);
                    } break;
                case Buttons.SelectNoxCrystal:
                    {
                        from.SendMessage(0x55C, "Kolik Nox Crystal chces vybrat?");
                        from.Prompt = new RegRemovalPrompt(from, m_RegBook, (int)info.ButtonID);
                    } break;
                case Buttons.SelectGraveDust:
                    {
                        from.SendMessage(0x55C, "Kolik Grave Dust chces vybrat?");
                        from.Prompt = new RegRemovalPrompt(from, m_RegBook, (int)info.ButtonID);
                    } break;
                case Buttons.SelectDaemonBlood:
                    {
                        from.SendMessage(0x55C, "Kolik Daemon Blood chces vybrat?");
                        from.Prompt = new RegRemovalPrompt(from, m_RegBook, (int)info.ButtonID);
                    } break;
                case Buttons.SelectBatWings:
                    {
                        from.SendMessage(0x55C, "Kolik Bat Wing chces vybrat?");
                        from.Prompt = new RegRemovalPrompt(from, m_RegBook, (int)info.ButtonID);
                    } break;
                case Buttons.SelectPigIron:
                    {
                        from.SendMessage(0x55C, "Kolik Pig Iron chces vybrat?");
                        from.Prompt = new RegRemovalPrompt(from, m_RegBook, (int)info.ButtonID);
                    } break;
                case Buttons.SelectEmptyBag:
                    {
                        if (m_RegBook.m_EmptyBags <= 0)
                        {
                            from.SendMessage(0x26, "Nemas prazdne bagliky...");
                        }
                        else
                        {
                            m_RegBook.m_EmptyBags -= 1;
                            from.AddToBackpack(new Bag());
                            from.SendMessage(0x55C, "Vyjmul/a jsi prazdny baglik.");
                        }
                    } break;
                case Buttons.SelectQuick50Mage:
                    {
                        if (m_RegBook.m_EmptyBags <= 0)
                        {
                            from.SendMessage(0x26, "Nemas prazdne bagliky...");
                            from.CloseGump(typeof(RegBookGump));
                            from.SendGump(new RegBookGump(from, m_RegBook));

                        }
                        else if (
                            m_RegBook.m_BlackPearl <= 49 ||
                            m_RegBook.m_BloodMoss <= 49 ||
                            m_RegBook.m_Garlic <= 49 ||
                            m_RegBook.m_Ginseng <= 49 ||
                            m_RegBook.m_SulfurousAsh <= 49 ||
                            m_RegBook.m_SpidersSilk <= 49 ||
                            m_RegBook.m_NightShade <= 49 ||
                            m_RegBook.m_MandrakeRoot <= 49
                               )
                        {
                            from.SendMessage(0x26, "Nemas vsechny potrebne regy po 50ti.");
                            from.CloseGump(typeof(RegBookGump));
                            from.SendGump(new RegBookGump(from, m_RegBook));
                        }
                        else if (from.PlaceInBackpack(new BagOfReagents()))
                        {
                            m_RegBook.m_BlackPearl -= 50;
                            m_RegBook.m_BloodMoss -= 50;
                            m_RegBook.m_Garlic -= 50;
                            m_RegBook.m_Ginseng -= 50;
                            m_RegBook.m_SulfurousAsh -= 50;
                            m_RegBook.m_SpidersSilk -= 50;
                            m_RegBook.m_NightShade -= 50;
                            m_RegBook.m_MandrakeRoot -= 50;
                            m_RegBook.m_EmptyBags -= 1;
                            from.CloseGump(typeof(RegBookGump));
                            from.SendGump(new RegBookGump(from, m_RegBook));
                        }
                        else
                        {
                            from.SendMessage(0x26, "Nemas dostatek mista v batohu.");
                            from.CloseGump(typeof(RegBookGump));
                            from.SendGump(new RegBookGump(from, m_RegBook));
                        }

                    } break;
                case Buttons.SelectQuick50Necro:
                    {
                        if (m_RegBook.m_EmptyBags <= 0)
                        {
                            from.SendMessage(0x26, "Nemas prazdne bagliky...");
                            from.CloseGump(typeof(RegBookGump));
                            from.SendGump(new RegBookGump(from, m_RegBook));

                        }
                        else if (
                            m_RegBook.m_NoxCrystal <= 49 ||
                            m_RegBook.m_DaemonBlood <= 49 ||
                            m_RegBook.m_BatWing <= 49 ||
                            m_RegBook.m_PigIron <= 49 ||
                            m_RegBook.m_GraveDust <= 49)
                        {
                            from.SendMessage(0x26, "Nemas vsechny potrebne regy po 50ti.");
                            from.CloseGump(typeof(RegBookGump));
                            from.SendGump(new RegBookGump(from, m_RegBook));
                        }
                        else if (from.PlaceInBackpack(new BagOfNecroReagents()))
                        {
                            m_RegBook.m_NoxCrystal -= 50;
                            m_RegBook.m_DaemonBlood -= 50;
                            m_RegBook.m_BatWing -= 50;
                            m_RegBook.m_PigIron -= 50;
                            m_RegBook.m_GraveDust -= 50;
                            m_RegBook.m_EmptyBags -= 1;
                            from.CloseGump(typeof(RegBookGump));
                            from.SendGump(new RegBookGump(from, m_RegBook));
                        }
                        else
                        {
                            from.SendMessage(0x26, "Nemas dostatek mista v batohu.");
                            from.CloseGump(typeof(RegBookGump));
                            from.SendGump(new RegBookGump(from, m_RegBook));
                        }
                    } break;
                default:
                    {
                        //Nothing
                    } break;

            }
        }

        public class RegRemovalPrompt : Prompt
        {
            private Mobile m_Player;
            private RegBook m_RegBook;
            private int m_Buttons;
            public RegRemovalPrompt(Mobile player, RegBook regbook, int button)
            {
                m_Player = player;
                m_RegBook = regbook;
                m_Buttons = button;
            }

            public override void OnResponse(Mobile from, string text)
            {
                // Magery Reg Prompt Info
                #region NightShade Selection
                if (m_Buttons == (int)Buttons.SelectNightShade)
                {
                    try
                    {
                        int amount = Convert.ToInt32(text);
                        if (amount > 0 && amount < 60001)
                        {
                            if ((m_RegBook.m_NightShade - amount) < 0)
                            {
                                from.SendMessage(0x26, "Nemas tolik Nightshade v herbari.");
                            }
                            else
                            {
                                if (from.PlaceInBackpack(new Nightshade(amount)))
                                {
                                    m_RegBook.m_NightShade -= amount;
                                    from.CloseGump(typeof(RegBookGump));
                                    from.SendGump(new RegBookGump(m_Player, m_RegBook));
                                    from.SendMessage(0x55C, String.Format(" Z herbare bylo vyjmuto {0} Nightshade.", amount));
                                }
                                else
                                {
                                    from.SendLocalizedMessage(1046260); // You need to clear some space in your inventory to continue with the quest.  Come back here when you have more space in your inventory.
                                    from.CloseGump(typeof(RegBookGump));
                                    from.SendGump(new RegBookGump(m_Player, m_RegBook));
                                }

                            }
                        }
                        else
                        {
                            from.SendMessage(0x26, "vyber 1 - 60 000 reagentu");
                            from.CloseGump(typeof(RegBookGump));
                            from.SendGump(new RegBookGump(m_Player, m_RegBook));
                        }
                    }
                    catch
                    {
                        from.SendMessage(0x26, "Neplatny pozadavek");
                        from.CloseGump(typeof(RegBookGump));
                        from.SendGump(new RegBookGump(m_Player, m_RegBook));
                    }
                }
                #endregion
                #region BlackPearl Selection
                if (m_Buttons == (int)Buttons.SelectBlackPearl)
                {
                    try
                    {
                        int amount = Convert.ToInt32(text);
                        if (amount > 0 && amount < 60001)
                        {
                            if ((m_RegBook.m_BlackPearl - amount) < 0)
                            {
                                from.SendMessage(0x26, "Nemas tolik Black Pearl v herbari.");
                            }
                            else
                            {
                                if (from.PlaceInBackpack(new BlackPearl(amount)))
                                {
                                    m_RegBook.m_BlackPearl -= amount;
                                    from.CloseGump(typeof(RegBookGump));
                                    from.SendGump(new RegBookGump(m_Player, m_RegBook));
                                    from.SendMessage(0x55C, String.Format(" Z herbare bylo vyjmuto {0} Black Pearl.", amount));
                                }
                                else
                                {
                                    from.SendLocalizedMessage(1046260); // You need to clear some space in your inventory to continue with the quest.  Come back here when you have more space in your inventory.
                                    from.CloseGump(typeof(RegBookGump));
                                    from.SendGump(new RegBookGump(m_Player, m_RegBook));
                                }

                            }
                        }
                        else
                        {
                            from.SendMessage(0x26, "vyber 1 - 60 000 reagentu");
                            from.CloseGump(typeof(RegBookGump));
                            from.SendGump(new RegBookGump(m_Player, m_RegBook));
                        }
                    }
                    catch
                    {
                        from.SendMessage(0x26, "Neplatny pozadavek");
                        from.CloseGump(typeof(RegBookGump));
                        from.SendGump(new RegBookGump(m_Player, m_RegBook));
                    }
                }
                #endregion
                #region Bloodmoss Selection
                if (m_Buttons == (int)Buttons.SelectBloodMoss)
                {
                    try
                    {
                        int amount = Convert.ToInt32(text);
                        if (amount > 0 && amount < 60001)
                        {
                            if ((m_RegBook.m_BloodMoss - amount) < 0)
                            {
                                from.SendMessage(0x26, "Nemas tolik Bloodmoss v herbari.");
                            }
                            else
                            {
                                if (from.PlaceInBackpack(new Bloodmoss(amount)))
                                {
                                    m_RegBook.m_BloodMoss -= amount;
                                    from.CloseGump(typeof(RegBookGump));
                                    from.SendGump(new RegBookGump(m_Player, m_RegBook));
                                    from.SendMessage(0x55C, String.Format(" Z herbare bylo vyjmuto {0} Bloodmoss.", amount));
                                }
                                else
                                {
                                    from.SendLocalizedMessage(1046260); // You need to clear some space in your inventory to continue with the quest.  Come back here when you have more space in your inventory.
                                    from.CloseGump(typeof(RegBookGump));
                                    from.SendGump(new RegBookGump(m_Player, m_RegBook));
                                }

                            }
                        }
                        else
                        {
                            from.SendMessage(0x26, "vyber 1 - 60 000 reagentu");
                            from.CloseGump(typeof(RegBookGump));
                            from.SendGump(new RegBookGump(m_Player, m_RegBook));
                        }
                    }
                    catch
                    {
                        from.SendMessage(0x26, "Neplatny pozadavek");
                        from.CloseGump(typeof(RegBookGump));
                        from.SendGump(new RegBookGump(m_Player, m_RegBook));
                    }
                }
                #endregion
                #region Garlic Selection
                if (m_Buttons == (int)Buttons.SelectGarlic)
                {
                    try
                    {
                        int amount = Convert.ToInt32(text);
                        if (amount > 0 && amount < 60001)
                        {
                            if ((m_RegBook.m_Garlic - amount) < 0)
                            {
                                from.SendMessage(0x26, "Nemas tolik Garlic v herbari.");
                            }
                            else
                            {
                                if (from.PlaceInBackpack(new Garlic(amount)))
                                {
                                    m_RegBook.m_Garlic -= amount;
                                    from.CloseGump(typeof(RegBookGump));
                                    from.SendGump(new RegBookGump(m_Player, m_RegBook));
                                    from.SendMessage(0x55C, String.Format(" Z herbare bylo vyjmuto {0} Garlic.", amount));
                                }
                                else
                                {
                                    from.SendLocalizedMessage(1046260); // You need to clear some space in your inventory to continue with the quest.  Come back here when you have more space in your inventory.
                                    from.CloseGump(typeof(RegBookGump));
                                    from.SendGump(new RegBookGump(m_Player, m_RegBook));
                                }

                            }
                        }
                        else
                        {
                            from.SendMessage(0x26, "vyber 1 - 60 000 reagentu");
                            from.CloseGump(typeof(RegBookGump));
                            from.SendGump(new RegBookGump(m_Player, m_RegBook));
                        }
                    }
                    catch
                    {
                        from.SendMessage(0x26, "Neplatny pozadavek");
                        from.CloseGump(typeof(RegBookGump));
                        from.SendGump(new RegBookGump(m_Player, m_RegBook));
                    }
                }
                #endregion
                #region Ginseng Selection
                if (m_Buttons == (int)Buttons.SelectGinsing)
                {
                    try
                    {
                        int amount = Convert.ToInt32(text);
                        if (amount > 0 && amount < 60001)
                        {
                            if ((m_RegBook.m_Ginseng - amount) < 0)
                            {
                                from.SendMessage(0x26, "Nemas tolik Ginseng v herbari.");
                            }
                            else
                            {
                                if (from.PlaceInBackpack(new Ginseng(amount)))
                                {
                                    m_RegBook.m_Ginseng -= amount;
                                    from.CloseGump(typeof(RegBookGump));
                                    from.SendGump(new RegBookGump(m_Player, m_RegBook));
                                    from.SendMessage(0x55C, String.Format(" Z herbare bylo vyjmuto {0} Ginseng.", amount));
                                }
                                else
                                {
                                    from.SendLocalizedMessage(1046260); // You need to clear some space in your inventory to continue with the quest.  Come back here when you have more space in your inventory.
                                    from.CloseGump(typeof(RegBookGump));
                                    from.SendGump(new RegBookGump(m_Player, m_RegBook));
                                }

                            }
                        }
                        else
                        {
                            from.SendMessage(0x26, "vyber 1 - 60 000 reagentu");
                            from.CloseGump(typeof(RegBookGump));
                            from.SendGump(new RegBookGump(m_Player, m_RegBook));
                        }
                    }
                    catch
                    {
                        from.SendMessage(0x26, "Neplatny pozadavek");
                        from.CloseGump(typeof(RegBookGump));
                        from.SendGump(new RegBookGump(m_Player, m_RegBook));
                    }
                }
                #endregion
                #region Mandrake Root Selection
                if (m_Buttons == (int)Buttons.SelectMandrake)
                {
                    try
                    {
                        int amount = Convert.ToInt32(text);
                        if (amount > 0 && amount < 60001)
                        {
                            if ((m_RegBook.m_MandrakeRoot - amount) < 0)
                            {
                                from.SendMessage(0x26, "Nemas tolik Mandrake Root v herbari.");
                            }
                            else
                            {
                                if (from.PlaceInBackpack(new MandrakeRoot(amount)))
                                {
                                    m_RegBook.m_MandrakeRoot -= amount;
                                    from.CloseGump(typeof(RegBookGump));
                                    from.SendGump(new RegBookGump(m_Player, m_RegBook));
                                    from.SendMessage(0x55C, String.Format(" Z herbare bylo vyjmuto {0} Mandrake Root.", amount));
                                }
                                else
                                {
                                    from.SendLocalizedMessage(1046260); // You need to clear some space in your inventory to continue with the quest.  Come back here when you have more space in your inventory.
                                    from.CloseGump(typeof(RegBookGump));
                                    from.SendGump(new RegBookGump(m_Player, m_RegBook));
                                }

                            }
                        }
                        else
                        {
                            from.SendMessage(0x26, "vyber 1 - 60 000 reagentu");
                            from.CloseGump(typeof(RegBookGump));
                            from.SendGump(new RegBookGump(m_Player, m_RegBook));
                        }
                    }
                    catch
                    {
                        from.SendMessage(0x26, "Neplatny pozadavek");
                        from.CloseGump(typeof(RegBookGump));
                        from.SendGump(new RegBookGump(m_Player, m_RegBook));
                    }
                }
                #endregion
                #region Sulfurous Ash Selection
                if (m_Buttons == (int)Buttons.SelectSulfurousAsh)
                {
                    try
                    {
                        int amount = Convert.ToInt32(text);
                        if (amount > 0 && amount < 60001)
                        {
                            if ((m_RegBook.m_SulfurousAsh - amount) < 0)
                            {
                                from.SendMessage(0x26, "Nemas tolik Sulfurous Ash v herbari.");
                            }
                            else
                            {
                                if (from.PlaceInBackpack(new SulfurousAsh(amount)))
                                {
                                    m_RegBook.m_SulfurousAsh -= amount;
                                    from.CloseGump(typeof(RegBookGump));
                                    from.SendGump(new RegBookGump(m_Player, m_RegBook));
                                    from.SendMessage(0x55C, String.Format(" Z herbare bylo vyjmuto {0} Sulfurous Ash.", amount));
                                }
                                else
                                {
                                    from.SendLocalizedMessage(1046260); // You need to clear some space in your inventory to continue with the quest.  Come back here when you have more space in your inventory.
                                    from.CloseGump(typeof(RegBookGump));
                                    from.SendGump(new RegBookGump(m_Player, m_RegBook));
                                }

                            }
                        }
                        else
                        {
                            from.SendMessage(0x26, "vyber 1 - 60 000 reagentu");
                            from.CloseGump(typeof(RegBookGump));
                            from.SendGump(new RegBookGump(m_Player, m_RegBook));
                        }
                    }
                    catch
                    {
                        from.SendMessage(0x26, "Neplatny pozadavek");
                        from.CloseGump(typeof(RegBookGump));
                        from.SendGump(new RegBookGump(m_Player, m_RegBook));
                    }
                }
                #endregion
                #region Spider's Silk Selection
                if (m_Buttons == (int)Buttons.SelectSpidersSilk)
                {
                    try
                    {
                        int amount = Convert.ToInt32(text);
                        if (amount > 0 && amount < 60001)
                        {
                            if ((m_RegBook.m_SpidersSilk - amount) < 0)
                            {
                                from.SendMessage(0x26, "Nemas tolik Spider's Silk v herbari.");
                            }
                            else
                            {
                                if (from.PlaceInBackpack(new SpidersSilk(amount)))
                                {
                                    m_RegBook.m_SpidersSilk -= amount;
                                    from.CloseGump(typeof(RegBookGump));
                                    from.SendGump(new RegBookGump(m_Player, m_RegBook));
                                    from.SendMessage(0x55C, String.Format(" Z herbare bylo vyjmuto {0} SpidersSilk.", amount));
                                }
                                else
                                {
                                    from.SendLocalizedMessage(1046260); // You need to clear some space in your inventory to continue with the quest.  Come back here when you have more space in your inventory.
                                    from.CloseGump(typeof(RegBookGump));
                                    from.SendGump(new RegBookGump(m_Player, m_RegBook));
                                }

                            }
                        }
                        else
                        {
                            from.SendMessage(0x26, "vyber 1 - 60 000 reagentu");
                            from.CloseGump(typeof(RegBookGump));
                            from.SendGump(new RegBookGump(m_Player, m_RegBook));
                        }
                    }
                    catch
                    {
                        from.SendMessage(0x26, "Neplatny pozadavek");
                        from.CloseGump(typeof(RegBookGump));
                        from.SendGump(new RegBookGump(m_Player, m_RegBook));
                    }
                }
                #endregion

                // Necromancy Reg Prompt Info
                #region Nox Crystal Selection
                if (m_Buttons == (int)Buttons.SelectNoxCrystal)
                {
                    try
                    {
                        int amount = Convert.ToInt32(text);
                        if (amount > 0 && amount < 60001)
                        {
                            if ((m_RegBook.m_NoxCrystal - amount) < 0)
                            {
                                from.SendMessage(0x26, "Nemas tolik Nox Crystal v herbari.");
                            }
                            else
                            {
                                if (from.PlaceInBackpack(new NoxCrystal(amount)))
                                {
                                    m_RegBook.m_NoxCrystal -= amount;
                                    from.CloseGump(typeof(RegBookGump));
                                    from.SendGump(new RegBookGump(m_Player, m_RegBook));
                                    from.SendMessage(0x55C, String.Format(" Z herbare bylo vyjmuto {0} Nox Crystal.", amount));
                                }
                                else
                                {
                                    from.SendLocalizedMessage(1046260); // You need to clear some space in your inventory to continue with the quest.  Come back here when you have more space in your inventory.
                                    from.CloseGump(typeof(RegBookGump));
                                    from.SendGump(new RegBookGump(m_Player, m_RegBook));
                                }

                            }
                        }
                        else
                        {
                            from.SendMessage(0x26, "vyber 1 - 60 000 reagentu");
                            from.CloseGump(typeof(RegBookGump));
                            from.SendGump(new RegBookGump(m_Player, m_RegBook));
                        }
                    }
                    catch
                    {
                        from.SendMessage(0x26, "Neplatny pozadavek");
                        from.CloseGump(typeof(RegBookGump));
                        from.SendGump(new RegBookGump(m_Player, m_RegBook));
                    }
                }
                #endregion
                #region Grave Dust Selection
                if (m_Buttons == (int)Buttons.SelectGraveDust)
                {
                    try
                    {
                        int amount = Convert.ToInt32(text);
                        if (amount > 0 && amount < 60001)
                        {
                            if ((m_RegBook.m_GraveDust - amount) < 0)
                            {
                                from.SendMessage(0x26, "Nemas tolik Grave Dust v herbari.");
                            }
                            else
                            {
                                if (from.PlaceInBackpack(new GraveDust(amount)))
                                {
                                    m_RegBook.m_GraveDust -= amount;
                                    from.CloseGump(typeof(RegBookGump));
                                    from.SendGump(new RegBookGump(m_Player, m_RegBook));
                                    from.SendMessage(0x55C, String.Format(" Z herbare bylo vyjmuto {0} Grave Dust.", amount));
                                }
                                else
                                {
                                    from.SendLocalizedMessage(1046260); // You need to clear some space in your inventory to continue with the quest.  Come back here when you have more space in your inventory.
                                    from.CloseGump(typeof(RegBookGump));
                                    from.SendGump(new RegBookGump(m_Player, m_RegBook));
                                }

                            }
                        }
                        else
                        {
                            from.SendMessage(0x26, "vyber 1 - 60 000 reagentu");
                            from.CloseGump(typeof(RegBookGump));
                            from.SendGump(new RegBookGump(m_Player, m_RegBook));
                        }
                    }
                    catch
                    {
                        from.SendMessage(0x26, "Neplatny pozadavek");
                        from.CloseGump(typeof(RegBookGump));
                        from.SendGump(new RegBookGump(m_Player, m_RegBook));
                    }
                }
                #endregion
                #region DaemonBlood Selection
                if (m_Buttons == (int)Buttons.SelectDaemonBlood)
                {
                    try
                    {
                        int amount = Convert.ToInt32(text);
                        if (amount > 0 && amount < 60001)
                        {
                            if ((m_RegBook.m_DaemonBlood - amount) < 0)
                            {
                                from.SendMessage(0x26, "Nemas tolik Daemon Blood v herbari.");
                            }
                            else
                            {
                                if (from.PlaceInBackpack(new DaemonBlood(amount)))
                                {
                                    m_RegBook.m_DaemonBlood -= amount;
                                    from.CloseGump(typeof(RegBookGump));
                                    from.SendGump(new RegBookGump(m_Player, m_RegBook));
                                    from.SendMessage(0x55C, String.Format(" Z herbare bylo vyjmuto {0} Daemon Blood.", amount));
                                }
                                else
                                {
                                    from.SendLocalizedMessage(1046260); // You need to clear some space in your inventory to continue with the quest.  Come back here when you have more space in your inventory.
                                    from.CloseGump(typeof(RegBookGump));
                                    from.SendGump(new RegBookGump(m_Player, m_RegBook));
                                }

                            }
                        }
                        else
                        {
                            from.SendMessage(0x26, "vyber 1 - 60 000 reagentu");
                            from.CloseGump(typeof(RegBookGump));
                            from.SendGump(new RegBookGump(m_Player, m_RegBook));
                        }
                    }
                    catch
                    {
                        from.SendMessage(0x26, "Neplatny pozadavek");
                        from.CloseGump(typeof(RegBookGump));
                        from.SendGump(new RegBookGump(m_Player, m_RegBook));
                    }
                }
                #endregion
                #region Bat Wing Selection
                if (m_Buttons == (int)Buttons.SelectBatWings)
                {
                    try
                    {
                        int amount = Convert.ToInt32(text);
                        if (amount > 0 && amount < 60001)
                        {
                            if ((m_RegBook.m_BatWing - amount) < 0)
                            {
                                from.SendMessage(0x26, "Nemas tolik Bat Wing v herbari.");
                            }
                            else
                            {
                                if (from.PlaceInBackpack(new BatWing(amount)))
                                {
                                    m_RegBook.m_BatWing -= amount;
                                    from.CloseGump(typeof(RegBookGump));
                                    from.SendGump(new RegBookGump(m_Player, m_RegBook));
                                    from.SendMessage(0x55C, String.Format(" Z herbare bylo vyjmuto {0} Bat Wing.", amount));
                                }
                                else
                                {
                                    from.SendLocalizedMessage(1046260); // You need to clear some space in your inventory to continue with the quest.  Come back here when you have more space in your inventory.
                                    from.CloseGump(typeof(RegBookGump));
                                    from.SendGump(new RegBookGump(m_Player, m_RegBook));
                                }

                            }
                        }
                        else
                        {
                            from.SendMessage(0x26, "vyber 1 - 60 000 reagentu");
                            from.CloseGump(typeof(RegBookGump));
                            from.SendGump(new RegBookGump(m_Player, m_RegBook));
                        }
                    }
                    catch
                    {
                        from.SendMessage(0x26, "Neplatny pozadavek");
                        from.CloseGump(typeof(RegBookGump));
                        from.SendGump(new RegBookGump(m_Player, m_RegBook));
                    }
                }
                #endregion
                #region Pig Iron Selection
                if (m_Buttons == (int)Buttons.SelectPigIron)
                {
                    try
                    {
                        int amount = Convert.ToInt32(text);
                        if (amount > 0 && amount < 60001)
                        {
                            if ((m_RegBook.m_PigIron - amount) < 0)
                            {
                                from.SendMessage(0x26, "Nemas tolik Pig Iron v herbari.");
                            }
                            else
                            {
                                if (from.PlaceInBackpack(new PigIron(amount)))
                                {
                                    m_RegBook.m_PigIron -= amount;
                                    from.CloseGump(typeof(RegBookGump));
                                    from.SendGump(new RegBookGump(m_Player, m_RegBook));
                                    from.SendMessage(0x55C, String.Format(" Z herbare bylo vyjmuto {0} Pig Iron.", amount));
                                }
                                else
                                {
                                    from.SendLocalizedMessage(1046260); // You need to clear some space in your inventory to continue with the quest.  Come back here when you have more space in your inventory.
                                    from.CloseGump(typeof(RegBookGump));
                                    from.SendGump(new RegBookGump(m_Player, m_RegBook));
                                }

                            }
                        }
                        else
                        {
                            from.SendMessage(0x26, "vyber 1 - 60 000 reagentu");
                            from.CloseGump(typeof(RegBookGump));
                            from.SendGump(new RegBookGump(m_Player, m_RegBook));
                        }
                    }
                    catch
                    {
                        from.SendMessage(0x26, "Neplatny pozadavek");
                        from.CloseGump(typeof(RegBookGump));
                        from.SendGump(new RegBookGump(m_Player, m_RegBook));
                    }
                }
                #endregion

            }
        }
    }
}