using System;
using System.Collections;
using System.Collections.Generic;
using Server;
using Server.Engines.Craft;

namespace Server.Items
{
	public class ScrappersCompendium : Spellbook
	{
		public override int LabelNumber{ get{ return 1072940; } } // scrappers compendium
	
		[Constructable]
		public ScrappersCompendium() : base()
		{
			Hue = 0x494;
			
			Attributes.SpellDamage = 25;
			Attributes.LowerManaCost = 20;
			Attributes.LowerRegCost = 25;
			Attributes.RegenMana = 5;
			Attributes.BonusMana = 20;
			Attributes.CastSpeed = 1;
			Attributes.CastRecovery = 2;
		}

		public ScrappersCompendium( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			
			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			
			int version = reader.ReadInt();
		}
	}
}

