//Created by Twistedfeather aka Magpie
using System;
using System.Collections;
using Server;
using Server.Prompts;
using Server.Mobiles;
using Server.ContextMenus;
using Server.Gumps;
using Server.Items;
using Server.Network;
using Server.Targeting;
using Server.Multis;
using Server.Regions;
using Server.Engines.Craft;
using Server.Engines.BulkOrders;


namespace Server.Items
{
	public class BODExchangeBox : BaseContainer
	{
		public int m_STailAmount;
		public int m_LTailAmount;
		public int m_SSmithAmount;
		public int m_LSmithAmount;
		public int m_SCarpAmount;
		public int m_LCarpAmount;
		public int m_SFletchAmount;
		public int m_LFletchAmount;
		
		public override bool DisplaysContent{ get{ return false; } }
      public override bool DisplayWeight { get { return false; } }
		
		[CommandProperty(AccessLevel.GameMaster)]
		public int SmallTailorBODAmount { get { return m_STailAmount; } set { m_STailAmount = value; InvalidateProperties(); } }
		
		[CommandProperty(AccessLevel.GameMaster)]
		public int LargeTailorBODAmount { get { return m_LTailAmount; } set { m_LTailAmount = value; InvalidateProperties(); } }

		[CommandProperty(AccessLevel.GameMaster)]
		public int SmallSmithBODAmount { get { return m_SSmithAmount; } set { m_SSmithAmount = value; InvalidateProperties(); } }

		[CommandProperty(AccessLevel.GameMaster)]
		public int LargeSmithBODAmount { get { return m_LSmithAmount; } set { m_LSmithAmount = value; InvalidateProperties(); } }

		[CommandProperty(AccessLevel.GameMaster)]
		public int SmallCarpBODAmount { get { return m_SCarpAmount; } set { m_SCarpAmount = value; InvalidateProperties(); } }

		[CommandProperty(AccessLevel.GameMaster)]
		public int LargeCarpBODAmount { get { return m_LCarpAmount; } set { m_LCarpAmount = value; InvalidateProperties(); } }
		
		[CommandProperty(AccessLevel.GameMaster)]
		public int SmallFletchBODAmount { get { return m_SFletchAmount; } set { m_SFletchAmount = value; InvalidateProperties(); } }

		[CommandProperty(AccessLevel.GameMaster)]
		public int LargeFletchBODAmount { get { return m_LFletchAmount; } set { m_LFletchAmount = value; InvalidateProperties(); } }

		private Mobile m_Owner;

		[Constructable]
		public BODExchangeBox()
			: base(0xe80)
		{
			Weight = 1.0;
			Hue = 1328;
			Name = "BOD Exchange Box";
			LootType = LootType.Blessed;
		}

		public override bool OnDragDrop(Mobile from, Item dropped)
		{
			if (dropped is SmallTailorBOD)
			{
				Item a = dropped;
				if (m_STailAmount >= 250)
				{
					from.SendMessage("Your box cannot hold any more Small Tailor BODs, trade some in for new ones!");
				}
				else
				{
					from.SendMessage("You've added a Small Tailor BOD to the box.");
					a.Delete();
					m_STailAmount += 1;
				}
				return false;
			}
			else if (dropped is LargeTailorBOD)
			{
				Item b = dropped;
				if (m_LTailAmount >= 250)
				{
					from.SendMessage("Your book cannot hold any more Large Tailor BODs, trade some in for new ones!");
				}
				else
				{
					from.SendMessage("You've added a Large Tailor BOD to the box.");
					b.Delete();
					m_LTailAmount += 1;
				}
				return false;
			}
			else if (dropped is SmallSmithBOD)
			{
				Item c = dropped;
				if (m_SSmithAmount >= 250)
				{
					from.SendMessage("Your box cannot hold any more Small Smith BODs, trade some in for new ones!");
				}
				else
				{
					from.SendMessage("You've added a Small Smith BOD to the box.");
					c.Delete();
					m_SSmithAmount += 1;
				}
				return false;
			}
			else if (dropped is LargeSmithBOD)
			{
				Item d = dropped;
				if (m_LSmithAmount >= 250)
				{
					from.SendMessage("Your box cannot hold any more Large Smith BODs, trade some in for new ones!");
				}
				else
				{
					from.SendMessage("You've added a Large Smith BOD to the box.");
					d.Delete();
					m_LSmithAmount += 1;
				}
				return false;
			}
			else if (dropped is SmallCarpenterBOD)
			{
				Item c = dropped;
				if (m_SCarpAmount >= 250)
				{
					from.SendMessage("Your box cannot hold any more Small carpenter BODs, trade some in for new ones!");
				}
				else
				{
					from.SendMessage("You've added a Small carpenter BOD to the box.");
					c.Delete();
					m_SCarpAmount += 1;
				}
				return false;
			}
			else if (dropped is LargeCarpenterBOD)
			{
				Item d = dropped;
				if (m_LCarpAmount >= 250)
				{
					from.SendMessage("Your box cannot hold any more Large carpenter BODs, trade some in for new ones!");
				}
				else
				{
					from.SendMessage("You've added a Large carpenter BOD to the box.");
					d.Delete();
					m_LCarpAmount += 1;
				}
				return false;
			}
			else if (dropped is SmallFletcherBOD)
			{
				Item c = dropped;
				if (m_SFletchAmount >= 250)
				{
					from.SendMessage("Your box cannot hold any more Small Fletcher BODs, trade some in for new ones!");
				}
				else
				{
					from.SendMessage("You've added a Small Fletcher BOD to the box.");
					c.Delete();
					m_SFletchAmount += 1;
				}
				return false;
			}
			else if (dropped is LargeFletcherBOD)
			{
				Item d = dropped;
				if (m_LFletchAmount >= 250)
				{
					from.SendMessage("Your box cannot hold any more Large Fletcher BODs, trade some in for new ones!");
				}
				else
				{
					from.SendMessage("You've added a Large Fletcher BOD to the box.");
					d.Delete();
					m_LFletchAmount += 1;
				}
				return false;
			}
			else
			{
				from.SendMessage("This box is only for exchanging BODs!");
				return false;
			}

		}
		public override void OnDoubleClick(Mobile from)
		{
			// set owner if not already set -- this is only done the first time.
			if (m_Owner == null)
			{
				m_Owner = from;
				this.Name = m_Owner.Name.ToString() + "'s BOD Exchange Box";
				from.SendMessage("This BOD Exchange Box has been assigned to you.");
			}
			if (m_Owner != from)
			{
				from.SendMessage("This is not yours to use.");
				return;
			}
			else
			{
				if (!IsChildOf(from.Backpack))
				{
					from.SendLocalizedMessage(1042001); // That must be in your pack for you to use it.
					return;
				}
				else
				{
					from.SendGump(new BODExchangeBoxGump((PlayerMobile)from, this));
				}
			}
		}
		public BODExchangeBox(Serial serial)
			: base(serial)
		{
		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);
			writer.Write( (int) 0 ); // version
			writer.Write((int)m_STailAmount);
			writer.Write((int)m_LTailAmount);
			writer.Write((int)m_SSmithAmount);
			writer.Write((int)m_LSmithAmount);
			writer.Write((int)m_SCarpAmount);
			writer.Write((int)m_LCarpAmount);
			writer.Write((int)m_SFletchAmount);
			writer.Write((int)m_LFletchAmount);
			writer.Write((Mobile)m_Owner);
		}


		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);
			int version = reader.ReadInt();
			m_STailAmount = reader.ReadInt();
			m_LTailAmount = reader.ReadInt();
			m_SSmithAmount = reader.ReadInt();
			m_LSmithAmount = reader.ReadInt();
			m_SCarpAmount = reader.ReadInt();
			m_LCarpAmount = reader.ReadInt();
			m_SFletchAmount = reader.ReadInt();
			m_LFletchAmount = reader.ReadInt();
			m_Owner = reader.ReadMobile();

		}
	}
}
namespace Server.Items
{
	public class BODExchangeBoxGump : Gump
	{
		private PlayerMobile m_From;
		private BODExchangeBox m_Box;

		public BODExchangeBoxGump(PlayerMobile from, BODExchangeBox box)
			: base(25, 25)
		{
			m_From = from;
			m_Box = box;
			m_From.CloseGump(typeof(BODExchangeBoxGump));
			
        this.Closable=true;
        this.Disposable=true;
        this.Dragable=true;
        this.Resizable=false;
        this.AddPage(0);
        this.AddBackground(24, 18, 279, 367, 5054);
        this.AddAlphaRegion(24, 18, 279, 367);
        this.AddLabel(100, 25, 1194, @"BOD  Exchange  Box");
        this.AddButton(65, 50, 4005, 4007, 1, GumpButtonType.Reply, 0);
        this.AddLabel(110, 50, 471, @"Small Tailor BOD:  ");
        this.AddLabel(250, 50, 1152, box.SmallTailorBODAmount.ToString());
        this.AddButton(65, 75, 4005, 4007, 2, GumpButtonType.Reply, 0);
        this.AddLabel(110, 75, 471, @"Large Tailor BOD: ");
        this.AddLabel(250, 75, 1152, box.LargeTailorBODAmount.ToString());
        this.AddButton(65, 100, 4005, 4007, 3, GumpButtonType.Reply, 0);
        this.AddLabel(110, 100, 930, @"Small Smith BOD: ");
        this.AddLabel(250, 100, 1152, box.SmallSmithBODAmount.ToString());
        this.AddButton(65, 125, 4005, 4007, 4, GumpButtonType.Reply, 0);
        this.AddLabel(110, 125, 930, @"Large Smith BOD: ");
        this.AddLabel(250, 125, 1152, box.LargeSmithBODAmount.ToString());
        this.AddLabel(73, 257, 1194, @"Kazda vymena BODu stoji");
        this.AddLabel(74, 278, 1194, @"2 body z typu ktery chces");
        this.AddLabel(59, 306, 32, @"Pokud jednou BOD do boxu vhodis");
        this.AddLabel(74, 325, 32, @"nelze jiz vzit stejny zpet!");
        this.AddButton(227, 349, 2071, 2073, 0, GumpButtonType.Reply, 0); //cancel
        this.AddButton(65, 152, 4005, 4007, 5, GumpButtonType.Reply, 0);
        this.AddLabel(110, 152, 242, @"Small Carpenter BOD:  ");
        this.AddLabel(250, 152, 1152, box.SmallCarpBODAmount.ToString());
        this.AddButton(65, 177, 4005, 4007, 6, GumpButtonType.Reply, 0);
        this.AddLabel(110, 177, 242, @"Large Carpenter BOD: ");
        this.AddLabel(250, 177, 1152, box.LargeCarpBODAmount.ToString());
        this.AddButton(65, 202, 4005, 4007, 7, GumpButtonType.Reply, 0);
        this.AddLabel(110, 202, 4, @"Small Fletcher BOD: ");
        this.AddLabel(250, 202, 1152, box.SmallFletchBODAmount.ToString());
        this.AddButton(65, 227, 4005, 4007, 8, GumpButtonType.Reply, 0);
        this.AddLabel(110, 227, 4, @"Large Fletcher BOD: ");
        this.AddLabel(250, 227, 1152, box.LargeFletchBODAmount.ToString());
		}

		public override void OnResponse(NetState sender, RelayInfo info)
		{
			if (m_Box.Deleted)
				return;

			if (info.ButtonID == 1)
			{
				if (m_Box.SmallTailorBODAmount >= 2)
				{
					m_Box.SmallTailorBODAmount -= 2;
					m_From.AddToBackpack(new SmallTailorBOD());
					m_From.SendGump(new BODExchangeBoxGump(m_From, m_Box));
				}
				else
				{
					m_From.SendMessage("You do not have enough Small Tailor BODs!");
					m_From.SendGump(new BODExchangeBoxGump(m_From, m_Box));
				}
			}
			if (info.ButtonID == 2)
			{
				if (m_Box.LargeTailorBODAmount >= 2)
				{
					m_Box.LargeTailorBODAmount -= 2;
					m_From.AddToBackpack(new LargeTailorBOD());
					m_From.SendGump(new BODExchangeBoxGump(m_From, m_Box));
				}
				else
				{
					m_From.SendMessage("You do not have enough Large Tailor BODs!");
					m_From.SendGump(new BODExchangeBoxGump(m_From, m_Box));
				}
			}

			if (info.ButtonID == 3)
			{
				if (m_Box.SmallSmithBODAmount >= 2)
				{
					m_Box.SmallSmithBODAmount -= 2;
					m_From.AddToBackpack(new SmallSmithBOD());
					m_From.SendGump(new BODExchangeBoxGump(m_From, m_Box));
				}
				else
				{
					m_From.SendMessage("You do not have enough Small Smith BODs!");
					m_From.SendGump(new BODExchangeBoxGump(m_From, m_Box));
				}
			}
			if (info.ButtonID == 4)
			{
				if (m_Box.LargeSmithBODAmount >= 2)
				{
					m_Box.LargeSmithBODAmount -= 2;
					m_From.AddToBackpack(new LargeSmithBOD());
					m_From.SendGump(new BODExchangeBoxGump(m_From, m_Box));
				}
				else
				{
					m_From.SendMessage("You do not have enough Large Smith BODs!");
					m_From.SendGump(new BODExchangeBoxGump(m_From, m_Box));
				}
			}
			
			//Carp
			if (info.ButtonID == 5)
			{
				if (m_Box.SmallCarpBODAmount >= 2)
				{
					m_Box.SmallCarpBODAmount -= 2;
					m_From.AddToBackpack(new SmallCarpenterBOD());
					m_From.SendGump(new BODExchangeBoxGump(m_From, m_Box));
				}
				else
				{
					m_From.SendMessage("You do not have enough Small Carpenter BODs!");
					m_From.SendGump(new BODExchangeBoxGump(m_From, m_Box));
				}
			}
			if (info.ButtonID == 6)
			{
				if (m_Box.LargeCarpBODAmount >= 2)
				{
					m_Box.LargeCarpBODAmount -= 2;
					m_From.AddToBackpack(new LargeCarpenterBOD());
					m_From.SendGump(new BODExchangeBoxGump(m_From, m_Box));
				}
				else
				{
					m_From.SendMessage("You do not have enough Large Carpenter BODs!");
					m_From.SendGump(new BODExchangeBoxGump(m_From, m_Box));
				}
			}

			if (info.ButtonID == 7)
			{
				if (m_Box.SmallFletchBODAmount >= 2)
				{
					m_Box.SmallFletchBODAmount -= 2;
					m_From.AddToBackpack(new SmallFletcherBOD());
					m_From.SendGump(new BODExchangeBoxGump(m_From, m_Box));
				}
				else
				{
					m_From.SendMessage("You do not have enough Small Fletcher BODs!");
					m_From.SendGump(new BODExchangeBoxGump(m_From, m_Box));
				}
			}
			if (info.ButtonID == 8)
			{
				if (m_Box.LargeFletchBODAmount >= 2)
				{
					m_Box.LargeFletchBODAmount -= 2;
					m_From.AddToBackpack(new LargeFletcherBOD());
					m_From.SendGump(new BODExchangeBoxGump(m_From, m_Box));
				}
				else
				{
					m_From.SendMessage("You do not have enough Large Fletcher BODs!");
					m_From.SendGump(new BODExchangeBoxGump(m_From, m_Box));
				}
			}
			if (info.ButtonID == 0)
			{
				m_From.CloseGump(typeof(BODExchangeBoxGump));
			}
			
		}

	}
}
