using System;
using Server.Mobiles;
using Server.Network;
using Server.Prompts;
using Server.Multis;
using System.Collections;
using System.Collections.Generic;

namespace Server.Items
{
	public class BlessBag : BaseContainer, IDyable
	{
		public override int DefaultMaxItems { get { return 15; } }
		//To know who is the owner
		private Mobile m_Owner;
		// Get Set
		[CommandProperty( AccessLevel.GameMaster )]
		public Mobile Owner
		{
			get{ return m_Owner; }
			set{ m_Owner = value; }
		}

		[Constructable]
		public BlessBag() : base( 0xE76 )
		{
			LootType = LootType.Blessed;
			Name ="Blessed Bag";
			Hue = 1264;
			Weight = 2.0;
		}
		
		public override void OnDoubleClick( Mobile from )
		{
			if( Owner == null )
			{
				Owner = from;
				// this.Name =  from.Name + this.Name; //old set owner name
			}
			else if ( !IsChildOf( from.Backpack ) )
			{
				from.SendLocalizedMessage( 1042001 ); // That must be in your pack for you to use it.
			}
			else if( Owner == from || from.AccessLevel > Owner.AccessLevel )
			{
				base.OnDoubleClick( from );
			}
			else
				from.SendMessage( "You are not the owner!" ); //You are not the owner.
		}

		public override void GetProperties( ObjectPropertyList list )
		{
			base.GetProperties( list );
			
			if ( m_Owner != null )
				list.Add( 1072304, m_Owner.Name ); // owned by ~1_NAME~
		}
		
		public BlessBag( Serial serial ) : base( serial )
		{
		}

		public bool Dye( Mobile from, DyeTub sender )
		{
			if ( Deleted ) return false;
			Hue = sender.DyedHue;
			return true;
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
			//Save
			writer.Write( (Mobile) m_Owner );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
			
			switch ( version )
			{
				case 0:
					{ //load
						m_Owner = reader.ReadMobile();
						break;
					}
			}//set props on load
			if( Owner == null )
				Name = "No OWNER"+ this.Name;
		}

	}
}
