// All thanks goes to Cyberspud for the original script.
// Modified for RunUO2 18 June 2006 (Xeraz)

using System;
using System.Collections;
using Server;
using Server.Items;
using Server.Network;
using Server.Mobiles;
using Server.Accounting;
using Server.Gumps;
using Server.Commands;


namespace Server.Items
{
	[FlipableAttribute( 0xE41, 0xE40 )]
	public class DonationBox : LockableContainer
	{


		private bool m_AutoLock;
		private InternalTimer m_RelockTimer;

		[CommandProperty( AccessLevel.GameMaster )]
		public bool AutoLock
		{
			get { return m_AutoLock; }
			set
			{
				m_AutoLock = value;

				if ( !m_AutoLock )
					StopTimer();
				else if ( !Locked && m_RelockTimer == null )
					m_RelockTimer = new InternalTimer( this );
			}
		}

		public static int MaxDonations = 10; // maximum number of donations

		public override bool Decays{ get{ return false; } }
		public override bool TrapOnOpen{ get{ return false; } }
		public override int DefaultGumpID{ get{ return 0x42; } }
		public override int DefaultDropSound{ get{ return 0x42; } }

		public override Rectangle2D Bounds
		{
			get{ return new Rectangle2D( 16, 51, 168, 73 ); }
		}
		[Constructable]
		public DonationBox() : base( 0xE41 )
		{
			//Hue = 1160;
			Hue = 2122;
			Movable = false;
			Name = "a donation box";
			LiftOverride = true;
			
		}

		public DonationBox( Serial serial ) : base( serial )
		{
		}


		[CommandProperty( AccessLevel.GameMaster )]
		public override bool Locked
		{
			get { return base.Locked; }
			set
			{
				base.Locked = value;

				if ( m_AutoLock )
				{
					StopTimer();

					if ( !Locked )
						m_RelockTimer = new InternalTimer( this );
				}
			}
		}


		public void StopTimer()
		{
			if ( m_RelockTimer != null )
				m_RelockTimer.Stop();

			m_RelockTimer = null;
		}

		private class InternalTimer : Timer
		{
			private DonationBox m_Container;
			private DateTime m_RelockTime;

			public DonationBox Container { get { return m_Container; } }
			public DateTime RelockTime { get { return m_RelockTime; } }

			public InternalTimer( DonationBox container ) : this( container, TimeSpan.FromMinutes( 5.0 ) )
			{
			}

			public InternalTimer( DonationBox container, TimeSpan delay ) : base( delay )
			{
				m_Container = container;
				m_RelockTime = DateTime.Now + delay;
				Priority = TimerPriority.OneMinute;

				Start();
			}

			protected override void OnTick()
			{
				m_Container.Locked = true;
				m_Container.LockLevel = -255;
			}
		}



		public override void OnDoubleClick(Mobile from)
		{
			//make sure they are a "newbie" or a GM
			if ( from.AccessLevel >= AccessLevel.GameMaster )
				this.SendLocalizedMessageTo(from,1042971,"Jako GM mas do truhly pristup.");
			else if( !(CheckTag(from)) )
			{
				//Greedy!
				this.SendLocalizedMessageTo(from,1042971,"Jiz jsi si  z truhly vzal/a prilis mnoho veci.  Bohatstvi neni cnost.");
				return;
			}
			else if( CanGet(from) )
				this.SendLocalizedMessageTo(from,1042971,"Jako nove prichozi mas do truhly pristup.");
			else
			{
				this.SendLocalizedMessageTo(from,1042971,"Do truhly maji pristup pouze novacci.");
				return;
			}

			base.OnDoubleClick (from);

			//increase tag
			if( from.AccessLevel == AccessLevel.Player )
				IncreaseTag( from, 1);

			//show gump
			from.CloseGump( typeof(DonationBoxGump) );
			from.SendGump( new DonationBoxGump( from, MaxDonations ) );
		}

		public override void OnTelekinesis(Mobile from)
		{
			from.SendLocalizedMessage( 501857 ); //This spell won't work on that!
		}

		public override bool OnDragDropInto( Mobile from, Item item, Point3D p )
		{
			//make sure it is a valid item
			if( ValidItem( item ) )
			{
				if ( ValidStack( item) )
				{
					return base.OnDragDropInto( from, item, p );
				}
				else
				{
					this.SendLocalizedMessageTo(from,1042971,"Pokud se jedna o predmet ktery se stohuje, musi byt mnozstvi minimalne 50.");
					return false;
				}
			}
			this.SendLocalizedMessageTo(from,1042971,"Tento predmet nemuzes dat do truhly.");
			return false;
		}

		public override bool OnDragDrop(Mobile from, Item dropped)
		{
			//make sure it is a valid item
			if( ValidItem( dropped ) )
			{
				if ( ValidStack( dropped) )
				{
					this.SendLocalizedMessageTo(from,1042971,"Dekujeme za prispevek!");
					if( from.Female )
					{
						from.PlaySound( 780 ); //applause
						from.PlaySound( 783 ); //cheer
					}
					else
					{
						from.PlaySound( 1051 ); //applause
						from.PlaySound( 1054 ); //cheer
					}
					return base.OnDragDrop( from, dropped );
				}
				else
				{
					this.SendLocalizedMessageTo(from,1042971,"Pokud se jedna o predmet ktery se stohuje, musi byt mnozstvi minimalne 50.");
					return false;
				}
			}
			
			this.SendLocalizedMessageTo(from,1042971,"Tento predmet nemuzes dat do truhly.");
			return false;
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 1 ); // version


			writer.Write( m_AutoLock );

			if ( !Locked && m_AutoLock )
				writer.WriteDeltaTime( m_RelockTimer.RelockTime );


		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();


			m_AutoLock = reader.ReadBool();

			if ( !Locked && m_AutoLock )
				m_RelockTimer = new InternalTimer( this, reader.ReadDeltaTime() - DateTime.Now );



		}

		public void IncreaseTag( Mobile player, int amount )
		{
			Account acct = player.Account as Account;

			if ( acct == null )
				return;
			
			
			string tag = acct.GetTag( "numDonations" );

			int cur;

			if ( tag == null || tag == "" )
				cur = 0;
			else
				cur = Utility.ToInt32( tag );

			acct.SetTag( "numDonations", (cur + 1).ToString() );

		}

		public bool CheckTag( Mobile player )
		{

			Account acct = player.Account as Account;

			if ( acct == null )
				return false;
			
			//acct.SetTag( "numRewardsChosen", (cur + 1).ToString() );
			string tag = acct.GetTag( "numDonations" );

			int cur;

			if ( tag == null || tag == "" )
				cur = 0;
			else
				cur = Utility.ToInt32( tag );

			if( cur < MaxDonations )
				return true;
			return false;
		}

		public bool CanGet( Mobile player )
		{
			TimeSpan JoinGameAge = TimeSpan.FromDays( 2.0 );

			PlayerMobile pm = (PlayerMobile)player;

			//player.SendMessage("GameTime: {0}",pm.GameTime);
			//player.SendMessage("TotalSkills: {0}",pm.SkillsTotal);

			//online time
			if ( pm.GameTime > JoinGameAge )
				return false;
			//skills
// 			if ( pm.SkillsTotal > 3500 )
// 				return false;

			return true;
		}

		public bool ValidItem( Item item )
		{
			if( item is BaseWeapon   ||
			   item is BaseArmor    ||
			   item is Gold         ||
			   item is BaseIngot    ||
			   item is BaseBoard    ||
			   item is BasePiece    ||
			   item is Log          ||
			   item is Board        ||
			   item is Feather      ||
			   item is Cloth        ||
			   item is BaseLeather  ||
			   item is Food         ||
			   item is Bolt         ||
			   item is Arrow        ||
			   item is Bone         ||
			   item is BaseReagent  ||
			   item is Bottle       ||
			   item is BankCheck    ||
			   item is BaseJewel    ||
			   item is Spellbook    ||
			   item is SpellScroll  ||
			   item is BaseOre      ||
			   item is BaseScales   ||
			   item is BaseClothing ||
			   item is BaseAddonDeed ||
			   item is BaseRanged   ||
			   item is Bandage      ||
			   item is PowerScroll  ||
			   item is StatCapScroll  ||
			   item is PowderOfTranslocation  ||
			   item is PowderOfTemperament  ||
			   item is BaseShield )
				return true;

			return false;
		}

		public bool ValidStack( Item item )
		{
			if( item.Stackable )
			{
				if( item.Amount >= 50 )
					return true;
				else
					return false;
			}
			return true;
		}

	}

	public class DonationBoxGump : Gump
	{
		private Mobile m_from;
		private int m_max;

		public DonationBoxGump( Mobile from, int max ) : base(50, 50)
		{
			m_from = from;
			m_max = max;
			this.InitializeGump();
		}
		public override void OnResponse(NetState sender, RelayInfo info)
		{
		}
		public virtual void InitializeGump()
		{
			this.Closable = true;
			this.Disposable = true;
			this.Dragable = true;
			// Initializing Page
			this.AddPage(0);
			// Initializing Background
			this.AddBackground(10, 10, 270, 216, 5054);
			// Initializing Label
			this.AddLabel(90, 19, 255, "The Donation Box");
			// Initializing Background
			this.AddBackground(16, 39, 255, 183, 83);
			// Initializing Image
			this.AddImage(250, 20, 216);
			// Initializing Image
			this.AddImage(25, 20, 216);
			// Initializing AlphaRegion
			this.AddAlphaRegion(25, 50, 240, 162);
			
			// Initializing Html
			string temp = "";
			
			if( m_from.AccessLevel == AccessLevel.Player )
				temp = "Truhlu jsi jiz otevrel/a " + GetNumberofDonations( m_from )  + " z " + m_max.ToString() + " moznych pristupu.<br><br>";
			else
				temp = "Jako GM muzes truhlu otevirat neomezene.<br><br>";

			temp += "Donation Box - myslenka teto truhly je jednoducha:  starsi hraci muzou do truhly vkladat predmety na ktere pomuzou nove prichozim v zacatcich.<br><br>";
			temp += "Aby se zamezilo zneuziti truhly a veci byly spravedlive rozdeleny, kazdy novy hrac muze truhlu otevrit pouze nekolikrat.<Br><Br>";
			temp += "Pamatuj, bohatstvi neni cnost.<br><br>";
			temp += "A na zaver, pokud si jako novy hrac vemes nejaky predmet, nezapomen az budes mit na rozdavani prispet i ty na pomoc dalsim novym hracum.";

			this.AddHtml(28, 53, 230, 155, temp, false, true);
		}

		public int GetNumberofDonations( Mobile player )
		{
			Account acct = player.Account as Account;

			if ( acct == null )
				return 0;
			
			//acct.SetTag( "numRewardsChosen", (cur + 1).ToString() );
			string tag = acct.GetTag( "numDonations" );

			int cur;

			if ( tag == null || tag == "" )
				cur = 0;
			else
				cur = Utility.ToInt32( tag );

			return cur;
		}
	}
}
