using System;
using System.Collections;
using System.Collections.Generic;
using Server.Network;
using Server.Multis;
using Server.Network;

namespace Server.Items
{
   [Furniture]
	[Flipable( 0x9AA, 0xE7D, 0x9A9, 0xE7E, 0xE3F, 0xE3E, 0xE3D, 0xE3C, 0x9A8, 0xE80, 0xE77, 0xE7F, 0x990 )]
	public class MailBox : BaseContainer
	{
		public override int DefaultGumpID{ get{ return 0x43; } }
		public override int DefaultDropSound{ get{ return 0x42; } }
      public override int DefaultMaxWeight
		{
			get
			{
				if ( IsSecure )
					return 0;

				return base.DefaultMaxWeight;
			}
		}
		
		public override Rectangle2D Bounds
		{
			get{ return new Rectangle2D( 16, 51, 168, 73 ); }
		}

		[Constructable]
		public MailBox() : base( 0x9AA )
		{
			Name = "Postovni schranka";
         Weight = 4.0;
		}
		
		public override bool OnDragDrop(Mobile from, Item dropped)
		{
			return base.OnDragDrop( from, dropped );
		}
		
		public override bool IsAccessibleTo( Mobile m )
		{
			return true;
		}
		
		public override void OnDoubleClick( Mobile from )
		{
			if ( !BaseHouse.CheckAccessible( from, this ) )
			{
            from.SendMessage( "Nemas do schranky pristup." );
         }
			else
			{
            if ( from.AccessLevel > AccessLevel.Player || from.InRange( this.GetWorldLocation(), 2 ) )
				  Open( from );
			   else
				  from.LocalOverheadMessage( MessageType.Regular, 0x3B2, 1019045 ); // I can't reach that.
         }
		}
			
		public MailBox( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}