using Server.Gumps;
using Server.Network;

namespace Server.Items
{
    [FlipableAttribute(0xE79, 0x9B0)]
    public class PlantBag : Bag
    {
        private int m_GinsengPlant;
        private int m_MandrakePlant;
        private int m_NightshadePlant;

        [CommandProperty(AccessLevel.GameMaster)]
        public int GinsengPlant { get { return m_GinsengPlant; } set { m_GinsengPlant = value; InvalidateProperties(); } }

        [CommandProperty(AccessLevel.GameMaster)]
        public int MandrakePlant { get { return m_MandrakePlant; } set { m_MandrakePlant = value; InvalidateProperties(); } }

        [CommandProperty(AccessLevel.GameMaster)]
        public int NightshadePlant { get { return m_NightshadePlant; } set { m_NightshadePlant = value; InvalidateProperties(); } }

        public override bool DisplayWeight { get { return false; } }
        public override bool DisplaysContent { get { return false; } }

        [Constructable]
        public PlantBag() : base()
        {
            Weight = 4.0;
            ItemID = 0xE79;
            Name = "Plant Pouch";
            LootType = LootType.Blessed;
            // 			Hue = 768;
        }

        public override bool OnDragDropInto(Mobile from, Item dropped, Point3D p)
        {
            return false;
        }

        public override bool OnDragDrop(Mobile from, Item dropped)
        {
            // 			if ( !base.OnDragDrop( from, dropped ) )
            // 			   return false;

            if (dropped is GinsengPlant || dropped is MandrakePlant || dropped is NightshadePlant)
            {
                if (dropped is GinsengPlant)
                    GinsengPlant++;
                else if (dropped is MandrakePlant)
                    MandrakePlant++;
                else if (dropped is NightshadePlant)
                    NightshadePlant++;

                dropped.Delete();
                from.PlaySound(DefaultDropSound);

                if (from.HasGump(typeof(PlantBagGump)))
                    from.CloseGump(typeof(PlantBagGump));

                return true;
            }

            from.SendMessage("Tento baglik je pouze na rostlinky pro pety.");
            return false;
        }

        public override void OnDoubleClick(Mobile from)
        {
            if (from.AccessLevel > AccessLevel.Player)
            {
                from.SendGump(new PlantBagGump(this));
                return;
            }

            if (!from.InRange(GetWorldLocation(), 2))
                from.LocalOverheadMessage(Network.MessageType.Regular, 0x3B2, 1019045); // I can't reach that.
            else
            {
                if (from.HasGump(typeof(PlantBagGump)))
                    from.CloseGump(typeof(PlantBagGump));

                from.SendGump(new PlantBagGump(this));
                from.PlaySound(DefaultDropSound);
            }
        }

        public override void GetProperties(ObjectPropertyList list)
        {
            base.GetProperties(list);
            list.Add(1060661, "Celkem rostlinek\t{0}", (m_GinsengPlant + m_MandrakePlant + m_NightshadePlant));
            // 			if (m_Label1 != null)
            // 				list.Add( 1060658, "{0}\t{1}", m_Label1.ToString(), String.Format("{0}/{1}", m_Key1_cur, m_Key1_max ) );
            // 			if (m_Label2 != null)
            // 				list.Add( 1060659, "{0}\t{1}", m_Label2.ToString(), String.Format("{0}/{1}", m_Key2_cur, m_Key2_max ) );
            // 			if (m_Label3 != null)
            // 				list.Add( 1060660, "{0}\t{1}", m_Label3.ToString(), String.Format("{0}/{1}", m_Key3_cur, m_Key3_max ) );
        }

        private class PlantBagGump : Gump
        {
            private PlantBag bag;

            public PlantBagGump(PlantBag plantbag) : base(200, 200)
            {
                bag = plantbag;

                if (bag == null) return;

                this.Closable = true;
                this.Disposable = true;
                this.Dragable = true;
                this.Resizable = false;

                this.AddPage(0);
                this.AddImage(0, 0, 61);
                this.AddItem(15, 27, 6380);
                this.AddTooltip(1015009); //Ginseng
                this.AddItem(13, 73, 6365);
                this.AddTooltip(1015013); //Mandrake
                this.AddItem(12, 107, 6373);
                this.AddTooltip(1015016); //Nightshade
                                          // 				this.AddButton(156, 10, 22150, 22151, (int)Buttons.Close, GumpButtonType.Reply, 0);
                this.AddLabel(90, 44, 40, bag.GinsengPlant.ToString("N0", Auberon.Chat.General.Nfi));
                this.AddLabel(90, 78, 69, bag.MandrakePlant.ToString("N0", Auberon.Chat.General.Nfi));
                this.AddLabel(90, 108, 294, bag.NightshadePlant.ToString("N0", Auberon.Chat.General.Nfi));
                this.AddButton(65, 46, 5601, 5605, (int)Buttons.Ginseng, GumpButtonType.Reply, 0);
                this.AddTooltip(1062986); //Withdraw Request
                this.AddButton(65, 80, 5601, 5605, (int)Buttons.Mandrake, GumpButtonType.Reply, 0);
                this.AddTooltip(1062986); //Withdraw Request
                this.AddButton(65, 110, 5601, 5605, (int)Buttons.Nightshade, GumpButtonType.Reply, 0);
                this.AddTooltip(1062986); //Withdraw Request
            }

            public enum Buttons
            {
                Close,
                Ginseng,
                Mandrake,
                Nightshade,
            }

            public override void OnResponse(NetState sender, RelayInfo info)
            {
                Mobile from = sender.Mobile;

                if (from == null || bag == null || bag.Deleted)
                    return;
                else if (!from.InRange(bag.GetWorldLocation(), 5))
                {
                    from.SendMessage("Jsi od {0} prilis daleko!", bag.Name);

                    if (from.HasGump(typeof(PlantBagGump)))
                        from.CloseGump(typeof(PlantBagGump));

                    return;
                }

                switch (info.ButtonID)
                {
                    case (int)Buttons.Close:
                        {
                            return;
                            break;
                        }
                    case (int)Buttons.Ginseng:
                        {
                            if (bag.GinsengPlant > 0)
                            {
                                bag.GinsengPlant--;
                                from.AddToBackpack(new GinsengPlant());
                            }
                            break;
                        }
                    case (int)Buttons.Mandrake:
                        {
                            if (bag.MandrakePlant > 0)
                            {
                                bag.MandrakePlant--;
                                from.AddToBackpack(new MandrakePlant());
                            }
                            break;
                        }
                    case (int)Buttons.Nightshade:
                        {
                            if (bag.NightshadePlant > 0)
                            {
                                bag.NightshadePlant--;
                                from.AddToBackpack(new NightshadePlant());
                            }
                            break;
                        }
                }

                from.PlaySound(bag.DefaultDropSound);
                from.SendGump(new PlantBagGump(bag));
            }
        }

        public PlantBag(Serial serial) : base(serial)
        {
        }

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);
            writer.Write((int)1); // version

            writer.Write((int)m_GinsengPlant);
            writer.Write((int)m_MandrakePlant);
            writer.Write((int)m_NightshadePlant);
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);
            int version = reader.ReadInt();

            switch (version)
            {
                case 1:
                    {
                        goto case 0;
                    }
                case 0:
                    {
                        m_GinsengPlant = reader.ReadInt();
                        m_MandrakePlant = reader.ReadInt();
                        m_NightshadePlant = reader.ReadInt();
                        break;
                    }
            }

            if (version == 0)
            {
                ItemID = 0xE79;
                Name = "Plant Pouch";
            }
        }
    }
}
