using System;
using System.Collections;
using System.Collections.Generic;
using Server.Network;

namespace Server.Items
{
	[Flipable(0xE41, 0xE40)]
	public class SecureStash : Container
	{
		public const int UWStashSerial = 0x4012DC07; //0x4012DC07 Seriove cislo UW truhly LIVE SERVER

		public override int DefaultGumpID { get { return 0x43; } }
		public override int DefaultDropSound { get { return 0x42; } }
		public override Rectangle2D Bounds { get { return new Rectangle2D(16, 51, 168, 73); } }
		public override int DefaultMaxWeight { get { return 0; } }
		public override int DefaultMaxItems { get { return 3000; } }
		public override bool Decays { get { return false; } }
		public override bool DisplayWeight { get { return false; } }
		public override bool DisplaysContent { get { return false; } }

		[Constructable]
		public SecureStash() : base(0xE41)
		{
			Weight = 1.0;
			Hue = 546;
			Movable = false;
			Name = "secure stash";
			LiftOverride = true;
		}

		public override void OnDoubleClick(Mobile from)
		{
			if (from.AccessLevel > AccessLevel.GameMaster)
			{
				DisplayTo(from);
			}
			else if (from.InRange(this.GetWorldLocation(), 2))
			{
				//otevreni truhly hrace
				SecureStashBox box = (SecureStashBox) SearchStash(from);

				if (box == null)
					from.PrivateOverheadMessage(MessageType.Regular, 0x3B2, true, String.Format("Bezpecnostni truhla je plna!"), from.NetState);
				else
				{
					DisplayTo(from);
					box.DisplayTo(from);
					//                from.Send( new ContainerDisplay( box ) );
					// 			      from.Send( new ContainerContent( from, box ) );
					from.PrivateOverheadMessage(MessageType.Regular, 0x3B2, true, String.Format("Ve tve bezpecnostni truhle je {0} predmetu o hmotnosti {1} stones", box.TotalItems, box.TotalWeight), from.NetState);
				}
			}
			else
				from.SendLocalizedMessage(500446); // That is too far away.
		}

		public SecureStashBox SearchStash(Mobile from)
		{
			SecureStashBox box = null;
			List<Item> items = this.Items;
			ArrayList toDelete = new ArrayList();;

			for (int a = 0; a < items.Count; ++a)
			{
				Item obj = items[a];

				if (obj is SecureStashBox)
				{
					if (((SecureStashBox)obj).Owner == null)
						toDelete.Add(obj);
					else if (((SecureStashBox)obj).Owner == from)
						box = (SecureStashBox) obj;
					else if (((SecureStashBox)obj).LastAccess < (DateTime.Now - TimeSpan.FromDays(60.0)))
						toDelete.Add(obj);
				}
				else
					toDelete.Add(obj);
			}

			foreach (Item item in toDelete)
				item.Delete();

			if (box == null)//novy box
			{
				box = new SecureStashBox();
				box.Owner = from;

				if (!this.TryDropItem(from, box, false))
				{
					box.Delete();
					from.SendMessage(34, "Tvoji bezpecnostni truhlu se nepodarilo vytvorit!");
					return null;
				}
				else
					from.SendMessage(34, "Tva bezpecnostni truhla byla vytvorena. (Zivotnost 60 dni od posledniho pouziti!)");

				if (this.Serial == UWStashSerial)
				{
					box.MaxItems = 50;
					box.DropItem(new TinkerTools( 5 ));
					box.DropItem(new Shovel( 25 ));
					box.DropItem(new TrashPack());
					
					// PotionPouch pouch = new PotionPouch();
					// pouch.BlessedFor = from;
					// box.DropItem(pouch);
				}
			}

			if (box != null)
				box.LastAccess = DateTime.Now;

			return box;
		}

		public static bool DropToStash(Item dropped, Mobile from)
		{
			SecureStash stash = null;

			foreach (Item item in World.Items.Values)
			{
				if (item is SecureStash && item.Serial == UWStashSerial) //Seriove cislo UW truhly
					stash = (SecureStash) item;
			}

			if (stash == null || stash.Deleted || dropped == null || dropped.Deleted || from == null)
				return false;

			SecureStashBox box = (SecureStashBox) stash.SearchStash(from);

			if (box == null)
				return false;

			box.DropItem(dropped);
			return true;
		}
		
		public static void DepositGold( int amount, Mobile from )
		{
			if (from == null || amount < 1)
				return;
			
			while ( amount > 0 )
			{
				Item item = new Gold();
				
				if ( amount <= 60000 )
				{
					item.Amount = amount;
					amount = 0;
				}
				else
				{
					item.Amount = 60000;
					amount -= 60000;
				}

				DropToStash(item, from);
			}
		}
		
		/*public override bool CheckLift( Mobile from, Item item, ref LRReason reject )
		{
		 	if ( from.AccessLevel >= AccessLevel.GameMaster )
		 		return base.CheckLift( from, item, ref reject );
			else
		 		return false;
		}*/

		public override void OnSnoop(Mobile from)
		{
		}

		public override void OnSingleClick(Mobile from)
		{
		}

		public override bool OnDragDrop(Mobile from, Item dropped)
		{
			if (from.AccessLevel >= AccessLevel.GameMaster)
				return base.OnDragDrop(from, dropped);
			else
				return false;
		}

		public override bool OnDragDropInto(Mobile from, Item item, Point3D p)
		{
			if (from.AccessLevel >= AccessLevel.GameMaster)
				return base.OnDragDropInto (from, item, p);
			else
				return false;
		}

		public SecureStash(Serial serial) : base(serial)
		{
		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);

			writer.Write((int) 0); // version
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);

			int version = reader.ReadInt();
		}
	}
}