using System;
using Server.Mobiles;
using Server.Network;
using Server.Prompts;
using Server.Multis;
using System.Collections;
using System.Collections.Generic;

namespace Server.Items
{
	public class SecureStashBox : Container
	{
		private Mobile m_Owner;
		private DateTime m_LastAccess;

		[CommandProperty(AccessLevel.GameMaster)]
		public DateTime LastAccess { get { return m_LastAccess; } set { m_LastAccess = value; } }

		[CommandProperty(AccessLevel.GameMaster)]
		public Mobile Owner
		{
			get { return m_Owner; }
			set { m_Owner = value; this.Name = m_Owner.RawName; }
		}

		public override bool IsVirtualItem { get { return true; } }
		public override int DefaultGumpID { get { return 0x42; } }
		public override int DefaultDropSound { get { return 0x42; } }
		public override Rectangle2D Bounds { get { return new Rectangle2D(18, 105, 144, 73); } }
		public override int DefaultMaxWeight { get { return 0; } }
		public override int DefaultMaxItems { get { return 30; } }
		public override bool DisplayWeight { get { return false; } }

		[Constructable]
		public SecureStashBox() : base(0xE79)
		{
			LiftOverride = true;
			Name = "Bez Majitele";
			Weight = 0.0;
			Movable = false;
		}

		public override void OnDoubleClick(Mobile from)
		{
			if((m_Owner != null && m_Owner == from) || from.AccessLevel >= AccessLevel.GameMaster)
				base.OnDoubleClick(from);
			else
				from.SendMessage("Pristup zamitnut!");
		}

		public override bool IsAccessibleTo(Mobile from)
		{
			if((m_Owner != null && m_Owner == from) || from.AccessLevel >= AccessLevel.GameMaster)
				return base.IsAccessibleTo(from);
			else
				return false;
		}

		public SecureStashBox(Serial serial) : base(serial)
		{
		}

		public override bool CheckLift(Mobile from, Item item, ref LRReason reject)
		{
			if((m_Owner != null && m_Owner == from) || from.AccessLevel >= AccessLevel.GameMaster)
				return base.CheckLift(from, item, ref reject);
			else
				return false;
		}

		public override void OnSnoop(Mobile from)
		{
		}

		public override void OnSingleClick(Mobile from)
		{
		}

		public override bool OnDragDrop(Mobile from, Item dropped)
		{
			if((m_Owner != null && m_Owner == from) || from.AccessLevel >= AccessLevel.GameMaster)
				return base.OnDragDrop(from, dropped);
			else
				return false;
		}

		public override bool OnDragDropInto(Mobile from, Item item, Point3D p)
		{
			if((m_Owner != null && m_Owner == from) || from.AccessLevel >= AccessLevel.GameMaster)
				return base.OnDragDropInto (from, item, p);
			else
				return false;
		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);

			writer.Write((int) 0); // version

			writer.Write((Mobile) m_Owner);
			writer.Write(m_LastAccess);
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);

			int version = reader.ReadInt();

			switch (version)
			{
				case 0:
				{
					m_Owner = reader.ReadMobile();
					m_LastAccess = reader.ReadDateTime();
					break;
				}
			}

			if(Owner == null || (m_LastAccess < DateTime.Now - TimeSpan.FromDays(60.0)))
				this.Delete();
		}
	}
}