#region AuthorHeader
//
//	SpellCrafting version 1.0, by Partystuffcloseouts/Soultaker
//
//  Based on original ideas and code by Xanthos and TheOutkastDev
//
#endregion AuthorHeader
using System;
using System.Collections;
using Server;
using Server.Mobiles;

namespace Server.SeedFlowerVendor.Mobiles
{
	public class SeedFlowerVendor : BaseVendor
	{
		private ArrayList m_SBInfos = new ArrayList();
		protected override ArrayList SBInfos{ get { return m_SBInfos; } }

		[Constructable]
		public SeedFlowerVendor() : base( "the Seed & Flower Vendor" )
		{
			SetSkill( SkillName.Alchemy, 90.0, 100.0 );
			SetSkill( SkillName.Magery, 90.0, 100.0 );
		}

		public override void InitSBInfo()
		{
			m_SBInfos.Add( new SBSeedBox() );
		}

		public override VendorShoeType ShoeType
		{
			get{ return VendorShoeType.Sandals; }
		}

		public override void InitOutfit()
		{
			base.InitOutfit();

			int hue = Utility.RandomNeutralHue();
			AddItem( new Server.Items.Robe( hue ) );
			AddItem( new Server.Items.WizardsHat( hue ) );
		}

		public SeedFlowerVendor( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}
