using System;
using Server;

namespace Server.Items
{
	[FlipableAttribute( 0x24DA, 0x24D9 )]
	public class SpellbookBasket : BaseContainer
	{
		[Constructable]
		public SpellbookBasket() : base( 0x24DA )
		{
			Name = "Kosik na knihy";
			Movable = true;
			// 			Hue = 2114;
			LootType = LootType.Blessed;
			Weight = 1.0;
		}

		public SpellbookBasket( Serial serial ) : base( serial )
		{
		}
		
		public override bool OnDragDropInto( Mobile from, Item dropped, Point3D p )
		{
			if( AcceptItem( dropped ) )
			{
				return base.OnDragDropInto( from, dropped, p );
			}
			from.SendMessage("Tento kosik je pouze na urcene knihy.");
			return false;
		}

		public override bool OnDragDrop(Mobile from, Item dropped)
		{
			if( AcceptItem( dropped ) )
			{
				return base.OnDragDrop( from, dropped );
			}
			from.SendMessage("Tento kosik je pouze na urcene knihy.");
			return false;
		}

		private bool AcceptItem( Item dropped )
		{
			return ( dropped is Spellbook || dropped is MonsterContractBook || dropped is CheckBook || dropped is Engines.BulkOrders.BulkOrderBook
          || dropped is Runebook || dropped is RegBook || dropped is SOSBookT || dropped is TMapBook || dropped is TokenBox );
		}
		
		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.WriteEncodedInt( 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadEncodedInt();
		}
	}
}
