using System;
using Server.Items;
using Server.Gumps;
using Server.Network;
using Server.Mobiles;
using System.Collections;
using System.Collections.Generic;

namespace Server.Gumps
{
	public class CorpseStone : Item
	{
		private int m_Price;

		[CommandProperty(AccessLevel.GameMaster)]
		public int Price
		{
			get { return m_Price; }
			set { m_Price = value; }
		}

		[Constructable]
		public CorpseStone() : this(500)
		{
		}

		[Constructable]
		public CorpseStone(int price) : base(0xED4)
		{
			Movable = false;
			Hue = 1109;
			Name = "A Corpse Stone";
			ItemID = 3805;
			m_Price = price;
		}

		public override void OnDoubleClick(Mobile from)
		{
			if (from.InRange(this.GetWorldLocation(), 2))
			{
				from.SendGump(new ScriptCorpseGump(m_Price));
				from.CantWalk = true;
			}
			else
			{
				from.SendLocalizedMessage(502138);
			}
		}

		public override void OnDoubleClickDead(Mobile m)
		{
			Ankhs.Resurrect(m, this);
		}

		public CorpseStone(Serial serial) : base(serial)
		{
		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);

			writer.Write((int) 0); // version

			writer.Write((int) m_Price);
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);

			int version = reader.ReadInt();

			m_Price = reader.ReadInt();
		}
	}
}

namespace Server.Gumps
{
	public class ScriptCorpseGump : Gump
	{
		private int m_Price;

		public ScriptCorpseGump(int price) : base(150, 50)
		{
			m_Price = price;

			this.Closable = false;
			this.Disposable = true;
			this.Dragable = true;
			this.Resizable = false;
			this.AddPage(0);
			this.AddBackground(0, 0, 318, 217, 2620);
			this.AddLabel(96, 12, 1152, @"Premisteni mrtvoly");
			this.AddLabel(55, 146, 1152, @"Najit a premistit moji mrtvolu");
			this.AddLabel(55, 178, 1152, @"Nechat moji mrtvolu tam kde je");
			string txt = "<BASEFONT COLOR=Red>Nevis jak se dostat pro svoji mrtvolu?<br>Zde si ji muzes nechat najit a premistit k tvym noham "
           + String.Format("za drobny poplatek <BASEFONT COLOR=White>{0} zlatych.<br>", price)
           + "<BASEFONT COLOR=#FF9966>Pokud bude mrtvola nalezena, budou penize vybrany z tveho bankovniho boxu.";
			this.AddHtml(13, 39, 292, 90, txt, (bool)false, (bool)false);
			this.AddRadio(15, 141, 9720, 9723, false, 1);
			this.AddRadio(15, 174, 9720, 9723, true, 0);
			this.AddButton(258, 179, 2074, 2075, 2, GumpButtonType.Reply, 0);
		}

		public override void OnResponse(NetState state, RelayInfo info)
		{
			Mobile from = state.Mobile;

			from.CloseGump(typeof(ScriptCorpseGump));

			if (info.ButtonID == 1 || info.ButtonID == 2)
			{
				ArrayList list = new ArrayList();

				foreach (Item item in World.Items.Values)
				{
					if (item is Corpse && !item.Deleted)
					{
						List<Item> items = ((Container)item).Items;

						if (((Corpse)item).Owner == from && items.Count > 0)
						{
							if (from.Map == Map.Underworld && item.Map != Map.Underworld)
								continue;
							
							list.Add(item);
						}
					}
				}

				if (list.Count > 0)
				{
					if (m_Price > 0)
					{
						if (info.IsSwitched(1))
						{
							if (Banker.Withdraw(from, m_Price))
							{
								from.SendLocalizedMessage(1060398, m_Price.ToString()); // Amount charged
								from.SendLocalizedMessage(1060022, Banker.GetBalance(from).ToString()); // Amount left, from bank
							}
							else
							{
								from.SendMessage("Bohuzel nemas v bance dostatek penez pro premisteni tve mrtvoly.");
								from.CantWalk = false;
								return;
							}
						}
						else
						{
							from.SendMessage("Tva mrtvola byla ponechana na puvodnim miste.");
							from.CantWalk = false;
							return;
						}
					}

					foreach (Corpse corpse in list)
					{
						corpse.Location = from.Location;
						corpse.Map = from.Map;
					}

					Effects.SendLocationParticles(EffectItem.Create(from.Location, from.Map, EffectItem.DefaultDuration), 0x3728, 10, 30, 5052);
					Effects.PlaySound(from.Location, from.Map, 0x201);
					from.CantWalk = false;
				}
				else
				{
					from.SendMessage("Nemas nikde zadnou svoji mrtvolu, ktera by obsahovala veci.");
					from.CantWalk = false;
				}

				list.Clear();
			}
		}
	}
}